.model medium, basic
.stack 20h
.386
.data
   defseg dw 0a000h
.code

public VSBlit
public VSDefSeg
public VSPeek16
public VSPeek32
public VSPoke16
public VSPoke32

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

;=======This sets the default segment========================================
VSDefSeg proc
      mov dx, bp
      mov bp, sp
      mov ax, [bp+4]      ;set segment
      mov defseg, ax
      mov bp, dx
      ret 2
VSDefSeg endp

;=======This pokes 16-bits into memory=======================================
VSPoke16 proc
      mov dx, bp
      mov bp, sp              ;bx = Stack pointer
      mov ax, defseg
      mov si, [bp+6]          ;read offset
      mov es, ax
      mov ax, [bp+4]          ;read value
      mov bp, dx              ;restore bp
      stosw                   ;write value
      ret 4
VSPoke16 endp

;=======This pokes 32-bits into memory=======================================
VSPoke32 proc
      mov dx, bp
      mov bp, sp
      mov ax, defseg
      mov si, [bp+8]          ;set offset
      mov es, ax
      mov eax, [bp+4]         ;read value
      stosd
      mov bp, dx
      ret 6
VSPoke32 endp

;=======This peeks 16-bits from memory=======================================
VSPeek16 proc
      mov dx, bp
      mov bp, sp
      mov bx, ds
      mov ax, defseg
      mov si, [bp+4]          ;read offset
      mov ds, ax
      lodsw                   ;read value
      mov bp, dx
      mov ds, bx
      ret 2
VSPeek16 endp

;=======This peeks 32-bits from memory=======================================
VSPeek32 proc
      mov cx, bp
      mov bp, sp
      mov bx, ds
      mov ax, defseg
      mov si, [bp+4]          ;read offset
      mov ds, ax
      lodsd                   ;read value
      mov dx, [si+2]
      mov bp, cx
      mov ds, bx
      ret 2
VSPeek32 endp

;=======This transfers a chunk of memory=====================================
VSBlit proc
      mov dx, ds
      mov ax, bp
      mov bp, sp

      mov cx, [bp+4]          ;# of bytes
      mov si, [bp+10]         ;set offset1
      mov di, [bp+6]          ;set offset2
      mov ds, [bp+12]         ;set segment1
      mov es, [bp+8]          ;set segment2
      shr cx, 2
      rep movsd               ;move it

      mov ds, dx
      mov bp, ax
      ret 10
VSBlit endp


end
