.model medium, basic
.stack 10h
.386
.data
   temp db ?
.code

public VSBorder
public VSClearKB
public VSDelay
public VSGraphics
public VSFadeBlack
public VSFadeWhite
public VSNegative
public VSRotatePalB
public VSRotatePalF
public VSText

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

;=======This sets screen 13h=================================================
VSGraphics proc
      mov ax, 13h
      int 10h
      ret
VSGraphics endp

;=======This sets screen 3===================================================
VSText proc
      mov ax, 3
      int 10h
      ret
VSText endp

;=======This draws a menu====================================================
VSBorder proc
      push bp
      mov di, ds
      mov bp, sp
      mov ds, [bp+22]         ;set segment
      mov dh, [bp+8]          ;color 2
      mov si, [bp+20]         ;set offset
      mov dl, [bp+10]         ;color 1

      mov bx, [bp+16]         ;bx=y1
      mov ah, bl
      shl bx, 6
      mov al, [bp+6]          ;color 3
      add bh, ah              ;bx=y1*320
      mov si, [bp+20]         ;si=offset
      add bx, [bp+18]         ;bx=bx+x1
      mov cx, [bp+18]         ;cx=x1
      add si, bx              ;si=pixel coord

   border1:
      mov [si], dl
      mov [si+320], dh
      inc cx
      mov [si+640], al
      inc si
      cmp cx, [bp+14]
      js border1

      mov [si], dh
      mov [si+638], dh

      mov [si+320], al
      mov cx, [bp+16]
      mov [si+639], dh
      add cx, 3
      mov [si+640], al
      add si, 960
   border2:
      mov [si-2], dx
      inc cx
      mov [si], al
      add si, 320
      cmp cx, [bp+12]
      js border2

      mov [si], al

      mov cx, [bp+14]
      mov ah, al
      mov [si-2], ax
      sub cx, 3
      mov [si-322], dh
      sub si, 3
   border3:
      mov [si-640], dl
      mov [si-320], dh
      dec cx
      mov [si], al
      dec si
      cmp cx, [bp+18]
      jg border3

      mov [si], dh
      mov cx, [bp+12]
      mov [si-320], dx
      mov [si-640], dx
      sub cx, 5
      mov [si-638], dh
      sub si, 960
   border4:
      mov [si], dx
      dec cx
      mov [si+2], al
      sub si, 320
      cmp cx, [bp+16]
      jg border4

      mov [si], dx
      mov [si-320], dl

      pop bp
      mov ds, di
      ret 18
vsborder endp

;=======This fades the screen to black=======================================
VsFadeBlack proc
      mov di, bp
      mov bp, sp
      mov cl, [bp+4]
   FadeBSub2:
      xor al, al              ;al = 0 (color 0)
   NextcolorB:
      mov si, ax              ;save ax
      mov dx, 3c7h
      out dx, al              ;output color #
      add dl, 2
      in al, dx               ;read red value
      mov ch, al              ;store red in temp1
      in al, dx               ;read green value in BL
      mov bl, al
      in al, dx               ;read blue value in BH
      mov bh, al

      cmp ch, 0               ;does red = 0?
      jz GreenB               ;  if yes, skip this
      dec ch                  ;  if no, decrement it
   GreenB:
      cmp bh, 0               ;does green = 0?
      jz BlueB                ;  if yes, skip this
      dec bh                  ;  if no, decrement it
   BlueB:
      cmp bl, 0               ;does blue = 0?
      jz ColorDoneB           ;  if yes, skip this
      dec bl                  ;  if no, decrement it
   ColorDoneB:
      mov ax, si              ;restore ax
      dec dl
      out dx, al            ;output color #

      inc dl
      mov al, ch              ;update red
      out dx, al
      mov al, bl              ;update green
      out dx, al
      mov al, bh              ;update blue
      out dx, al

      mov ax, si              ;restore ax
      inc al                  ;al = al + 1, finished with color 255?
      jnz NextColorB          ;  if no, fade next color
      mov ch, [bp+4]
      cmp ch, 2
      jng SkipDelayB          ;If value <3 then skip delay
      call DelaySub           ;Waits for verticle retrace (1/60s)
   SkipDelayB:
      dec cl                  ;cl = cl - 1, finished with fade?
      jge FadeBSub2            ;  if no, continue fade

      mov bp, di
      ret 2
VsFadeBlack endp

;=======This fades the screen to white=======================================
VsFadeWhite proc
      mov di, bp
      mov bp, sp
      mov cl, [bp+4]
   FadeWSub2:
      xor al, al              ;al = 0 (color 0)
   NextcolorW:
      mov dx, 3c7h
      mov si, ax              ;save ax
      out dx, al              ;output color #
      add dl, 2
      in al, dx               ;read red value
      mov ch, al              ;store red in temp1
      in al, dx               ;read green value
      mov bl, al
      in al, dx               ;read blue value
      mov bh, al

      cmp ch, 63              ;does red = 63?
      jz GreenW               ;  if yes, skip this
      inc ch                  ;  if no, increment it
   GreenW:
      cmp bl, 63              ;does green = 63?
      jz BlueW                ;  if yes, skip this
      inc bl                  ;  if no, increment it
   BlueW:
      cmp bh, 63              ;does blue = 63?
      jz ColorDoneW           ;  if yes, skip this
      inc bh                  ;  if no, increment it
   ColorDoneW:
      mov ax, si              ;restore ax
      dec dl                  ;dx = 3c8h
      out dx, al              ;output color #
      mov si, ax              ;save ax

      inc dl
      mov al, ch              ;update red
      out dx, al
      mov al, bl              ;update green
      out dx, al
      mov al, bh              ;update blue
      out dx, al

      mov ax, si              ;restore ax
      inc al                  ;al = al + 1, finished with color 255?
      jnz NextColorW          ;  if no, fade next color
      cmp byte ptr [bp+4], 2
      jng SkipDelayW          ;If value <3 then skip delay
      call DelaySub           ;Waits for verticle retrace (1/60s)
   SkipDelayW:
      dec cl                  ;cl = cl - 1, finished with fade?
      jge FadeWSub2           ;  if no, continue fade

      mov bp, di
      ret 2
VsFadeWhite endp

;=======This negates the palette=============================================
VsNegative proc
      xor ah, ah
   nextnegcolor:
      mov dx, 3c7h
      mov al, ah
      out dx, al

      add dl, 2
      in al, dx
      mov bl, al              ;store red
      in al, dx
      mov bh, al              ;store green
      in al, dx
      mov cl, al              ;store blue

      not bx                  ;negate colors
      not cl

      dec dl
      mov al, ah
      out dx, al

      inc dl
      mov al, bl              ;write red
      out dx, al
      mov al, bh              ;write green
      out dx, al
      mov al, cl              ;write blue
      out dx, al

      inc ah
      jnz nextnegcolor

      ret
VsNegative endp

;=======This rotates the palette forward=====================================
VsRotatePalF proc
      mov di, bp
      mov bp, sp

      mov al, [bp+4]          ;store colors
      mov dx, 3c7h
      out dx, al

      add dl, 2
      in al, dx
      mov bl, al              ;store red (si)
      in al, dx
      mov bh, al              ;store green (si)
      in al, dx
      mov si, bx
      mov ch, al              ;store blue (ch)

      mov ah, [bp+4]
   nextrotcolorf:
      dec ah

      sub dl, 2
      mov al, ah
      out dx, al

      add dl, 2
      in al, dx
      mov bl, al              ;store red
      in al, dx
      mov bh, al              ;store green
      in al, dx
      mov cl, al              ;store blue

      inc ah
      dec dl
      mov al, ah
      out dx, al
      dec ah

      inc dl
      mov al, bl              ;write red
      out dx, al
      mov al, bh              ;write green
      out dx, al
      mov al, cl              ;write blue
      out dx, al

      xor al, al
      xchg al, ah
      cmp ax, [bp+6]
      xchg al, ah
      jg nextrotcolorf

      mov al, [bp+6]          ;store colors
      dec dl
      out dx, al

      mov bx, si
      inc dl
      mov al, bl              ;write red (si)
      out dx, al
      mov al, bh              ;write green (si)
      out dx, al
      mov al, ch              ;write blue (ch)
      out dx, al

      mov bp, di
      ret 4
VsRotatePalF endp

;=======This rotates the palette backward====================================
VsRotatePalB proc
      mov di, bp
      mov bp, sp

      mov al, [bp+6]          ;store colors
      mov dx, 3c7h
      out dx, al

      add dl, 2
      in al, dx
      mov bl, al              ;store red (si)
      in al, dx
      mov bh, al              ;store green (si)
      in al, dx
      mov ch, al              ;store blue (ch)
      mov si, bx

      mov ah, [bp+6]
   nextrotcolorb:
      inc ah

      sub dl, 2
      mov al, ah
      out dx, al

      add dl, 2
      in al, dx
      mov bl, al              ;store red
      in al, dx
      mov bh, al              ;store green
      in al, dx
      mov cl, al              ;store blue

      dec ah
      dec dl
      mov al, ah
      out dx, al
      inc ah

      inc dl
      mov al, bl              ;write red
      out dx, al
      mov al, bh              ;write green
      out dx, al
      mov al, cl              ;write blue
      out dx, al

      xor al, al
      xchg al, ah
      cmp ax, [bp+4]
      xchg al, ah
      js nextrotcolorb

      mov al, [bp+4]          ;retrieve colors
      dec dl
      out dx, al

      mov bx, si
      inc dl
      mov al, bl              ;write red (si)
      out dx, al
      mov al, bh              ;write green (si)
      out dx, al
      mov al, ch              ;write blue (ch)
      out dx, al

      mov bp, di
      ret 4
VsRotatePalB endp

;=======This clears the KB buffer============================================
VSClearKB proc
      xor ax, ax
      mov es, ax              ;graphics segment
      mov dl, es:[41ch]
      mov es:[41ah], dl
      ret
VSClearKB endp

;=======This delays the program for 1/60s====================================
VSDelay proc
      mov di, bp
      mov bp, sp
      mov cl, [bp+4]          ;retrieve time
   delaytimes:
      call DelaySub
      dec cl
      jnz delaytimes
      mov bp, di
      ret 2
VSDelay endp

;=======This waits for the vertical retrace==================================
DelaySub:
      mov dx, 3dah            ;port for checking v. retrace
      in al, dx               ;read port
      and al, 8               ;al and 8...
      jnz DelaySub            ;if not zero, loop
   DelaySub2:
      in al, dx               ;read port
      and al, 8               ;al and 8...
      jz DelaySub2            ;if zero, loop
      ret

end
