.model medium, basic
.stack 10h
.386
.code

public VSFill
public VSPCopy
public VSScrollD
public VSScrollL
public VSScrollR
public VSScrollU
align 2

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

;=======This copies the screen to a buffer===================================
VSPCopy proc
      mov dx, ds
      mov bx, bp
      mov bp, sp
      mov es, [bp+8]          ;set segment2
      mov ds, [bp+12]         ;set segment1
      mov di, [bp+6]          ;set offset2
      mov si, [bp+10]         ;set offset1
      mov cx, 64000           ;64k to move

      cmp word ptr [bp+4], 1  ;transparent?
      jz transcopy

   ;***Solid PCopy***
      shr cx, 2
      rep movsd               ;move it
      jmp endpcopy

   ;***Transparent PCopy***
   transcopy:
      mov al, [si]
      inc si
      cmp al, 0
      jz skipdraw             ;Don't draw color 0.
      mov es:[di], al
   skipdraw:
      inc di
      loop transcopy

   endpcopy:
      mov ds, dx
      mov bp, bx
      ret 10
VSPCopy endp

;=======This scrolls the screen down=========================================
VSScrollD proc
      push ds
      push bp
      mov bp, sp

      mov ds, [bp+12]         ;set segment 1
      mov es, [bp+12]         ;set segment 2

      mov ax, 320             ;AX = pixels / row
      mov cx, 63996           ;bottom-right dword
      mul word ptr [bp+8]     ;AX = pixels to scroll

      mov di, cx              ;bottom-right dword
      sub cx, ax              ;# bytes to move
      add di, [bp+10]         ;set offset
      shr cx, 2               ;# dwords to move
      mov si, di              ;set offsets =
      sub si, ax              ;set SI to offset 1

      std
      rep movsd               ;copy pixel to new location
      cld

      pop bp
      pop ds
      ret 6
VSScrollD endp

;=======This scrolls the screen up===========================================
VSScrollU proc
      mov dx, ds
      push bp
      mov bp, sp

      mov ds, [bp+10]         ;set segments
      mov es, [bp+10]
      mov di, [bp+8]          ;set offsets
      mov si, [bp+8]

      xor bl, bl
      mov ax, [bp+6]          ;ax = y
      mov bh, al              ;bx = y * 256
      shl ax, 6               ;ax = y * 64
      add bx, ax              ;bx = y * 320
      add si, bx

      mov cx, 64000           ;dwords to move
      sub cx, bx
      shr cx, 2
      rep movsd               ;move them

      pop bp
      mov ds, dx
      ret 6
VSScrollU endp

;=======This scrolls the screen left=========================================
VSScrollL proc
      mov dx, ds
      push bp
      mov bp, sp
      mov ds, [bp+10]         ;set segments
      mov si, [bp+8]
      mov es, [bp+10]
      mov di, [bp+8]
      add si, [bp+6]
        
      mov cx, 64000-[bp+6]
      shr cx, 2
      rep movsd

      pop bp
      mov ds, dx
      ret 6
VSScrollL endp

;=======This scrolls the screen right========================================
VSScrollR proc
      mov bx, ds
      mov ax, bp           ;store BP
      mov bp, sp

      mov cx, 63996        ;last dword of screen
      mov ds, [bp+8]       ;DS=segment
      sub cx, [bp+4]       ;set CX to [bp+4] pixels to the left
      mov si, [bp+6]       ;SI=offset
      mov es, [bp+8]       ;ES=segment
      add si, cx           ;set offset to original + new CX

      mov di, si           ;offsets =
      shr cx, 2            ;set CX to dwords instead of bytes
      add di, [bp+4]       ;set DI to offset + shift value

      std
      rep movsd            ;move pixels
      cld

      mov bp, ax           ;restore BP
      mov ds, bx
      ret 6
VSScrollR endp

;=======This fills a buffer with a color=====================================
VSFill proc
      mov bx, bp
      mov bp, sp

      mov al, [bp+4]          ;get color
      mov es, [bp+8]          ;set segment
      mov ah, al              ;duplicate color
      mov di, [bp+6]          ;set offset
      mov cx, ax
      shl eax, 16
      mov ax, cx              ;make 4 copies of the color

      mov cx, 16000           ;mov 64000 bytes
      rep stosd

      mov bp, bx
      ret 6
VSFill endp

end
