.model medium, basic
.stack 40h
.386
.code

public vscollide
public vscollide2
public vsget
public vsput
public vsputt
public vssprite
public vsspritec
public vsspriter
public vssprites
align 2

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

;=======This draws a transparent sprite======================================
vssprite proc
        push ds
        push bp
        push eax                ;height, width
        push ax                 ;widthinscrn

        mov bp, sp
        mov si, [bp+24]         ;sprite off
        mov ds, [bp+26]         ;sprite seg

        mov ecx, [si]           ;get sprite's width in bits
        mov es, [bp+18]         ;scrn seg
        shr cx, 3               ;divide CX by 8 to get bytes, CX=width
        mov ax, [bp+22]         ;AX=x                   \
        mov [bp+2], ecx
        mov [bp], cx

        add si, 4               ;address of pixels
        cmp ax, 319             ;is it >319?            |
        jg endspr               ;yes, end sub           |
        neg ax
        cmp ax, cx              ;is AX=x+width <0?      |
        jns endspr              ;yes, end sub           |
                                ;                        >-Out of scrn test
        mov ax, [bp+20]         ;AX=y                   |
        cmp ax, 199             ;is it >199?            |
        jg endspr               ;yes, end sub           |
        neg ax
        cmp ax, [bp+4]          ;is AX=y+height <0?     |
        jns endspr              ;yes, end sub           /


        mov ax, [bp+22]         ;ax=x
        cmp ax, 0
        jns skipaddx1           ;is it<0? no, skip this
        mov bx, ax              ;bx=x
        neg ax
        add bx, [bp+2]          ;bx=width+x
        add si, ax              ;move forward in spr
        mov [bp], bx            ;widthinscrn=width+x
        add [bp+22], ax         ;move forward in scrn
        jmp donex

   skipaddx1:
        add ax, [bp+2]          ;ax=x+width
        cmp ax, 320
        js donex                ;is it>319? no, skip this
        mov ax, 320
        sub ax, [bp+22]
        mov [bp], ax

   donex:
        mov bx, [bp+20]         ;BX=y
        cmp bx, 0
        jns skipaddy1           ;no, skip this

        neg bx                  ;bx=-y
        mov ax, cx              ;AX=width
        mul bx                  ;AX=width*-y
        sub [bp+4], bx          ;height=height+y
        add si, ax              ;move down in spr
        mov word ptr [bp+20], 0 ;move down in scrn
        jmp doney

   skipaddy1:
        add bx, [bp+4]
        cmp bx, 200
        jng doney
        mov ax, 200
        sub ax, [bp+20]
        mov [bp+4], ax

   doney:
        mov bx, [bp+20]         ;BL=y
        shl bx, 6               ;BX=y*64
        add bh, [bp+20]         ;BX=y*256+y*64
        add bx, [bp+22]         ;BX=x+y*320
        add bx, [bp+16]         ;BX=offset+x+y*320

;===MAIN LOOP===
        mov di, [bp+4]
   sprloop:
        mov cx, [bp]

   sprpixelloop:
        mov dh, [si]            ;location of pixel data
        inc si
        cmp dh, 0               ;is it black?
        jz skippixelspr         ;skip if it's black

        cmp word ptr [bp+14], 0
        jz skipsprtrans

        mov dl, es:[bx]
        mov ah, dh

        and dl, 1fh             ;get shade of color1
        and ah, 1fh             ;get shade of color2

        add dl, ah              ;add shades
        sub dh, ah
        shr dl, 1               ;average shades
        add dh, dl              ;new pixel = averaged shades

   skipsprtrans:
        mov es:[bx], dh         ;draw pixel
   skippixelspr:
        inc bx
        dec cx
        ja sprpixelloop

        add si, [bp+2]          ;next spr row
        add bx, 320             ;next scrn row
        sub si, [bp]
        sub bx, [bp]

        dec di                  ;is it done?
        ja sprloop

;===END OF SUB===
endspr:
        pop ax
        pop eax
        pop bp
        pop ds
        ret 14
vssprite endp

;=======This draws a solid sprite============================================
vsput proc
      push ds
      push bp
      push eax                ;height, width

      mov bp, sp
      mov si, [bp+20]         ;sprite off
      mov ds, [bp+22]         ;sprite seg

      mov ecx, [si]           ;get sprite's width in bits
      mov es, [bp+14]         ;scrn seg
      shr cx, 3               ;divide CX by 8 to get bytes, CX=width
      mov [bp], ecx
      mov di, cx

      mov ax, [bp+18]         ;AX=x                   \
      add si, 4               ;address of pixels
      cmp ax, 319             ;is it >319?            |
      jg endput               ;yes, end sub           |
      neg ax
      cmp ax, cx              ;is AX=x+width <1?      |
      jns endput              ;yes, end sub           |
                              ;                        >-Out of scrn test
      mov ax, [bp+16]         ;AX=y                   |
      cmp ax, 199             ;is it >199?            |
      jg endput               ;yes, end sub           |
      neg ax
      cmp ax, [bp+2]          ;is AX=y+height <0?     |
      jns endput              ;yes, end sub           /


      mov ax, [bp+18]         ;ax=x
      cmp ax, 0
      jge skipaddxp1          ;is it<0? no, skip this
      mov di, ax              ;bx=y
      neg ax
      add di, [bp]            ;bx=width+y
      add si, ax              ;move forward in spr
      add [bp+18], ax         ;move forward in scrn
      jmp donexp

   skipaddxp1:
      add ax, [bp]            ;ax=x+width
      cmp ax, 320
      js donexp               ;is it>319? no, skip this
      mov di, 320
      sub di, [bp+18]

   donexp:
      mov bx, [bp+16]         ;BX=y
      cmp bx, 0
      jge skipaddyp1          ;no, skip this

      neg bx                  ;bx=-y
      mov ax, cx              ;AX=width
      mul bx                  ;AX=width*-y
      sub [bp+2], bx          ;height=height+y
      add si, ax              ;move down in spr
      mov word ptr [bp+16], 0 ;move down in scrn
      jmp doneyp

   skipaddyp1:
      add bx, [bp+2]
      cmp bx, 200
      jng doneyp
      mov ax, 200
      sub ax, [bp+16]
      mov [bp+2], ax

   doneyp:
      mov bx, [bp+16]         ;BL=y
      shl bx, 6               ;BX=y*64
      add bh, [bp+16]         ;BX=y*256+y*64
      add bx, [bp+18]         ;BX=x+y*320
      add bx, [bp+12]         ;BX=offset+x+y*320

   ;===MAIN LOOP===
      mov dx, [bp+2]
      xchg di, bx

      mov ax, [bp]
      sub ax, bx
   putloop:
      mov cx, bx
      cmp bx, 4
      jb endfill

   putpixelloop:
      sub cx, 4
      movsd                   ;draw pixel
      cmp cx, 4
      jae putpixelloop
      cmp cx, 0
      jz skipendfill

   endfill:
      rep movsb               ;draw pixel

   skipendfill:
      add di, 320             ;next scrn row
      add si, ax              ;next spr row
      sub di, bx

      dec dx                  ;is it done?
      ja putloop

   ;===END OF SUB===
   endput:
      pop eax
      pop bp
      pop ds
      ret 12
vsput endp

;=======This draws a solid translucent sprite================================
vsputt proc
        push ds
        push bp
        push eax                ;height, width
        push ax                 ;widthinscrn

        mov bp, sp
        mov si, [bp+22]         ;sprite off
        mov ds, [bp+24]         ;sprite seg

        mov ecx, [si]           ;get sprite's width in bits
        mov es, [bp+16]         ;scrn seg
        shr cx, 3               ;divide CX by 8 to get bytes, CX=width
        mov [bp+2], ecx
        mov [bp], cx


        mov ax, [bp+20]         ;AX=x                   \
        add si, 4               ;address of pixels
        cmp ax, 319             ;is it >319?            |
        jg endputt              ;yes, end sub           |
        neg ax
        cmp ax, cx              ;is AX=x+width <0?      |
        jns endputt             ;yes, end sub           |
                                ;                        >-Out of scrn test
        mov ax, [bp+18]         ;AX=y                   |
        cmp ax, 199             ;is it >199?            |
        jg endputt              ;yes, end sub           |
        neg ax
        cmp ax, [bp+4]          ;is AX=y+height <0?     |
        jns endputt             ;yes, end sub           /


        mov ax, [bp+20]         ;ax=x
        cmp ax, 0
        jge skipaddxpt1         ;is it<0? no, skip this
        mov bx, ax              ;bx=y
        neg ax
        add bx, [bp+2]          ;bx=width+y
        add si, ax              ;move forward in spr
        mov [bp], bx            ;widthinscrn=width+y
        add [bp+20], ax         ;move forward in scrn
        jmp donexpt

skipaddxpt1:
        add ax, [bp+2]          ;ax=x+width
        cmp ax, 319
        js donexpt              ;is it>319? no, skip this
        mov ax, 320
        sub ax, [bp+20]
        mov [bp], ax

donexpt:
        mov bx, [bp+18]         ;BX=y
        cmp bx, 0
        jge skipaddypt1         ;no, skip this

        neg bx                  ;bx=-y
        mov ax, cx              ;AX=width
        mul bx                  ;AX=width*-y
        sub [bp+4], bx          ;height=height+y
        add si, ax              ;move down in spr
        mov word ptr [bp+18], 0 ;move down in scrn
        jmp doneypt

skipaddypt1:
        add bx, [bp+4]
        cmp bx, 199
        jng doneypt
        mov ax, 200
        sub ax, [bp+18]
        mov [bp+4], ax

doneypt:
        mov bx, [bp+18]         ;BL=y
        shl bx, 6               ;BX=y*64
        add bh, [bp+18]         ;BX=y*256+y*64
        add bx, [bp+20]         ;BX=x+y*320
        add bx, [bp+14]         ;BX=offset+x+y*320

;===MAIN LOOP===
        mov di, [bp+4]
puttloop:
        mov cx, [bp]

puttpixelloop:
        mov dh, [si]            ;location of pixel data
        inc si
        mov dl, es:[bx]
        mov ah, dh

        and dl, 1fh             ;get shade of color1
        and ah, 1fh             ;get shade of color2

        add dl, ah              ;add shades
        sub dh, ah
        shr dl, 1               ;average shades
        add dh, dl              ;new pixel = averaged shades

        mov es:[bx], dh         ;place pixel on screen
        inc bx
        dec cx
        ja puttpixelloop

        add bx, 320             ;next scrn row
        add si, [bp+2]          ;next spr row
        sub bx, [bp]
        sub si, [bp]

        dec di                  ;is it done?
        ja puttloop

;===END OF SUB===
endputt:
        pop ax
        pop eax
        pop bp
        pop ds
        ret 12
vsputt endp

;=======This gets a sprite===================================================
vsget proc
        push ds
        mov di, bp
        push eax                 ;temparray, tempcorx
        push eax                 ;tempcory, width
        push ax                  ;height

        mov bp, sp
        mov ds, [bp+18]         ;set array segment
        mov es, [bp+30]         ;set screen segment

        mov eax, [bp+20]        ;x2, y2
        sub eax, [bp+24]        ;x2-x1, y2-y1
        add eax, 10001h         ;x2-x1+1, y2-y1+1
        mov [bp], eax           ;set width
        
        mov si, [bp+16]         ;array offset
        mov ax, [bp+2]
        shl ax, 3
        mov [si], ax
        mov ax, [bp]
        add si, 2
        mov [si], ax

        xor eax, eax
        mov [bp+4], eax
        mov [bp+8], ax
   nextgetpixel:

        mov ax, [bp+24]         ;mov y1 into ax
        mov dh, 0
        add ax, [bp+4]          ;add tempcory to ax
        cmp ax, 199             ;is the y >199, <0 ?
        jg savepixel            ;  if yes, jump here

        mov cx, [bp+26]         ;move x1 into ax
        add cx, [bp+6]          ;add tempcorx to ax
        cmp cx, 319             ;is the x >319, <0 ?
        jg savepixel            ;  if yes, skip this

        xor bl, bl              ;bl = 0
        mov bh, al              ;mov al*256 into bh
        shl ax, 6               ;ax = ax * 64
        add bx, ax              ;add ax to bx
        add bx, cx
        add bx, [bp+28]         ;add offset
        mov dh, es:[bx]         ;save pixel

   savepixel:
        mov si, [bp+16]         ;si =array offset
        add si, [bp+8]          ;add temparray to ax
        add si, 4               ;add 4
        mov [si], dh            ;copy pixel into si

   finishgpixel:
        inc word ptr [bp+6]     ;increment tempcorx
        inc word ptr [bp+8]     ;increment temparray
        mov cx, [bp+6]
        cmp cx, [bp+2]          ;is tempcorx >=width ?
        js nextgetx             ;  if no, skip this

        inc word ptr [bp+4]     ;increment tempcory
        mov word ptr [bp+6], 0  ;tempcorx = 0
        mov cx, [bp+4]
        cmp cx, [bp]            ;is tempcory >=height ?
        jge finishget           ;  if yes, end sub

   nextgetx:
      jmp nextgetpixel        ;continue with next pixel

   finishget:
        pop eax
        pop eax
        pop ax
        mov bp, di
        pop ds
        ret 16
vsget endp

;=======This draws a scaled transparent sprite===============================
;bp=height, bp+2=yscale, bp+4=xscale, bp+6=tempy
;bp+8=tempx, bp+10=tempcory, bp+12=tempcorx, bp+14=width
;bp+16=ds, bp+18=QBOffset, bp+20=QBSegment
;bp+22=bufferOffset, bp+24=bufferSegment, bp+26=scaleY
;bp+28=scaleX, bp+30=y, bp+32=x, bp+34=imageOffset
;bp+36=imageSegment
vssprites proc
      xor eax, eax
      push ds
      mov di, bp
      push eax                ;width, tempcorx
      push eax                ;tempcory, tempx
      push eax                ;tempy, xscale
      push eax                ;yscale, height

      mov bp, sp
      mov es, [bp+24]         ;screen segment
      mov ds, [bp+36]         ;image segment
      mov si, [bp+22]         ;screen offset

      mov cx, [si]            ;get sprite's width in bits
      shr cx, 3               ;divide width by 8 to get bytes
      mov [bp+14], cx

      mov cx, [si+2]
      mov [bp], cx            ;height

      mov cx, [bp+28]         ;scale factor
      shr cx, 6
      mov [bp+8], cx          ;times to loop x
      mov cx, [bp+26]         ;scale factor
      shr cx, 6
      mov [bp+6], cx          ;times to loop y

      mov cx, 4
      mov fs, cx            ;temparray = 4

   ;---Outer loop---
   nextsprpixels:
      ;Center the X on the sprite
      mov ax, [bp+14]         ;AX=width
      mov bx, [bp+28]         ;BX=scaleX
      shr ax, 1               ;AX=width/2
      mul bx                  ;AX=(width/2)*scaleX
      shr ax, 6               ;AX=(width/2)*scaleX/64
      mov cx, ax              ;store AX in CX

      mov ax, [bp+12]         ;AX=tempcorX
      mul bx                  ;AX=tempcorX*scaleX
      shr ax, 6               ;AX=tempcorX*scaleX/64
      sub ax, cx              ;AX=(tempcorX*scaleX/64)-((width/2)*scaleX/64)
      mov [bp+4], ax          ;store AX in xscale

      add ax, [bp+32]         ;add x to AX
      mov bx, 319
      sub bx, [bp+8]          ;BX=319-tempx
      cmp ax, bx
      ja finishpixels;
      mov cx, ax              ;store final x

      mov ax, [bp]            ;shift the y to center
      mov bx, [bp+26]         ;y scale factor
      shr ax, 1
      mul bx
      shr ax, 6
      mov gs, ax

      mov ax, [bp+10]         ;scale the y
      mul bx
      mov bx, gs
      shr ax, 6
      sub ax, bx
      mov [bp+2], ax          ;move ax into scaled y

      add ax, [bp+30]         ;add y to ax
      js finishpixels         ;  if yes, skip this
      mov bx, 199
      cmp ax, bx
      jg finishsprs           ;  if yes, skip this

      mov si, fs              ;copy temparray into ax
      add si, [bp+34]         ;add offset
      mov dl, [si]            ;copy pixel into dl
      cmp dl, 0
      jz finishpixels         ;black?  if yes, skip this

      mov bx, [bp+22]         ;add offset
      add bh, al              ;move al*256 into bh
      shl ax, 6               ;ax = ax * 64
      add bx, ax              ;add ax to bx
      add bx, cx              ;add x to bx

      mov cx, [bp+8]          ;x
      mov al, [bp+6]          ;y

   nextspixel:
      mov es:[bx], dl         ;place pixel on screen

      inc bx
      dec cx
      jns nextspixel

      mov cx, [bp+8]          ;cx=tempx
      sub bx, cx
      add bx, 319
      cmp bx, 63999
      ja finishpixels
      dec al
      jns nextspixel

   finishpixels:
      mov cx, fs              ;increment temparray
      inc cx
      inc word ptr [bp+12]    ;increment tempcorx
      mov fs, cx
      mov cx, [bp+12]
      cmp cx, [bp+14]         ;is tempcorx >width ?
      js nextsprxs            ;  if no, skip this

      inc word ptr [bp+10]    ;increment tempcory
      mov word ptr [bp+12], 0
      mov cx, [bp+10]
      cmp cx, [bp]            ;is tempcory >height ?
      jns finishsprs          ;  if yes, end sub

   nextsprxs:
      jmp nextsprpixels       ;continue with next pixel

   finishsprs:
      pop eax
      pop eax
      pop eax
      pop eax
      mov bp, di
      pop ds
      ret 16
vssprites endp

;=======This draws a rotated sprite==========================================
vsspriter proc
      push ds
      push eax                ;width, height
      mov di, bp
      push eax                ;tempcorx, tempcory
      push eax                ;rotx, roty

      mov bp, sp
      mov ds, [bp+32]         ;varseg
      mov es, [bp+20]         ;set segment
      mov si, [bp+30]         ;varptr

      mov ax, [si]            ;get sprite's width in bits
      shr ax, 3               ;divide width by 8 to get bytes
      mov [bp+10], ax
      add si, 2
      mov cx, [si]
      mul cx
      mov [bp+8], cx          ;save height
      dec cx
      dec ax
      mov [bp+4], cx          ;tempcory
      mov fs, ax              ;tempcor
      mov ax, [bp+10]         ;width
      dec ax
      mov [bp+6], ax          ;tempcorx

   nextsprpixelr:
      mov si, fs              ;copy tempcor into si
      add si, 4               ;add 4 to ax
      add si, [bp+30]         ;add offsetval to ax
      mov ch, [si]            ;copy pixel into cx
      cmp ch, 0               ;is the pixel black?
      jz finishpixelr

      ;dx = tempcory - height \ 2
      mov ax, [bp+8]          ;height/2
      mov dx, [bp+4]          ;dx=tempcory
      shr ax, 1
      sub dx, ax              ;dx=dx-ax

      ;ax = (tempcory - height \ 2) * 256SIN(angle%) \ 256
      mov ax, [bp+22]         ;ax=256*SIN(angle%)
      imul dx                 ;ax=ax*dx
      sar ax, 8               ;ax=ax\256

      ;rotx = x% - (tempcory - height \ 2) * 256SIN(angle%) \ 256
      mov dx, [bp+28]         ;dx=x%
      sub dx, ax              ;dx=dx-ax
      mov [bp+2], dx          ;rotx=dx

      ;dx = tempcorx - width \ 2
      mov ax, [bp+10]         ;width
      mov dx, [bp+6]          ;dx=tempcorx
      shr ax, 1
      sub dx, ax              ;dx=dx-width\2

      ;ax = (tempcorx - width \ 2) * 256COS(angle%) \ 256
      mov ax, [bp+24]         ;ax=256*COS(angle%)
      imul dx                 ;ax=ax*dx
      sar ax, 8               ;ax=ax\256

      ;rotx = rotx + (tempcorx - width \ 2) * 256COS(angle%) \ 256
      mov dx, [bp+2]          ;dx=rotx
      add dx, ax              ;dx=dx+ax
      mov [bp+2], dx          ;rotx=dx+rotx


      cmp dx, 319             ;is this pixel >319 ?
      jb dontfpr
      jmp finishpixelr

   dontfpr:
      ;dx = tempcory - height \ 2
      mov ax, [bp+8]          ;ax=height
      mov dx, [bp+4]          ;dx=tempcory
      shr ax, 1               ;ax=ax\2
      sub dx, ax              ;dx=dx-ax

      ;ax = (tempcory - height \ 2) * 256COS(angle%) \ 256
      mov ax, [bp+24]         ;ax=256COS(angle%)
      imul dx                 ;ax=ax*dx
      sar ax, 8               ;ax=ax\256

      ;roty = y% + (tempcory - height \ 2) * 256COS(angle%) \ 256
      mov dx, [bp+26]         ;dx=y%
      add dx, ax              ;dx=dx+ax
      mov [bp], dx            ;roty=cx

      ;dx = tempcorx - width \ 2
      mov ax, [bp+10]         ;ax=width
      mov dx, [bp+6]          ;dx=tempcorx
      shr ax, 1               ;ax=ax\2
      sub dx, ax              ;dx=dx-ax

      ;ax = (tempcorx - width \ 2) * 256SIN(angle%) \ 256
      mov ax, [bp+22]         ;ax=256SIN(angle%)
      imul dx                 ;ax=ax*dx
      sar ax, 8               ;ax=ax\256

      ;roty = roty + (tempcorx - width \ 2) * 256SIN(angle%) \ 256
      mov dx, [bp]            ;rotx=(rotx+cx)
      add ax, dx              ;ax=ax+dx
      mov [bp], ax            ;roty=roty+ax

      cmp ax, 200             ;is this pixel >199 ?
      ja finishpixelr        ;  if yes, skip this

      xor bl, bl              ;bl = 0
      mov bh, al              ;mov al*256 into bh
      shl ax, 6               ;ax = ax * 64
      add bx, ax              ;add ax to bx
      mov dh, ch             ;pixel 1
      add bx, [bp+2]          ;add rotx to bx
      mov dl, ch             ;pixel 2
      add bx, [bp+18]         ;add offset

      mov es:[bx], dx         ;place pixel on screen

   finishpixelr:
      mov cx, fs
      dec cx
      mov fs, cx
      js finishsprr

      dec word ptr [bp+6]
      jge nextsprxr

      mov cx, [bp+10]
      dec cx
      mov [bp+6], cx
      dec word ptr [bp+4]     ;decrement tempcorx
   nextsprxr:
      jmp nextsprpixelr       ;continue with next pixel

   finishsprr:
      pop eax
      pop eax
      mov bp, di
      pop eax
      pop ds
      ret 16
vsspriter endp

;=======This draws a transparent sprite as a single color====================
vsspritec proc
        push ds
        push bp
        push eax                ;height, width
        push ax                 ;widthinscrn

        mov bp, sp
        mov si, [bp+24]         ;sprite off
        mov ds, [bp+26]         ;sprite seg

        mov ecx, [si]           ;get sprite's width in bits
        mov es, [bp+16]         ;scrn seg
        shr cx, 3               ;divide CX by 8 to get bytes, CX=width
        mov [bp+2], ecx
        mov [bp], cx


        mov ax, [bp+22]         ;AX=x                   \
        add si, 4               ;address of pixels
        cmp ax, 319             ;is it >319?            |
        jg endsprc              ;yes, end sub           |
        neg ax
        cmp ax, cx              ;is AX=x+width <0?      |
        jns endsprc             ;yes, end sub           |
                                ;                        >-Out of scrn test
        mov ax, [bp+20]         ;AX=y                   |
        cmp ax, 199             ;is it >199?            |
        jg endsprc              ;yes, end sub           |
        neg ax
        cmp ax, [bp+4]          ;is AX=y+height <0?     |
        jns endsprc             ;yes, end sub           /


        mov ax, [bp+22]         ;ax=x
        cmp ax, 0
        jge skipaddxc1          ;is it<0? no, skip this
        mov bx, ax              ;bx=x
        neg ax
        add bx, [bp+2]          ;bx=width+x
        add si, ax              ;move forward in spr
        mov [bp], bx            ;widthinscrn=width+x
        add [bp+22], ax         ;move forward in scrn
        jmp donexc

skipaddxc1:
        add ax, [bp+2]          ;ax=x+width
        cmp ax, 319
        js donexc               ;is it>319? no, skip this
        mov ax, 320
        sub ax, [bp+22]
        mov [bp], ax

donexc:
        mov bx, [bp+20]         ;BX=y
        cmp bx, 0
        jge skipaddyc1          ;no, skip this

        neg bx                  ;bx=-y
        mov ax, cx              ;AX=width
        mul bx                  ;AX=width*-y
        sub [bp+4], bx          ;height=height+y
        add si, ax              ;move down in spr
        mov word ptr [bp+20], 0 ;move down in scrn
        jmp doneyc

skipaddyc1:
        add bx, [bp+4]
        cmp bx, 199
        jng doneyc
        mov ax, 200
        sub ax, [bp+20]
        mov [bp+4], ax

doneyc:
        mov bx, [bp+20]         ;BL=y
        shl bx, 6               ;BX=y*64
        add bh, [bp+20]         ;BX=y*256+y*64
        add bx, [bp+22]         ;BX=x+y*320
        add bx, [bp+14]         ;BX=offset+x+y*320

;===MAIN LOOP===
sprcloop:
        mov cx, [bp]
        mov dh, [bp+18]         ;color of sprite

sprcpixelloop:
        mov dl, [si]            ;location of pixel data
        inc si
        cmp dl, 0               ;is it black?
        jz skippixelsprc        ;skip if it's black
        mov es:[bx], dh         ;draw pixel
skippixelsprc:
        inc bx
        dec cx
        ja sprcpixelloop

        add bx, 320             ;next scrn row
        add si, [bp+2]          ;next spr row
        sub bx, [bp]
        sub si, [bp]

        dec word ptr [bp+4]     ;is it done?
        ja sprcloop

;===END OF SUB===
endsprc:
        pop ax
        pop eax
        pop bp
        pop ds
        ret 14
vsspritec endp

;=======Checks for a non-0 collision=========================================
vscollide proc
        push ds
        mov di, bp
        push ax                 ;width
        push eax                ;tempcory, tempcor

        mov bp, sp
        mov ds, [bp+22]         ;read stack value into ds
        mov es, [bp+14]         ;set segment
        mov si, [bp+20]         ;sprite offset

        xor eax, eax
        xor ecx, ecx
        mov ax, [si]            ;get sprite's width in bits
        shr ax, 3               ;divide width by 8 to get bytes
        mov [bp+4], ax
        add si, 2
        mov cx, [si]
        mul cx
        dec cl
        mov [bp+2], cx          ;move height into tempcory
        dec ax
        mov [bp], ax
        mov ax, [bp+4]
        dec ax
        mov fs, ax

nextcolpixel:
        mov si, [bp]            ;copy tempcor into si
        add si, 4               ;add 4 to ax
        add si, [bp+20]         ;add offsetval to ax
        mov dh, [si]            ;copy pixel into cx

        cmp dh, 0               ;is the pixel black?
        jz finishcolpixel       ;  if yes, skip this

        mov ax, fs              ;ax=tempcorx
        add ax, [bp+18]         ;ax=ax+x
        jg finishcolpixel       ;  if yes, skip this
        cmp ax, 320             ;is this pixel >319 ?
        jge finishcolpixel      ;  if yes, skip this
        mov cx, ax

        mov ax, [bp+16]         ;mov y into ax
        add ax, [bp+2]          ;add tempcory into ax
        jg finishcol            ;  if yes, skip this
        cmp ax, 200             ;is this pixel >199 ?
        jge finishcolpixel      ;  if yes, skip this

        xor bl, bl              ;bl = 0
        mov bh, al              ;mov al*256 into bh
        shl ax, 6               ;ax = ax * 64
        add bx, ax              ;add ax to bx
        add bx, [bp+12]         ;add offset
        add bx, cx              ;add x to bx
        mov dh, es:[bx]         ;gets pixel from screen
        cmp dh, 0
        jnz collide

finishcolpixel:
        dec word ptr [bp]
        jg finishcol

        mov cx, fs
        dec cx
        mov fs, cx
        jge nextcolx

        mov cx, [bp+4]
        dec cx
        mov fs, cx
        dec word ptr [bp+2]     ;decrement tempcorx
nextcolx:
        jmp nextcolpixel        ;continue with next pixel

finishcol:
        pop eax
        pop ax
        xor ax, ax
        jmp exitcol
collide:
        pop eax
        pop ax
        xor ah, ah
        mov al, dh
exitcol:
        mov bp, di
        pop ds
        ret 12
vscollide endp

;=======Checks for a collision with a color==================================
vscollide2 proc
        push ds
        mov di, bp
        push ax                 ;width
        push eax                ;tempcory, tempcor

        mov bp, sp
        mov ds, [bp+24]         ;read stack value into ds
        mov es, [bp+14]         ;set segment
        mov si, [bp+22]         ;sprite offset

        xor eax, eax
        xor ecx, ecx
        mov ax, [si]            ;get sprite's width in bits
        shr ax, 3               ;divide width by 8 to get bytes
        mov [bp+4], ax
        add si, 2
        mov cx, [si]
        mul cx
        dec cl
        mov [bp+2], cx          ;move height into tempcory
        dec ax
        mov [bp], ax
        mov ax, [bp+4]
        dec ax
        mov fs, ax

   nextcolpixel2:
        mov si, [bp]            ;copy tempcor into si
        add si, 4               ;add 4 to ax
        add si, [bp+22]         ;add offsetval to ax
        mov dh, [si]            ;copy pixel into cx

        cmp dh, 0               ;is the pixel black?
        jz finishcolpixel2      ;  if yes, skip this

        mov ax, fs              ;ax=tempcorx
        add ax, [bp+20]         ;ax=ax+x
        jg finishcolpixel2      ;  if yes, skip this
        cmp ax, 320             ;is this pixel >319 ?
        jge finishcolpixel2     ;  if yes, skip this
        mov cx, ax

        mov ax, [bp+18]         ;mov y into ax
        add ax, [bp+2]          ;add tempcory into ax
        jg finishcol2           ;  if yes, skip this
        cmp ax, 200             ;is this pixel >199 ?
        jge finishcolpixel2     ;  if yes, skip this

        xor bl, bl              ;bl = 0
        mov bh, al              ;mov al*256 into bh
        shl ax, 6               ;ax = ax * 64
        add bx, ax              ;add ax to bx
        add bx, [bp+12]         ;add offset
        add bx, cx              ;add x to bx
        mov dh, es:[bx]         ;gets pixel from screen
        cmp dh, [bp+16]
        jz collide2

   finishcolpixel2:
        dec word ptr [bp]
        jg finishcol2

        mov cx, fs
        dec cx
        mov fs, cx
        jge nextcolx2

        mov cx, [bp+4]
        dec cx
        mov fs, cx
        dec word ptr [bp+2]     ;decrement tempcorx
   nextcolx2:
        jmp nextcolpixel2       ;continue with next pixel

   finishcol2:
        pop eax
        pop ax
        xor ax, ax
        jmp exitcol2
   collide2:
        pop eax
        pop ax
        xor ah, ah
        mov al, 1
   exitcol2:
        mov bp, di
        pop ds
        ret 14
vscollide2 endp

end
