' M \ K BSP Demo v0.1
'
' This is a more advanced version of BSPREND.BAS.
' Special thanks to Greg McAusland and Christopher Neill of Exposed Dreams
' for their excellent keyboard handling code.
'
' For speed, use the EXE and disable the retrace.
'
' The draw distance can be altered by changing the BackClipPlane constant.


DECLARE SUB PlayerJump ()
DECLARE SUB OSBDrawWire (X%)
DECLARE SUB OSBDrawFlat (X%)
DECLARE SUB OSBDrawShaded (X%)
DECLARE FUNCTION PlayerUpdate% ()
DECLARE SUB PlayerMove (nx!, ny!)
DECLARE SUB MainInit (f$)
DECLARE FUNCTION BSPGetFile$ ()
DECLARE SUB WorldColDetect (mx!, my!)
DECLARE SUB ConsoleUpdate (a$)
DECLARE SUB ConsoleClear ()
DECLARE SUB BSPLoad (f$)
DECLARE FUNCTION BSPSize% (f$)
DECLARE SUB ZkbRelease (code%)
DECLARE SUB LoadAsm ()
DECLARE SUB Zkboff ()
DECLARE SUB ZKBOn ()
DECLARE SUB PalSet (at%, R%, g%, B%)
DECLARE SUB PalInit ()
DECLARE SUB OSBClear ()
DECLARE SUB OSBInit ()
DECLARE SUB DisplayFPS ()
DECLARE SUB WaitForDisplay ()
DECLARE SUB VerticeDraw (X%)
DECLARE SUB TreeWalk (CurRoot%)
DECLARE FUNCTION IsInFront% (X%)
DECLARE SUB BuildTables ()
DECLARE SUB PlayerInit ()
DECLARE SUB VSDrawAll (a() AS ANY, Col%)
DECLARE SUB VSClipWalls ()
DECLARE SUB VSCopy (a() AS ANY, B() AS ANY)
DECLARE SUB VSTranslate ()




' Program Constants
CONST pi = 3.141592
' Define data type constants
CONST NULL = 0
CONST True = "Y"
CONST False = "N"
CONST Zero = .0001
' Define Rendering constants
CONST Ceiling = 113
CONST Floor = 12
CONST WaitVR = True
CONST WallHeightFactor = 5
CONST WireFrame = 1       ' Level of detail constants
CONST FilledWalls = 2
CONST ShadedWalls = 3
CONST MsgTime = 2.5
' Define logical world constants
CONST WorldX = 320
CONST WorldY = 200
CONST HalfWX = WorldX / 2
CONST HalfWy = WorldY / 2
CONST ViewArc = 90
CONST HalfViewArc = ViewArc \ 2
CONST FrontClipPlane = 1
CONST BackClipPlane = 600
CONST VisibleDepth = 230'(BackClipPlane - FrontClipPlane) / 2
CONST MaxWallHeight = 100
CONST HalfMaxWallHeight = MaxWallHeight / 2
CONST PlayerHeight = 10
' Define Collision constants
CONST WallHitDistance = 4
CONST ZeroSlope = 0
CONST InfiniteSlope = 999999
' Define Keyboard keys (not used anymore)
CONST StrafeLeft = "A"
CONST StrafeRight = "D"
CONST SpeedUp = "+"
CONST SpeedDown = "-"
CONST AngleUp = "]"
CONST AngleDown = "["
CONST ToggleDispFps = "F"
CONST ToggleMap = "M"
CONST ToggleLOD = "L"
CONST SizeUp = "'"
CONST SizeDown = ";"
CONST ToggleVR = "W"
' The number of frames to count to give a FPS estimate
CONST MaxFrames = 60
' Movement status constants
CONST Idle = 0
CONST Moved = 1
CONST NeedRedraw = 2
CONST Coasting = 3

CONST CurBSPVersion! = .1

' ***** Data Type declarations *****

TYPE WorldType             ' Data type for the static World
        StartX AS SINGLE
        StartY AS SINGLE
        EndX AS SINGLE
        EndY AS SINGLE
        StartT AS SINGLE
        EndT AS SINGLE
        StartTop AS SINGLE
        StartBot AS SINGLE
        EndTop AS SINGLE
        EndBot AS SINGLE
        Col AS INTEGER
        ShadeCol AS INTEGER
END TYPE

TYPE ViewSpaceType        ' Data type for the View Space
        StartX AS SINGLE
        StartY AS SINGLE
        EndX AS SINGLE
        EndY AS SINGLE
        StartT AS SINGLE
        EndT AS SINGLE
        IsVisible AS STRING * 1
END TYPE

TYPE DrawListType       ' Data Type for on screen polygons
        xStart AS SINGLE
        xEnd AS SINGLE
        yTopStart AS SINGLE
        yBotStart AS SINGLE
        DepthStart AS SINGLE
        yTopSlope AS SINGLE
        yBotSlope AS SINGLE
        DepthSlope AS SINGLE
END TYPE

' Type for BSP tree node
TYPE NodeType
        VerticePtr AS INTEGER
        FrontTree AS INTEGER
        BackTree AS INTEGER
END TYPE
' Type for player/environment variables
TYPE PlayerType
        X AS SINGLE                     ' X position
        y AS SINGLE                     ' Y Position
        angle AS INTEGER                 ' Angle
        speed AS SINGLE                ' Speed
        rotinc AS INTEGER               ' How fast they are turning
        Footlevel AS INTEGER
        Eyelevel AS INTEGER             ' Eye level
        vx AS SINGLE                    ' Current Movement vector
        vy AS SINGLE                    ' "
        ax AS SINGLE
        ay AS SINGLE
        vertmov AS SINGLE               ' Vertical movement vector
        accel AS SINGLE                 ' Acceleration
        decel AS SINGLE                 ' Deceleration
        MaxSpeed AS SINGLE              ' MaxSpeed
        InitSpeed AS SINGLE
        Gravity AS SINGLE               ' Gravity
        JumpVect AS SINGLE              ' Jump vector
        JumpStatus AS STRING * 1        ' Jumping status
        JumpTime AS SINGLE              ' Jumping elapsed time
        FPSOn AS INTEGER                ' Is FPS display on?
        LOD AS INTEGER                  ' Level of detail
        ShowMap AS STRING * 1           ' Is Map display on?
        ScreenX AS LONG                 ' X Size of render window
        ScreenY AS LONG                 ' Y Size of render window
        HalfSx AS INTEGER               ' Half of X size
        HalfSY AS INTEGER               ' Half of Y Size
        xStart AS INTEGER               ' X start of window
        YStart AS INTEGER               ' Y start of window
        ConsoleActive AS STRING * 1     ' Is a console message active?
        ConsoleStartTime AS SINGLE      ' If so, what time did it start?
        WaitVR AS STRING * 1            ' Are we waiting for retrace?
        Collisions AS STRING * 1        ' Are we detecting collisions?
        FullScreen AS STRING * 1        ' Full screen display?
        BobAmp AS INTEGER               ' How hard head bobs
        BobCtr AS INTEGER               ' sin counter for head bob
END TYPE
TYPE TimesType
        Total AS SINGLE
        Translate AS SINGLE
        Clip AS SINGLE
        Map AS SINGLE
        Collide AS SINGLE
        Render AS SINGLE
        FPS AS SINGLE
END TYPE

CLEAR , , 25000
ON ERROR GOTO Handler
' ***** Data Initialization *****

' Get BSP file from user
f$ = BSPGetFile$

' Get BSP tree size from user
Size% = BSPSize%(f$)

DIM SHARED err$

DIM SHARED SinT(0 TO 360) AS SINGLE, cost(0 TO 360) AS SINGLE

' Player/Environment data set
DIM SHARED player AS PlayerType

' Array for FPS analysis
DIM SHARED Times(0 TO MaxFrames) AS SINGLE, CurTime AS INTEGER

' This is the set of vertices that contains the entire world
DIM SHARED World(0 TO Size% - 1) AS WorldType
DIM SHARED WorldSize AS INTEGER

' This is the set of vertices that contain the world as seen
' from the viewers persepctive (i.e. rotated/scaled)
DIM SHARED ViewSpace(0 TO Size% - 1) AS ViewSpaceType

DIM SHARED DrawList(0 TO Size% - 1) AS DrawListType

DIM SHARED SavedSpace(0 TO Size% - 1) AS ViewSpaceType

' This is the tree we will build from the initial set
DIM SHARED BSP(1 TO Size%) AS NodeType
DIM SHARED ZKey%(127), Zkbh$(2), kbonflag%, olkbseg%, olkboff%
DIM SHARED Analyze AS TimesType


' Initialize Misc Stuff
CALL MainInit(f$)

' Allocate and initialize an off screen buffer
'BufferSize% = player.ScreenX * (player.ScreenY / 2) + 1
BufferSize% = 320 * (200 / 2) + 1
DIM SHARED OsBuffer(BufferSize%) AS INTEGER
CALL OSBInit

' Two variables for FPS stuff
Frames! = 0: TotalTime! = 0

CALL ZKBOn

' Make program automatically draw first frame
Status% = NeedRedraw
CALL ConsoleUpdate(f$ + " loaded," + STR$(Size%) + " walls in level.")
' ********** END OF INITIALIZATION CRAP ************





' ******** Main Loop *********
DO
        ' Update the frame first
        
       
        ' Do headbob stuff
        IF Status% = Moved AND player.Footlevel = 0 THEN
                ' Do head bobbing stuff
                player.Eyelevel = 6 + ABS(SinT(player.BobCtr) * player.BobAmp)
                player.BobCtr = (player.BobCtr + 7) MOD 360
        END IF
        
        ' Do jumping
        IF player.JumpStatus = True THEN
                PlayerJump
                Status% = NeedRedraw
        END IF
      
        IF Status% <> Idle THEN
               
                t! = TIMER
              
                ' Remove map if needed
                IF player.ShowMap <> False AND player.FullScreen <> True THEN
                        CALL VSDrawAll(SavedSpace(), 0)
                END IF

                ' Translate and prepare world for drawing
                CALL VSTranslate
                CALL VSCopy(ViewSpace(), SavedSpace())
                CALL VSClipWalls
                
                ' Render world using BSP tree to sort walls (in "3d")
                CALL TreeWalk(1)
               
                ' Draw off-screen buffer
                PUT (player.xStart, player.YStart), OsBuffer, PSET
                CALL OSBClear
                
              
                ' Draw 2d Map
                IF player.ShowMap <> False THEN
                        PSET (160, 100), 31
                        CALL VSDrawAll(SavedSpace(), 31)
                END IF
              
                IF player.FullScreen <> True THEN
                        ' Draw borders
                        LINE (player.xStart - 1, player.YStart - 1)-(player.xStart + player.ScreenX, player.YStart + player.ScreenY), 23, B
                        LINE (0, 174)-(319, 184), 23, B
                END IF
               
                ' Wait for retrace if needed
                IF player.WaitVR = True THEN CALL WaitForDisplay
                              
                ' Accumulate some FPS information
                Frame! = TIMER - t!
                TotalTime! = TotalTime + Frame!
                Frames! = Frames! + 1
                IF player.FPSOn <> NULL THEN
                        Times(CurFrame%) = Frame!
                        CurFrame% = CurFrame% + 1
                        IF CurFrame% = MaxFrames AND player.FullScreen <> True THEN
                                CALL DisplayFPS
                                CurFrame% = 0
                        END IF
                END IF
               
                ' Update the console if needed
                IF player.ConsoleActive <> False THEN
                        IF TIMER - player.ConsoleStartTime >= MsgTime THEN
                                CALL ConsoleClear
                        END IF
                END IF
        END IF
       
        ' Here is where input is processed, player is moved, collisions, etc
        Status% = PlayerUpdate%
        IF Status% = Coasting THEN
                CALL PlayerMove(0, 0)
                Status% = NeedRedraw
        END IF

LOOP UNTIL ZKey%(1)
CALL Zkboff

SCREEN 0
WIDTH 80
PRINT "Drew "; LTRIM$(STR$(Frames!)); " frames in "; TotalTime!; " seconds."
IF TotalTime! <> 0 THEN PRINT Frames! / TotalTime!; " frames per second."
PRINT
PRINT "Thanks to Greg McAusland and Christopher Neill of Exposed Dreams"
PRINT "for the keyboard routines."
PRINT
PRINT "(c) 2001 Molnar \ Kucalaba Productions"
PRINT "http://members.aol.com/mkwebsite/"
SYSTEM



Handler:
CLS
SCREEN 0
WIDTH 80
PRINT "An error has occurred."
PRINT "error code:"; ERR
IF err$ = "" THEN err$ = "Null"
PRINT "Custom error string/faulty program procedure: "; err$
PRINT "Please report any bugs to us."
PRINT "http://members.aol.com/mkwebsite"
SYSTEM

FUNCTION BSPGetFile$
        CLS
        PRINT "Molnar \ Kucalaba Productions' BSP demo v0.1"
        PRINT "----------"
        PRINT "Arrow keys    :  Move, rotate player"
        PRINT "A, D          :  Strafe right, left"
        PRINT "S, Z          :  Jump, Moon Jump"
        PRINT "+ and -       :  Increase/Decrease view window size"
        PRINT "L             :  Toggle level of detail"
        PRINT "M             :  Toggle map display"
        PRINT "F             :  Toggle FPS display"
        PRINT "W             :  Toggle wait for retrace (if enabled, graphics refresh slower)"
        PRINT "C             :  Toggle collisions"
        PRINT "Escape        :  Exit"
        PRINT "----------"
        FILES ("*.BSP")
        PRINT "----------"
        PRINT "Please select a level: ";
        INPUT "", f$
        'f$ = "t.bsp"
       
        ' Check for valid BSP file to be nice to bad typists
        OPEN f$ FOR BINARY AS #1
                IF LOF(1) < 1 THEN
                        PRINT "File does not exist, aborting."
                        CLOSE #1
                        KILL f$
                        SYSTEM
                ELSE
                        Valid$ = SPACE$(5)
                        GET #1, , Valid$
                        IF Valid$ <> "MKBSP" THEN
                                PRINT "File is not a valid MK BSP file, aborting."
                                CLOSE #1
                                SYSTEM
                        END IF
                END IF
        CLOSE #1
       
        SCREEN 13
        BSPGetFile$ = f$
END FUNCTION

SUB BSPLoad (f$)
        ' Load a BSP file
        OPEN f$ FOR BINARY AS #1
                Valid$ = SPACE$(5)
                GET #1, , Valid$
                GET #1, , Version!
                GET #1, , WorldSize
                GET #1, , player.X
                GET #1, , player.y
                GET #1, , player.angle
                reserved$ = INPUT$(50, #1)
           
                FOR X% = 1 TO WorldSize
                        GET #1, , BSP(X%).VerticePtr
                        GET #1, , BSP(X%).FrontTree
                        GET #1, , BSP(X%).BackTree
                NEXT
              
                FOR X% = 0 TO WorldSize - 1
                        GET #1, , World(X%).StartX
                        GET #1, , World(X%).StartY
                        GET #1, , World(X%).EndX
                        GET #1, , World(X%).EndY
                        GET #1, , World(X%).StartT
                        GET #1, , World(X%).EndT
                        GET #1, , World(X%).StartTop
                        GET #1, , World(X%).StartBot
                        GET #1, , World(X%).EndTop
                        GET #1, , World(X%).EndBot
                        GET #1, , World(X%).Col
                        GET #1, , World(X%).ShadeCol
                NEXT
        CLOSE #1
END SUB

FUNCTION BSPSize% (f$)
        OPEN f$ FOR BINARY AS #1
                Valid$ = SPACE$(5)
                GET #1, , Valid$
                GET #1, , Version!
                IF Version! > CurBSPVersion THEN
                        PRINT "Advanced BSP file version encountered."
                        PRINT "This program can handle up to version "; CurBSPVersion!
                        PRINT "This BSP file is"; Version!
                        SYSTEM
                END IF
                GET #1, , Size%
        CLOSE #1
        BSPSize% = Size%
END FUNCTION

DEFINT A-Z
SUB BuildTables
        'create degree sin/cos tables
        FOR angle% = 0 TO 360
                SinT((angle% + 0) MOD 360) = SIN(angle% * pi / 180)
                cost((angle% + 0) MOD 360) = COS(angle% * pi / 180)
        NEXT
END SUB

DEFSNG A-Z
SUB ConsoleClear
        IF player.FullScreen = True THEN EXIT SUB
        ' Clear the console text
        player.ConsoleActive = False
        LINE (1, 175)-(318, 183), 0, BF
END SUB

SUB ConsoleUpdate (a$)
        IF player.FullScreen = True THEN EXIT SUB
        ' Update console with new text string
        CALL ConsoleClear
        LOCATE 23, 2
        PRINT a$
        player.ConsoleActive = True
        player.ConsoleStartTime = TIMER
END SUB

SUB DisplayFPS
        ' Average MaxFrames frame times and give FPS estimate
        FOR X% = 0 TO MaxFrames
                TotalTime! = TotalTime! + Times(X%)
        NEXT
        AverageFrameTime! = TotalTime! / MaxFrames
        CALL ConsoleClear
        IF AverageFrameTime! <> 0 THEN
                FPS! = 1 / AverageFrameTime!
                CALL ConsoleUpdate("FPS: " + STR$(FPS!))
        ELSE
                CALL ConsoleUpdate("FPS: Infinity")
        END IF
END SUB

FUNCTION IsInFront% (X%)
        nx! = (ViewSpace(X%).StartY - ViewSpace(X%).EndY)
        ny! = -(ViewSpace(X%).StartX - ViewSpace(X%).EndX)
       
        numer! = nx! * (ViewSpace(X%).StartX)
        numer! = numer! + (ny! * (ViewSpace(X%).StartY))
        IF numer! < 0 THEN
                IsInFront% = 1
        ELSE
                IsInFront% = 0
        END IF
END FUNCTION

SUB LoadAsm
Zkbh$(0) = ""
Zkbh$(0) = Zkbh$(0) + CHR$(&H55)
Zkbh$(0) = Zkbh$(0) + CHR$(&H89) + CHR$(&HE5)
Zkbh$(0) = Zkbh$(0) + CHR$(&HB8) + CHR$(&H9) + CHR$(&H35)
Zkbh$(0) = Zkbh$(0) + CHR$(&HCD) + CHR$(&H21)
Zkbh$(0) = Zkbh$(0) + CHR$(&H31) + CHR$(&HC0)
Zkbh$(0) = Zkbh$(0) + CHR$(&H89) + CHR$(&HD8)
Zkbh$(0) = Zkbh$(0) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
Zkbh$(0) = Zkbh$(0) + CHR$(&H89) + CHR$(&H7)
Zkbh$(0) = Zkbh$(0) + CHR$(&H8C) + CHR$(&HC0)
Zkbh$(0) = Zkbh$(0) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
Zkbh$(0) = Zkbh$(0) + CHR$(&H89) + CHR$(&H7)
Zkbh$(0) = Zkbh$(0) + CHR$(&H5D)
Zkbh$(0) = Zkbh$(0) + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)

Zkbh$(1) = ""
Zkbh$(1) = Zkbh$(1) + CHR$(&H55)
Zkbh$(1) = Zkbh$(1) + CHR$(&H1E)
Zkbh$(1) = Zkbh$(1) + CHR$(&H89) + CHR$(&HE5)
Zkbh$(1) = Zkbh$(1) + CHR$(&H8B) + CHR$(&H46) + CHR$(&HA)
Zkbh$(1) = Zkbh$(1) + CHR$(&H8E) + CHR$(&HD8)
Zkbh$(1) = Zkbh$(1) + CHR$(&H8B) + CHR$(&H56) + CHR$(&H8)
Zkbh$(1) = Zkbh$(1) + CHR$(&HB8) + CHR$(&H9) + CHR$(&H25)
Zkbh$(1) = Zkbh$(1) + CHR$(&HCD) + CHR$(&H21)
Zkbh$(1) = Zkbh$(1) + CHR$(&H1F)
Zkbh$(1) = Zkbh$(1) + CHR$(&H5D)
Zkbh$(1) = Zkbh$(1) + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)

Zkbh$(2) = ""
Zkbh$(2) = Zkbh$(2) + CHR$(&H50)
Zkbh$(2) = Zkbh$(2) + CHR$(&H53)
Zkbh$(2) = Zkbh$(2) + CHR$(&H1E)
Zkbh$(2) = Zkbh$(2) + CHR$(&HFB)
Zkbh$(2) = Zkbh$(2) + CHR$(&HB8) + MKI$(VARSEG(ZKey%(0)))
Zkbh$(2) = Zkbh$(2) + CHR$(&H31) + CHR$(&HDB)
Zkbh$(2) = Zkbh$(2) + CHR$(&H8E) + CHR$(&HD8)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE4) + CHR$(&H60)
Zkbh$(2) = Zkbh$(2) + CHR$(&HD0) + CHR$(&HD0)
Zkbh$(2) = Zkbh$(2) + CHR$(&H88) + CHR$(&HC3)
Zkbh$(2) = Zkbh$(2) + CHR$(&HF) + CHR$(&H93) + CHR$(&HC0)
Zkbh$(2) = Zkbh$(2) + CHR$(&H81) + CHR$(&HC3) + MKI$(VARPTR(ZKey%(0)))
Zkbh$(2) = Zkbh$(2) + CHR$(&H88) + CHR$(&H7)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE4) + CHR$(&H61)
Zkbh$(2) = Zkbh$(2) + CHR$(&H80) + CHR$(&HCC) + CHR$(&H82)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE6) + CHR$(&H61)
Zkbh$(2) = Zkbh$(2) + CHR$(&H24) + CHR$(&H7F)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE6) + CHR$(&H61)
Zkbh$(2) = Zkbh$(2) + CHR$(&HB0) + CHR$(&H20)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE6) + CHR$(&H20)
Zkbh$(2) = Zkbh$(2) + CHR$(&H1F)
Zkbh$(2) = Zkbh$(2) + CHR$(&H5B)
Zkbh$(2) = Zkbh$(2) + CHR$(&H58)
Zkbh$(2) = Zkbh$(2) + CHR$(&HCF)
END SUB

SUB MainInit (f$)
        RANDOMIZE TIMER
       
        ' Load world from file
        CALL BSPLoad(f$)

        'CALL WorldCopy(World(), ViewSpace())

        ' Build SIN/COS tables
        BuildTables
        ' Initialize player variables
        CALL PlayerInit

        ' Initialize Palette
        CALL PalInit
       
        ' Load keyboard handling code
        CALL LoadAsm
       
        ' Set default text color
        COLOR 31
END SUB

SUB OSBClear
        ' Write pixel data directly to buffer
        err$ = "OSB Clearing"
        Horizon% = ((player.Eyelevel) / (BackClipPlane * 50)) * player.HalfSx + player.HalfSY
        IF Horizon% > player.ScreenY THEN Horizon% = player.ScreenY

        TopColBlock! = Horizon% / 28
        
        RemBlock% = (TopColBock! * player.ScreenX) MOD player.ScreenX
        'IF RemBlock% <> 0 THEN
        '        IF RemBlock% > player.screenX / 2 THEN
        '                TopColBlock! = TopColBlock! + RemBlock%
        '        ELSE
        '                TopColBlock! = TopColBlock! - RemBlock%
        '        END IF
        'END IF

        BotColBlock! = (player.ScreenY - Horizon%) / 28

        Top& = player.ScreenX * Horizon%
        Strip& = 1

        DEF SEG = VARSEG(OsBuffer(2))
        ptr& = VARPTR(OsBuffer(2))
                FOR Col% = 1 TO 28
                        ' Draw ceiling
                        FOR Strip& = Strip& TO (Strip& + (player.ScreenX - 1) * TopColBlock!)      'Top&
                                POKE ptr&, 128 - Col%
                                ptr& = ptr& + 1
                        NEXT
                NEXT
              
                ' Correct error
         '       Strip& = Horizon% * (player.screenX - 0) - 1
         '       Ptr& = (Horizon% - 1) * (player.screenX - 1)


                IF Strip& >= (player.ScreenY * player.ScreenX) THEN EXIT SUB
                IF Strip& + (player.ScreenX * BotColBlock! * 15) > player.ScreenX * player.ScreenY THEN EXIT SUB

                FOR Col% = 1 TO 28
                        ' Draw Floor
                        FOR Strip& = Strip& TO (Strip& + (player.ScreenX - 0) * BotColBlock!)      'Top&
                                POKE ptr&, Col%
                                ptr& = ptr& + 1
                        NEXT
                NEXT

                ' Leftover
                IF Strip& <> player.ScreenX * player.ScreenY THEN
                        FOR Strip& = Strip& TO player.ScreenX * player.ScreenY
                                POKE ptr&, Col%
                                ptr& = ptr& + 1
                        NEXT
                END IF
        DEF SEG
END SUB

SUB OSBDrawFlat (X%)
        ' Draws a filled wall onto off screen buffer
        ' All floating point calculations were changed
        ' to fixed point for speed
      
        TopInt% = FIX(DrawList(X%).yTopSlope)
        TopFrac% = (DrawList(X%).yTopSlope - TopInt%) * 10000
        TopInc% = SGN(TopFrac%)
       

        BotInt% = FIX(DrawList(X%).yBotSlope)
        BotFrac% = (DrawList(X%).yBotSlope - BotInt%) * 10000
        BotInc% = SGN(BotFrac%)

        ' Calculate starting points for top,bottom,depth
        CurTopy% = DrawList(X%).yTopStart
        CurBotY% = DrawList(X%).yBotStart
        CurDepth% = DrawList(X%).DepthStart
       

        ' Calculate the lowest color attribute for shading
        Col% = World(X%).Col
    
        DEF SEG = VARSEG(OsBuffer(2))
        DefPtr& = VARPTR(OsBuffer(2))
   
        FOR S% = DrawList(X%).xStart TO DrawList(X%).xEnd
                StartY% = CurTopy%
                EndY% = CurBotY%
           
                ' Make sure at least one endpoint is onscreen
                IF (CurTopy% >= player.ScreenY AND CurBotY% >= player.ScreenY) OR (CurTopy% < 0 AND CurBotY% < 0) THEN
              
                ELSE
               
                        IF CurTopy% < 0 AND CurBotY% >= player.ScreenY THEN
                                StartY% = 0
                                EndY% = player.ScreenY
                        ELSEIF CurBotY% >= player.ScreenY THEN
                                EndY% = player.ScreenY
                        ELSEIF CurTopy% < 0 THEN
                                StartY% = 0
                        END IF

                        StripLen% = EndY% - StartY%
             

                        ptr& = DefPtr& + (S% + StartY% * player.ScreenX)
                        FOR Strip% = 1 TO StripLen%
                                POKE ptr&, Col%
                                ptr& = ptr& + player.ScreenX
                        NEXT
                END IF
              
                CurTopy% = CurTopy% + TopInt%
                CurTopFrac% = CurTopFrac% + TopFrac%
                IF ABS(CurTopFrac%) > 10000 THEN
                        CurTopy% = CurTopy% + TopInc%
                        CurTopFrac% = CurTopFrac% MOD 10000
                END IF

                CurBotY% = CurBotY% + BotInt%
                CurBotFrac% = CurBotFrac% + BotFrac%
                IF ABS(CurBotFrac%) > 10000 THEN
                        CurBotY% = CurBotY% + BotInc%
                        CurBotFrac% = CurBotFrac% MOD 10000
                END IF
              
        NEXT
        DEF SEG
END SUB

SUB OSBDrawShaded (X%)
        err$ = "OSB Draw Shaded"
        ' Draws a filled wall onto off screen buffer
        ' All floating point calculations were changed
        ' to fixed point for speed

        ' Fixed point shading
        DepthInt% = FIX(DrawList(X%).DepthSlope)
        DepthFrac% = (DrawList(X%).DepthSlope - DepthInt%) * 10000
        DepthInc% = SGN(DepthFrac%)
      
       
        TopInt% = FIX(DrawList(X%).yTopSlope)
        TopFrac% = (DrawList(X%).yTopSlope - TopInt%) * 10000
        TopInc% = SGN(TopFrac%)
        

        BotInt% = FIX(DrawList(X%).yBotSlope)
        BotFrac% = (DrawList(X%).yBotSlope - BotInt%) * 10000
        BotInc% = SGN(BotFrac%)

        ' Calculate starting points for top,bottom,depth
        CurTopy% = DrawList(X%).yTopStart
        CurBotY% = DrawList(X%).yBotStart
        CurDepth% = DrawList(X%).DepthStart
        

        ' Calculate the lowest color attribute for shading
        LowCol% = (World(X%).ShadeCol) * 32
     
        DEF SEG = VARSEG(OsBuffer(2))
        DefPtr& = VARPTR(OsBuffer(2))
    
        FOR S% = DrawList(X%).xStart TO DrawList(X%).xEnd
                StartY% = CurTopy%
                EndY% = CurBotY%
            
                ' Make sure at least one endpoint is onscreen
                IF (CurTopy% >= player.ScreenY AND CurBotY% >= player.ScreenY) OR (CurTopy% < 0 AND CurBotY% < 0) THEN
               
                ELSE
                
                        IF CurTopy% < 0 AND CurBotY% >= player.ScreenY THEN
                                StartY% = 0
                                EndY% = player.ScreenY
                        ELSEIF CurBotY% >= player.ScreenY THEN
                                EndY% = player.ScreenY
                        ELSEIF CurTopy% < 0 THEN
                                StartY% = 0
                        END IF

                        StripLen% = EndY% - StartY%
              
                        Col% = ((CurDepth%) / (VisibleDepth)) * 32
                        IF Col% >= 27 THEN Col% = 27
                        Col% = LowCol% - Col%

                        ptr& = DefPtr& + (S% + StartY% * player.ScreenX)
                        FOR Strip% = 1 TO StripLen%
                                POKE ptr&, Col%
                                ptr& = ptr& + player.ScreenX
                        NEXT
                END IF
               
                CurTopy% = CurTopy% + TopInt%
                CurTopFrac% = CurTopFrac% + TopFrac%
                IF ABS(CurTopFrac%) > 10000 THEN
                        CurTopy% = CurTopy% + TopInc%
                        CurTopFrac% = CurTopFrac% MOD 10000
                END IF

                CurBotY% = CurBotY% + BotInt%
                CurBotFrac% = CurBotFrac% + BotFrac%
                IF ABS(CurBotFrac%) > 10000 THEN
                        CurBotY% = CurBotY% + BotInc%
                        CurBotFrac% = CurBotFrac% MOD 10000
                END IF
               
                CurDepth% = CurDepth% + DepthInt%
                CurDepthFrac% = CurDepthFrac% + DepthFrac%
                IF ABS(CurDepthFrac%) > 10000 THEN
                        CurDepth% = CurDepth% + DepthInc%
                        CurDepthFrac% = 0
                END IF
        NEXT
        DEF SEG
END SUB

SUB OSBDrawWire (X%)
        ' Draws a filled wall onto off screen buffer
        ' All floating point calculations were changed
        ' to fixed point for speed
     
        TopInt% = FIX(DrawList(X%).yTopSlope)
        TopFrac% = (DrawList(X%).yTopSlope - TopInt%) * 10000
        TopInc% = SGN(TopFrac%)
      

        BotInt% = FIX(DrawList(X%).yBotSlope)
        BotFrac% = (DrawList(X%).yBotSlope - BotInt%) * 10000
        BotInc% = SGN(BotFrac%)

        ' Calculate starting points for top,bottom,depth
        CurTopy% = DrawList(X%).yTopStart
        CurBotY% = DrawList(X%).yBotStart
        CurDepth% = DrawList(X%).DepthStart
      

        ' Calculate the lowest color attribute for shading
        Col% = World(X%).Col
   
        DEF SEG = VARSEG(OsBuffer(2))
        DefPtr& = VARPTR(OsBuffer(2))
 
        xs% = DrawList(X%).xStart
        xe% = DrawList(X%).xEnd
        FOR S% = xs% TO xe%
                StartY% = CurTopy%
                EndY% = CurBotY%
          
                ' Make sure at least one endpoint is onscreen
                IF (CurTopy% >= player.ScreenY AND CurBotY% >= player.ScreenY) OR (CurTopy% < 0 AND CurBotY% < 0) THEN
             
                ELSE
              
                        IF CurTopy% < 0 AND CurBotY% >= player.ScreenY THEN
                                StartY% = 0
                                EndY% = player.ScreenY
                        ELSEIF CurBotY% >= player.ScreenY THEN
                                EndY% = player.ScreenY
                        ELSEIF CurTopy% < 0 THEN
                                StartY% = 0
                        END IF

                        StripLen% = EndY% - StartY%
            

                        ptr& = DefPtr& + (S% + StartY% * player.ScreenX)
                        FOR Strip% = 1 TO StripLen%
                                IF Strip% = 1 OR Strip% = StripLen% OR S% = xs% OR S% = xe% THEN
                                        POKE ptr&, Col%
                                END IF
                                ptr& = ptr& + player.ScreenX
                        NEXT
                END IF
             
                CurTopy% = CurTopy% + TopInt%
                CurTopFrac% = CurTopFrac% + TopFrac%
                IF ABS(CurTopFrac%) > 10000 THEN
                        CurTopy% = CurTopy% + TopInc%
                        CurTopFrac% = CurTopFrac% MOD 10000
                END IF

                CurBotY% = CurBotY% + BotInt%
                CurBotFrac% = CurBotFrac% + BotFrac%
                IF ABS(CurBotFrac%) > 10000 THEN
                        CurBotY% = CurBotY% + BotInc%
                        CurBotFrac% = CurBotFrac% MOD 10000
                END IF
             
        NEXT
        DEF SEG
       
END SUB

SUB OSBInit
        ' Initialize Off-Screen buffer by writing in the dimensions
        OsBuffer(0) = player.ScreenX * 8
        OsBuffer(1) = player.ScreenY

        ' Now clear the buffer
        CALL OSBClear
END SUB

SUB PalInit
        ' Initialize Palette
        ' low color = low intensity, high color = high intensity
        Inc% = 4
       
        ' Shades 1-16 (Shade Color 1) is white
        start% = 0
        FOR X% = 1 TO 32
                CALL PalSet(X%, start%, start%, start%)
                start% = start% + 2
        NEXT
        
        ' Shades 33-64 (Shade Color 2) is red
        start% = 0
        FOR X% = 33 TO 64
                CALL PalSet(X%, start%, 0, 0)
                start% = start% + 2
        NEXT

        ' Shades 65-96 (Shade Color 3) is green
        start% = 0
        FOR X% = 65 TO 96
                CALL PalSet(X%, start%, start%, 0)
                start% = start% + 2
        NEXT

        ' Shades 97-128 (Shade Color 4) is blue
        start% = 0
        FOR X% = 97 TO 128
                CALL PalSet(X%, 0, 0, start%)
                start% = start% + 2
        NEXT
       
        ' Shades 129-160 (Shade Color 5) is green
        start% = 0
        FOR X% = 129 TO 160
                CALL PalSet(X%, 0, start%, 0)
                start% = start% + 2
        NEXT
      
        ' Shades 161-192 (Shade Color 6) is purple
        start% = 0
        FOR X% = 161 TO 192
                CALL PalSet(X%, start%, 0, start%)
                start% = start% + 2
        NEXT

        ' Shades 193-224 (Shade Color 7) is orange
        start% = 0
        FOR X% = 193 TO 224
                CALL PalSet(X%, start%, start% / 2, start% / 12)
                start% = start% + 2
        NEXT

        ' Shades 225-255 (Shade Color 8) are reserved for other uses
END SUB

SUB PalSet (at%, R%, g%, B%)
OUT &H3C8, at%
OUT &H3C9, R%: OUT &H3C9, g%: OUT &H3C9, B%
END SUB

SUB PlayerInit
'        player.x = 20
'        player.y = -1
        player.angle = 0
        player.speed = 1
        player.rotinc = 4
        player.FPSOn = NULL
        'player.LOD = WireFrame
        'player.LOD = FilledWalls
        player.LOD = ShadedWalls
        player.ShowMap = False'True
        player.ConsoleActive = False
        player.ScreenX = 318
        player.ScreenY = 172
        player.HalfSx = player.ScreenX / 2
        player.HalfSY = player.ScreenY / 2
        player.xStart = 1
        player.YStart = 1
        player.WaitVR = False'True
        player.FullScreen = False
        player.Collisions = True
       
        player.MaxSpeed = 1
        player.accel = 1.61     ' Acceleration - Larger above one, faster
        player.decel = .75       ' Deceleration - Closer to one, slower it takes
        player.InitSpeed = 1
        player.Footlevel = 0
        player.Eyelevel = 6

        player.JumpStatus = False
END SUB

SUB PlayerJump
        err$ = "Player Jumping"
        ' Alter vector (gravity)
        player.JumpVect = player.JumpVect - player.Gravity * (TIMER - player.JumpTime)

        ' Change position
        player.Footlevel = player.Footlevel + player.JumpVect
        player.Eyelevel = player.Eyelevel + player.JumpVect

        ' Check for landing
        IF player.Footlevel <= 0 THEN
                player.Footlevel = 0
                player.Eyelevel = 6
                player.JumpStatus = False
        END IF
END SUB

SUB PlayerMove (nx!, ny!)
        err$ = "Player Movement"
        ' Calculate acceleration in X direction if we receive an incoming
        ' force in x
        IF ABS(nx!) > Zero THEN
                IF player.ax <> 0 THEN
                        ' Tweak current acceleration
                        IF SGN(nx!) = SGN(player.ax) THEN
                                ' If current acceleration is in direction
                                ' of new force then compound it
                               nax! = (player.accel * player.ax)' * -SGN(player.accel)
                        ELSE
                               ' Going against acceleration so decrease it
                               nax! = player.InitSpeed * (nx!)
                        END IF
                ELSE
                        ' Provide initial acceleration
                        nax! = player.InitSpeed * (nx!)
                END IF
        ELSE
                'nax! = player.ax * player.decel
        END IF
      
        IF ABS(ny!) > Zero THEN
                IF player.ay <> 0 THEN
                        ' Tweak current acceleration
                        IF SGN(ny!) = SGN(player.ay) THEN
                                ' If current acceleration is in direction
                                ' of new force then compound it
                                nay! = (player.accel * player.ay)' * -SGN(player.accel)
                        ELSE
                               ' Going against acceleration so decrease it
                                nay! = player.InitSpeed * (ny!)
                        END IF
                ELSE
                        ' Provide initial acceleration (note that the sign is
                        ' added here
                        nay! = player.InitSpeed * (ny!)
                END IF
        ELSE
               
                'nay! = player.ay * player.decel
        END IF



        ' Now we have the acceleration (player.ax,player.ay) so calculate
        ' new velocity taking da-acceleration into account
      
        nvx! = (player.vx + nax!) * player.decel
        nvy! = (player.vy + nay!) * player.decel


        ' Truncate speed if too fast
        player.speed = SQR(nvx! * nvx! + nvy! * nvy!)
        IF player.speed > player.MaxSpeed THEN
                ratio! = player.MaxSpeed / player.speed
                nvx! = nvx! * ratio!
                nvy! = nvy! * ratio!
                nax! = nax! * ratio!
                nay! = nay! * ratio!
                player.speed = player.MaxSpeed
        END IF

        CALL WorldColDetect(nvx!, nvy!)

        ' Change position and store vector
        player.X = player.X + nvx!
        player.y = player.y + nvy!
      
        ' Store new acceleration
        player.ax = nax!
        player.ay = nay!
      
        ' Store new velocity
        player.vx = nvx!
        player.vy = nvy!


        IF ABS(player.ax) < Zero THEN player.ax = 0
        IF ABS(player.ay) < Zero THEN player.ay = 0

        IF ABS(player.vx) < Zero THEN player.vx = 0
        IF ABS(player.vy) < Zero THEN player.vy = 0

        nx! = 0
        ny! = 0
END SUB

FUNCTION PlayerUpdate%
        ' Scans user input and moves player appropiately
        err$ = "Player Input"
        Status% = Idle
        'player.BobAmp = 0
        ' Parse player input and update player settings
       
        ' P - Pause
        IF ZKey%(25) THEN
                CALL ZkbRelease(25)
        END IF
       
        IF ZKey%(72) THEN
                'up
                nx! = -SinT(player.angle)
                ny! = -cost(player.angle)
                CALL PlayerMove(nx!, ny!)
                player.BobAmp = 20
                Status% = Moved
        END IF

        IF ZKey%(80) THEN
                ' Down
                nx! = SinT(player.angle)
                ny! = cost(player.angle)
                CALL PlayerMove(nx!, ny!)
                player.BobAmp = 20
                Status% = Moved
        END IF
        IF ZKey%(75) THEN
                ' Left, rotate angle
                player.angle = (player.angle + player.rotinc) MOD 360
                Status% = NeedRedraw
        END IF
        IF ZKey%(77) THEN
                ' Right, rotate angle
                player.angle = player.angle - player.rotinc
                IF player.angle < 0 THEN player.angle = 360 + player.angle
                Status% = NeedRedraw
        END IF
        IF ZKey%(30) THEN
                ' Strafe left
                ang% = (player.angle + 90) MOD 360
                nx! = -SinT(ang%)
                ny! = -cost(ang%)
                CALL PlayerMove(nx!, ny!)
                player.BobAmp = 10
                Status% = Moved
        END IF
        IF ZKey%(32) THEN
                ' Strafe right
                ang% = player.angle - 90
                IF ang% < 0 THEN ang% = 360 + ang%
                nx! = -SinT(ang%)
                ny! = -cost(ang%)
                CALL PlayerMove(nx!, ny!)
                player.BobAmp = 10
                Status% = Moved
        END IF
        ' S - Normal Jump
        IF ZKey%(31) AND player.JumpStatus = False THEN
                player.Gravity = 5
                player.JumpStatus = True
                player.JumpVect = 40
                player.JumpTime = TIMER - .1
                Status% = NeedRedraw
        END IF
        IF ZKey%(33) AND player.FullScreen <> True THEN
                ' F - toggle FPS counter
                IF player.FPSOn = NULL THEN
                        player.FPSOn = 1
                        CurFrame% = 0
                        CALL ConsoleUpdate("Frames per second display turned on.")
                ELSE
                        player.FPSOn = NULL
                        CALL ConsoleUpdate("Frames per second display turned off.")
                END IF
                CALL ZkbRelease(33)
                Status% = NeedRedraw
        END IF
        IF ZKey%(50) THEN
                ' M - Toggle Map
                IF player.ShowMap = False THEN
                        player.ShowMap = True
                        CALL ConsoleUpdate("Map display turned on.")
                ELSE
                        CALL VSDrawAll(SavedSpace(), 0)
                        player.ShowMap = False
                        CALL ConsoleUpdate("Map display turned off.")
                END IF
                CALL ZkbRelease(50)
                Status% = NeedRedraw
        END IF
        IF ZKey%(44) AND player.JumpStatus = False THEN
                ' Z - Moon Jump
                player.Gravity = 1
                player.JumpStatus = True
                player.JumpVect = 60
                player.JumpTime = TIMER - .1
                Status% = NeedRedraw
              

                ' Old move eyelevel up code
                'IF player.Eyelevel < 1000 THEN
                '        player.Eyelevel = player.Eyelevel + 10
                '        player.Footlevel = player.Footlevel + 10
                'END IF
                
                Status% = NeedRedraw
        END IF

        IF ZKey%(46) THEN
                ' C - Toggle Collisions
                IF player.Collisions = False THEN
                        player.Collisions = True
                        CALL ConsoleUpdate("Collisions turned on.")
                ELSE
                        player.Collisions = False
                        CALL ConsoleUpdate("Collisions turned off.")
                END IF
                CALL ZkbRelease(46)
        END IF

        IF ZKey%(38) THEN
                ' L - Change level of detail
                player.LOD = ((player.LOD + 1) MOD 4)
                IF player.LOD = 0 THEN player.LOD = 1
                CALL ConsoleUpdate("Level of detail is now" + STR$(player.LOD))
                CALL ZkbRelease(38)
                Status% = NeedRedraw
        END IF
        IF ZKey%(13) THEN
                ' ; Increase window size
                IF player.ScreenX < 318 THEN
                             player.ScreenX = player.ScreenX + 16
                             player.ScreenY = player.ScreenY + 10
                             player.HalfSx = player.HalfSx + 8
                             player.HalfSY = player.HalfSY + 5
                             player.xStart = player.xStart - 8
                             player.YStart = player.YStart - 5
                             CALL ConsoleUpdate("New window: " + STR$(player.ScreenX) + " x" + STR$(player.ScreenY))
                             CALL OSBInit
                ELSE
                        ' Full Screen
                        player.FullScreen = True
                        player.ScreenX = 320
                        player.ScreenY = 200
                        player.HalfSx = 160
                        player.HalfSY = 100
                        player.xStart = 0
                        player.YStart = 0
                        player.FPSOn = NULL
                        CALL OSBInit
                END IF
                CALL ZkbRelease(13)
                Status% = NeedRedraw%
        END IF
        IF ZKey%(12) THEN
                ' Decrease window size
                IF player.FullScreen = False THEN
                        IF player.ScreenX > 78 THEN
                                LINE (player.xStart - 1, player.YStart - 1)-(player.xStart + player.ScreenX, player.YStart + player.ScreenY), 0, BF
                                player.ScreenX = player.ScreenX - 16
                                player.ScreenY = player.ScreenY - 10
                                player.HalfSx = player.HalfSx - 8
                                player.HalfSY = player.HalfSY - 5
                                player.xStart = player.xStart + 8
                                player.YStart = player.YStart + 5
                                CALL ConsoleUpdate("New window: " + STR$(player.ScreenX) + " x" + STR$(player.ScreenY))
                                CALL OSBInit
                        END IF
                ELSE
                        player.ScreenX = 318
                        player.ScreenY = 172
                        player.HalfSx = player.ScreenX / 2
                        player.HalfSY = player.ScreenY / 2
                        player.xStart = 1
                        player.YStart = 1
                        LINE (0, 0)-(320, 200), 0, BF
                        CALL ConsoleUpdate("Full-Screen Mode Disabled.")
                        CALL OSBInit
                        player.FullScreen = False
                END IF
                CALL ZkbRelease(12)
                Status% = NeedRedraw%
        END IF
        IF ZKey%(17) THEN
                ' Toggle waiting for VR
                IF player.WaitVR = True THEN
                        player.WaitVR = False
                        CALL ConsoleUpdate("Waiting for retrace disabled.")
                ELSE
                        player.WaitVR = True
                        CALL ConsoleUpdate("Waiting for retrace enabled.")
                END IF
                CALL ZkbRelease(17)
        END IF


        ' If velocity is not zero then we are moved, too
        IF (player.vx <> 0 OR player.vy <> 0) AND Status% <> Moved THEN Status% = Coasting

        PlayerUpdate% = Status%
END FUNCTION

SUB TreeWalk (CurRoot%)
        err$ = "Walking Tree"
        ' Walk the BSP tree front to back
       
        ' If wall is facing player than draw backspace, wall, frontspace

        CurWall% = BSP(CurRoot%).VerticePtr
        IF IsInFront(CurWall%) = 1 THEN
                ' Draw back space
                IF BSP(CurRoot%).BackTree <> NULL THEN
                        CALL TreeWalk(BSP(CurRoot%).BackTree)
                END IF
                ' Draw wall if visible
                IF ViewSpace(CurWall%).IsVisible = True THEN
                        CALL VerticeDraw(CurWall%)
                END IF
                ' Draw front space
                IF BSP(CurRoot%).FrontTree <> NULL THEN
                        CALL TreeWalk(BSP(CurRoot%).FrontTree)
                END IF
        ELSE
               ' Draw front space
                IF BSP(CurRoot%).FrontTree <> NULL THEN
                        CALL TreeWalk(BSP(CurRoot%).FrontTree)
                END IF
               ' Draw wall if visible
                IF ViewSpace(CurWall%).IsVisible = True THEN
                        CALL VerticeDraw(CurWall%)
                END IF
                ' Draw back space
                IF BSP(CurRoot%).BackTree <> NULL THEN
                        CALL TreeWalk(BSP(CurRoot%).BackTree)
                END IF
        END IF
END SUB

SUB VerticeDraw (X%)
                ' Make (x0,y0)-(x1,y1) the leftmost vertical line
                
                SELECT CASE player.LOD
                        CASE WireFrame:
                                CALL OSBDrawWire(X%)
                        CASE FilledWalls:
                                CALL OSBDrawFlat(X%)
                                'CALL DDrawFlat(X%)
                        CASE ShadedWalls:
                                CALL OSBDrawShaded(X%)
                END SELECT
END SUB

SUB VSClipWalls
        err$ = "Clipping"
        ' Go through the view space and clip walls
        FOR X% = 0 TO WorldSize - 1
                ' ****** Clip in Y direction ******
                ' Assume wall is not visible
                ViewSpace(X%).IsVisible = False

                ty0! = ViewSpace(X%).StartY
                ty1! = ViewSpace(X%).EndY
                tstop! = World(X%).StartTop
                tsbot! = World(X%).StartBot
                tetop! = World(X%).EndTop
                tebot! = World(X%).EndBot

                ' First clip all walls that are behind viewer
                ' That is, remove all walls in the  180 angle region
                ' behind player
             
               
                IF (ty0! > -FrontClipPlane) THEN
                        ' First vertice is not visible...
                        IF (ty1! > -FrontClipPlane) THEN
                                ' Both vertices are behind, we are done
                                GOTO NextWall
                        ELSE
                                ' First vertice is behind, second is visible
                                ' Clip by calculating a new start t value
                                ' and new temp starting y value
                                ViewSpace(X%).StartT = (ViewSpace(X%).StartY + FrontClipPlane) / (ViewSpace(X%).StartY - ViewSpace(X%).EndY)
                                ty0! = ViewSpace(X%).StartY + ViewSpace(X%).StartT * (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                                ViewSpace(X%).IsVisible = True
                        END IF
                ELSE
                        ' First vertice is visible so we know line is at least
                        ' partially visible.  If we don't clip then the line
                        ' is totally visible (both vertices are visible)
                        ViewSpace(X%).IsVisible = True
                        IF (ty1! > -FrontClipPlane) THEN
                                ' Second vertice is not visible to clip end t
                                ' and calculate new end y value
                                ViewSpace(X%).EndT = (-FrontClipPlane - ViewSpace(X%).StartY) / (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                                ty1! = ViewSpace(X%).StartY + ViewSpace(X%).EndT * (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                        END IF
                END IF
               
                IF (ty0! < -BackClipPlane) THEN
                        ' First vertice is not visible...
                        IF (ty1! < -BackClipPlane) THEN
                                ' Both vertices are behind, we are done
                                ViewSpace(X%).IsVisible = False
                                GOTO NextWall
                        ELSE
                                ' First vertice is behind, second is visible
                                ' Clip by calculating a new start t value
                                ' and new temp starting y value
                                ViewSpace(X%).StartT = (ViewSpace(X%).StartY + BackClipPlane) / (ViewSpace(X%).StartY - ViewSpace(X%).EndY)
                                ty0! = ViewSpace(X%).StartY + ViewSpace(X%).StartT * (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                                ViewSpace(X%).IsVisible = True
                        END IF
                ELSE
                        ' First vertice is visible so we know line is at least
                        ' partially visible.  If we don't clip then the line
                        ' is totally visible (both vertices are visible)
                        ViewSpace(X%).IsVisible = True
                        IF (ty1! < -BackClipPlane) THEN
                                ' Second vertice is not visible to clip end t
                                ' and calculate new end y value
                                ViewSpace(X%).EndT = (-BackClipPlane - ViewSpace(X%).StartY) / (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                                ty1! = ViewSpace(X%).StartY + ViewSpace(X%).EndT * (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                        END IF
                END IF
              

                '********************************
                ' Now clip in X direction (remove all lines outside
                ' "view triangle").  Notes: View triangle is defined
                ' to be 90 degrees so it is split by the lines x = y
                ' and x = -y.  The splitting t equations are found by
                ' solving for T in two parametric equations using the
                ' fact that at the intersection point x=y.

                ' Calculate temporary starting x points
                IF ViewSpace(X%).StartT <> 0 THEN
                        tx0! = ViewSpace(X%).StartX + ViewSpace(X%).StartT * (ViewSpace(X%).EndX - ViewSpace(X%).StartX)
                ELSE
                        tx0! = ViewSpace(X%).StartX
                END IF
                IF ViewSpace(X%).EndT <> 1 THEN
                        tx1! = ViewSpace(X%).StartX + ViewSpace(X%).EndT * (ViewSpace(X%).EndX - ViewSpace(X%).StartX)
                ELSE
                        tx1! = ViewSpace(X%).EndX
                END IF
              
                ' If neither are visible go to next wall.....
                IF (tx0! < ty0! AND tx1! < ty1!) OR (tx0! > -ty0! AND tx1! > -ty1!) THEN
                        ViewSpace(X%).IsVisible = False
                        GOTO NextWall
                END IF
                ' If both are visible
                IF (tx0! >= ty0! AND tx0! <= -ty0!) AND (tx1! >= ty1! AND tx1! <= -ty1!) THEN
                        ViewSpace(X%).IsVisible = True
                ELSE
                        ' If first vertice is to left
                        IF tx0! < ty0! THEN
                                ' If second vertice is not to left then split
                                IF tx1! >= ty1! THEN
                                        ViewSpace(X%).IsVisible = True
                                        ViewSpace(X%).StartT = (ViewSpace(X%).StartX - ViewSpace(X%).StartY) / (ViewSpace(X%).EndY - ViewSpace(X%).StartY - ViewSpace(X%).EndX + ViewSpace(X%).StartX)
                                        tx0! = ViewSpace(X%).StartX + ViewSpace(X%).StartT * (ViewSpace(X%).EndX - ViewSpace(X%).StartX)
                                        ty0! = ViewSpace(X%).StartY + ViewSpace(X%).StartT * (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                                        tstop! = tstop! + ViewSpace(X%).StartT * (tetop! - tstop!)
                                        tsbot! = tsbot! + ViewSpace(X%).StartT * (tebot! - tsbot!)
                                END IF
                        END IF
                        'If first vertice is to right
                        IF tx0! > -ty0! THEN
                                ' If second vertice is not to to right then split
                                IF tx1! <= -ty1! THEN
                                        ViewSpace(X%).IsVisible = True
                                        ViewSpace(X%).StartT = (-ViewSpace(X%).StartX - ViewSpace(X%).StartY) / (ViewSpace(X%).EndX + ViewSpace(X%).EndY - ViewSpace(X%).StartY - ViewSpace(X%).StartX)
                                        tx0! = ViewSpace(X%).StartX + ViewSpace(X%).StartT * (ViewSpace(X%).EndX - ViewSpace(X%).StartX)
                                        ty0! = ViewSpace(X%).StartY + ViewSpace(X%).StartT * (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                                        tstop! = tstop! + ViewSpace(X%).StartT * (tetop! - tstop!)
                                        tsbot! = tsbot! + ViewSpace(X%).StartT * (tebot! - tsbot!)
                                END IF
                              
                        END IF
                        ' If second vertice is to left
                        IF tx1! < ty1! THEN
                                'If first vertice is not to left then split
                                IF tx0! >= ty0! THEN
                                        ViewSpace(X%).IsVisible = True
                                        ViewSpace(X%).EndT = (ViewSpace(X%).StartX - ViewSpace(X%).StartY) / (ViewSpace(X%).EndY - ViewSpace(X%).StartY - ViewSpace(X%).EndX + ViewSpace(X%).StartX)
                                        tx1! = ViewSpace(X%).StartX + ViewSpace(X%).EndT * (ViewSpace(X%).EndX - ViewSpace(X%).StartX)
                                        ty1! = ViewSpace(X%).StartY + ViewSpace(X%).EndT * (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                                        tetop! = tstop! + ViewSpace(X%).EndT * (tetop! - tstop!)
                                        tebot! = tsbot! + ViewSpace(X%).EndT * (tebot! - tsbot!)
                                END IF
                               
                        END IF
                        ' If second vertice is to right
                        IF tx1! > -ty1! THEN
                                ' If first vertice is not to right then split
                                IF tx0! <= -ty0! THEN
                                        ViewSpace(X%).IsVisible = True
                                        ViewSpace(X%).EndT = (-ViewSpace(X%).StartX - ViewSpace(X%).StartY) / (ViewSpace(X%).EndX + ViewSpace(X%).EndY - ViewSpace(X%).StartY - ViewSpace(X%).StartX)
                                        tx1! = ViewSpace(X%).StartX + ViewSpace(X%).EndT * (ViewSpace(X%).EndX - ViewSpace(X%).StartX)
                                        ty1! = ViewSpace(X%).StartY + ViewSpace(X%).EndT * (ViewSpace(X%).EndY - ViewSpace(X%).StartY)
                                        tetop! = tstop! + ViewSpace(X%).EndT * (tetop! - tstop!)
                                        tebot! = tsbot! + ViewSpace(X%).EndT * (tebot! - tsbot!)
                                END IF
                               
                        END IF
                END IF
             


                ' Last Step: project viewspace wall to screen vertices
                ' the ty0 and ty1 values are treated as Z values normally
                ' would, and Height values are treated as z values might
                ' normally be treated, to make things confusing.
              
                DrawList(X%).xStart = (tx0! / ty0!) * -player.HalfSx + player.HalfSx
                DrawList(X%).xEnd = (tx1! / ty1!) * -player.HalfSx + player.HalfSx
             
                ' Store clipped Y (z) values for shading
                DepthStart! = ABS(ty0!)
                DepthEnd! = ABS(ty1!)
                bot0% = tsbot! - player.Eyelevel
                top0% = tstop! - player.Eyelevel
                bot1% = tebot! - player.Eyelevel
                top1% = tetop! - player.Eyelevel
                quotient0% = ty0! * HalfMaxWallHeight
                quotient1% = ty1! * HalfMaxWallHeight
              
                DrawList(X%).yTopStart = (top0% / quotient0%) * player.HalfSx + player.HalfSY
                DrawList(X%).yBotStart = (bot0% / quotient0%) * player.HalfSx + player.HalfSY
                yTopEnd! = (top1% / quotient1%) * player.HalfSx + player.HalfSY
                yBotEnd! = (bot1% / quotient1%) * player.HalfSx + player.HalfSY
             
                IF DrawList(X%).xStart > DrawList(X%).xEnd THEN
                        SWAP DrawList(X%).xStart, DrawList(X%).xEnd
                        SWAP DrawList(X%).yTopStart, yTopEnd!
                        SWAP DrawList(X%).yBotStart, yBotEnd!
                        SWAP DepthStart!, DepthEnd!
                END IF
             
                DrawList(X%).DepthStart = DepthStart!

                ' Calculate slopes for drawing
                XDelta% = DrawList(X%).xEnd - DrawList(X%).xStart
                IF XDelta% <> 0 THEN
                        DrawList(X%).yTopSlope = (yTopEnd! - DrawList(X%).yTopStart) / XDelta%
                        DrawList(X%).yBotSlope = (yBotEnd! - DrawList(X%).yBotStart) / XDelta%
                        DrawList(X%).DepthSlope = (DepthEnd! - DepthStart!) / XDelta%
                        IF INT(DrawList(X%).xEnd + .5) >= player.ScreenX THEN
                                DrawList(X%).xEnd = player.ScreenX - 1
                        END IF
                ELSE
                        ViewSpace(X%).IsVisible = False
                END IF
              
NextWall:
        NEXT
END SUB

SUB VSCopy (a() AS ViewSpaceType, B() AS ViewSpaceType)
        FOR X% = 0 TO WorldSize - 1
                B(X%).StartX = a(X%).StartX
                B(X%).StartY = a(X%).StartY
                B(X%).EndX = a(X%).EndX
                B(X%).EndY = a(X%).EndY
                B(X%).StartT = a(X%).StartT
                B(X%).EndT = a(X%).EndT
                B(X%).IsVisible = True
        NEXT
END SUB

SUB VSDrawAll (a() AS ViewSpaceType, Col%)
                FOR X% = 0 TO WorldSize - 1
                        xo% = HalfWX
                        yo% = HalfWy
             
                        x1% = a(X%).StartX + a(X%).StartT * (a(X%).EndX - a(X%).StartX)
                        y1% = a(X%).StartY + a(X%).StartT * (a(X%).EndY - a(X%).StartY)
                        x2% = a(X%).StartX + a(X%).EndT * (a(X%).EndX - a(X%).StartX)
                        Y2% = a(X%).StartY + a(X%).EndT * (a(X%).EndY - a(X%).StartY)

                        LINE (x1% + xo%, y1% + yo%)-(x2% + xo%, Y2% + yo%), Col%
                NEXT
END SUB

SUB VSTranslate
        ' Transforms the world endpoints into viewspace
        ' Rotate with players position as origin
       
        FOR X% = 0 TO WorldSize - 1

                
                 ' Rotate first point
                 lx! = World(X%).StartX - player.X
                 ly! = World(X%).StartY - player.y
                 ViewSpace(X%).StartX = (cost(player.angle) * lx! - SinT(player.angle) * ly!)
                 ViewSpace(X%).StartY = (cost(player.angle) * ly! + SinT(player.angle) * lx!)
                
                 ' Rotate second point
                 lx! = World(X%).EndX - player.X
                 ly! = World(X%).EndY - player.y
                 ViewSpace(X%).EndX = (cost(player.angle) * lx! - SinT(player.angle) * ly!)
                 ViewSpace(X%).EndY = (cost(player.angle) * ly! + SinT(player.angle) * lx!)

                 ViewSpace(X%).StartT = World(X%).StartT
                 ViewSpace(X%).EndT = World(X%).EndT
                 ViewSpace(X%).IsVisible = True
        NEXT

END SUB

SUB WaitForDisplay
WAIT &H3DA, 8
END SUB

SUB WorldColDetect (mx!, my!)
err$ = "Collision Detection"
' Takes the movement vector (mx!,my!) and detects any collisions with walls,
' at which point it branches to the collision response routine.
IF player.Collisions = False THEN EXIT SUB
DO
        SaveMx! = mx!
        SaveMy! = my!
        FOR X% = 0 TO WorldSize - 1
                ' Find wall normal vector (nx!,ny!)
                nx! = World(X%).StartY - World(X%).EndY
                ny! = -(World(X%).StartX - World(X%).EndX)
     
                ' Make it a unit vector (can be precalculated)
                Magnitude! = SQR(nx! * nx! + ny! * ny!)
       
                IF Magnitude! <> 0 THEN
                        nx! = nx! / Magnitude!
                        ny! = ny! / Magnitude!
                ELSE
                        GOTO SkipThisWall
                END IF

                ' Find vector from wall vertice to player (dx!,dy!)
                dx! = (player.X + mx!) - World(X%).StartX
                dy! = (player.y + my!) - World(X%).StartY

                ' Dot N with D to find shortest distance
                shortestdistance! = (nx! * dx! + ny! * dy!)

                IF ABS(shortestdistance!) < player.MaxSpeed * 2 THEN
                        ' We collided with the wall's infinite line but we need to
                        ' see if it actually hit inside the wall's boundaries.
               
                        sx! = (player.X + mx!) - shortestdistance! * nx!
                        sy! = (player.y + my!) - shortestdistance! * ny!
                        
                        IF (ABS(nx!) <= Zero) THEN
                                ' Wall is horizontal, find X
                                t! = (sx! - World(X%).StartX) / (World(X%).EndX - World(X%).StartX)
                        ELSE
                                ' Wall is vertical, find Y
                                t! = (sy! - World(X%).StartY) / (World(X%).EndY - World(X%).StartY)
                        END IF
               
                        ' Now check if T is in bounds
                        IF t! > World(X%).StartT AND t! < World(X%).EndT THEN
                                ' Finally, check if height hits wall or not
                                HitTop! = World(X%).StartTop + t! * (World(X%).EndTop - World(X%).StartTop)
                                HitBot! = World(X%).StartBot + t! * (World(X%).EndBot - World(X%).StartBot)
                                IF player.Eyelevel < (HitTop! + 40) AND player.Eyelevel > (HitBot! - 40) THEN
                                        ' We have a collision
                                        ' Now respond to it
                                        ratio! = (mx! * nx! + my! * ny!) / (nx! * nx! + ny! * ny!)
                               
                                        ' Calculate corrected movement vector
                                        mx! = mx! - nx! * ratio!
                                        my! = my! - ny! * ratio!

                                        nx! = ABS(nx!)
                                        ny! = ABS(ny!)
                                        IF player.X + mx! > sx! THEN
                                                mx! = sx! + (player.MaxSpeed * 2) * nx! - player.X
                                        ELSE
                                                mx! = sx! - (player.MaxSpeed * 2) * nx! - player.X
                                        END IF
                                        IF player.y + my! > sy! THEN
                                                my! = sy! + (player.MaxSpeed * 2) * ny! - player.y
                                        ELSE
                                                my! = sy! - (player.MaxSpeed * 2) * ny! - player.y
                                        END IF
                                        Iter% = Iter% + 1
                                        EXIT FOR
                                END IF
                        END IF
                END IF
SkipThisWall:
        NEXT

LOOP UNTIL (ABS(SaveMx! - mx!) <= Zero) AND (ABS(SaveMy! - my!) <= Zero) OR Iter% = 15

END SUB

SUB Zkboff
IF NOT kbonflag% THEN EXIT SUB
DEF SEG = VARSEG(Zkbh$(1))
CALL ABSOLUTE(BYVAL olkbseg%, BYVAL olkboff%, SADD(Zkbh$(1)))
DEF SEG

END SUB

SUB ZKBOn

IF kbonflag% THEN EXIT SUB

DEF SEG = VARSEG(Zkbh$(0))
CALL ABSOLUTE(seg1%, off1%, SADD(Zkbh$(0)))
DEF SEG = VARSEG(Zkbh$(1))
CALL ABSOLUTE(BYVAL VARSEG(Zkbh$(2)), BYVAL SADD(Zkbh$(2)), SADD(Zkbh$(1)))
DEF SEG
OUT &H21, (INP(&H21) AND (255 XOR 2)) 'CLEAR BIT 2 (IRQ 1)

olkbseg% = seg1%
olkboff% = off1%

kbonflag% = -1
END SUB

SUB ZkbRelease (code%)
DO: LOOP WHILE ZKey%(code%)
END SUB

