' Molnar \ Kucalaba Productions' Level Creator v0.1c

' Quick Reference Keys:
' C      - Pick color of wall
' G      - Display Grid  (+ and - alter grid size)
' L      - Load BSP file
' S      - Save BSP file
' Q      - Quit
' Escape - Display help screen
'
' How To Use
' Basically you pick your color, then draw some lines, then pick another
' color, then draw more lines, etc, then hit S and save the BSP file.
' You can load intermediate files with more confidence now if you wish
' (see below for details)

' The loading problem has been fixed in version 0.1.  It might seem like
' an easy thing to implement, but efficient loading was a pain to add
' because the BSP files tend to have lines saved in a fragmented way and
' we need to put them back together.

DECLARE SUB FancyBorder ()
DECLARE SUB SetSave (OutFile$)
DECLARE SUB PgmSetSave ()
DECLARE SUB DisplayMsg ()
DECLARE SUB CheckForMenu (mx%, my%)
DECLARE SUB PgmSmooth ()
DECLARE SUB PgmGrid ()
DECLARE SUB SoftRelease ()
DECLARE SUB SetShift (xs%, ys%)
DECLARE SUB PgmLoad ()
DECLARE SUB MRelease ()
DECLARE SUB PgmQuit ()
DECLARE SUB PgmSave ()
DECLARE SUB ParseMInput (mx%, my%)
DECLARE SUB DrawMenu ()
DECLARE SUB Help ()
DECLARE SUB EditLine ()
DECLARE SUB WriteFields ()
DECLARE FUNCTION FontInput$ (xoff%, yoff%, MaxLen%, Cycle%)
DECLARE FUNCTION WorldAdd% (x0!, y0!, x1!, y1!, ts#, te#, top0!, bot0!, top1!, bot1!, Col%, ShadeCol%)
DECLARE SUB ConsoleClear ()
DECLARE SUB ConsoleAdd (m$)
DECLARE SUB ConSoleCheck ()
DECLARE SUB InsertLine (Set() AS ANY, xo!, yo!, xe!, ye!, ts#, te#, top0!, bot0!, top1!, bot1!, Col%, ShadeCol%)
DECLARE FUNCTION GetAnythingCycle$ ()
DECLARE SUB PalShade (Offset%)
DECLARE SUB PalMouseColor ()
DECLARE SUB FontWrite (xoff%, yoff%, text$)
DECLARE SUB FontInit ()
DECLARE SUB GetAnything ()
DECLARE SUB SetRemove (x%)
DECLARE SUB DoHighlighting (SetHigh%, HighLine%, InitStat%)
DECLARE FUNCTION CheckForLine% (msx%, msy%)
DECLARE SUB ParseInput ()
DECLARE SUB DosMessage ()
DECLARE SUB center (Row%, text$)
DECLARE SUB BackGround ()
DECLARE FUNCTION Slope# (x%)
DECLARE SUB SetShakeDown (Set() AS ANY)
DECLARE SUB PalNull ()
DECLARE SUB PalDefine ()
DECLARE SUB TurnOffHighlighting ()
DECLARE SUB DrawLine (x%, Col%)
DECLARE SUB SetCombine (Set() AS ANY)
DECLARE SUB DoDrawLine ()
DECLARE SUB Grid ()
DECLARE SUB TreeInit ()
DECLARE SUB BSPLoad (f$)
DECLARE SUB SetSmoothOut (Set() AS ANY)
DECLARE SUB BSPWrite (f$)
DECLARE SUB TreeBuild (Set() AS ANY, RootSet%, RootNode%)
DECLARE SUB SetInit (Set() AS ANY)
DECLARE SUB SetDraw (Set() AS ANY, Col%)
DECLARE SUB WaitForDisplay ()
DECLARE SUB PalSet (at%, r%, g%, B%)
DECLARE SUB SetSplit (Set() AS ANY, FrontSet() AS ANY, BackSet() AS ANY, RootSet%)
DECLARE FUNCTION TreeNextItem% ()
DECLARE FUNCTION SetSize% (Set() AS ANY)
DECLARE FUNCTION SetNumberOfSplits% (Set() AS ANY, RootSet%)
DECLARE FUNCTION SetNextItem% (Set() AS ANY)
DECLARE FUNCTION SetFindBestRoot% (Set() AS ANY)
DECLARE SUB Colors ()
DECLARE SUB TitleScreen ()
DECLARE FUNCTION Init% ()
DECLARE SUB Status (lb%, Rb%, XMouse%, YMouse%)
DECLARE SUB Range (x1%, y1%, x2%, y2%)
DECLARE SUB Hide ()
DECLARE SUB MouseDriver (ax%, bx%, cx%, dx%)
DECLARE SUB Show ()


'$DYNAMIC

ON ERROR GOTO errormsg

IF COMMAND$ <> "" THEN
        Stack# = VAL(COMMAND$)
END IF
IF Stack# < 5000 THEN Stack# = 25000
CLEAR , , Stack#
CLS



' Define data type constants that may or may not be used
CONST Zero = .001
CONST IsActive = "Y"
CONST IsNotActive = "N"
CONST MaxSetSize = 700
CONST MaxTreeSize = 700
CONST MaxWorldSize = 700
CONST NULL = 0
CONST TRUE = "Y"
CONST False = "N"
CONST PartiallyVisible = "M"

' Define node types for sets, trees, etc
TYPE SetOfLinesType
        STartX AS SINGLE
        StartY AS SINGLE
        EndX AS SINGLE
        EndY AS SINGLE
        StartT AS DOUBLE
        EndT AS DOUBLE
        StartTop AS SINGLE
        StartBot AS SINGLE
        EndTop AS SINGLE
        EndBot AS SINGLE
        Col AS INTEGER
        ShadeCol AS INTEGER
        Status AS STRING * 1
END TYPE
TYPE VerticeType
        STartX AS SINGLE
        StartY AS SINGLE
        EndX AS SINGLE
        EndY AS SINGLE
        StartT AS SINGLE
        EndT AS SINGLE
        StartTop AS SINGLE
        StartBot AS SINGLE
        EndTop AS SINGLE
        EndBot AS SINGLE
        Col AS INTEGER
        ShadeCol AS INTEGER
        IsVisible AS STRING * 1
END TYPE
TYPE NodeType
        VerticePtr AS INTEGER
        FrontTree AS INTEGER
        BackTree AS INTEGER
        Status AS STRING * 1
END TYPE
TYPE FontStatusType
        Col AS INTEGER
        BackCol AS INTEGER
        Style AS INTEGER
        center AS INTEGER
        XScale AS INTEGER
        YScale AS INTEGER
END TYPE

DIM SHARED Set(1 TO MaxSetSize)  AS SetOfLinesType
DIM SHARED World(0 TO MaxWorldSize) AS VerticeType, WorldSize AS INTEGER
DIM SHARED BSP(1 TO MaxTreeSize) AS NodeType
DIM SHARED player.X AS SINGLE, player.y AS SINGLE
DIM SHARED LCol%, ColInc%, lb%, a, B, Hit
DIM SHARED px1, px2, Py1, Py2, text$
DIM SHARED FileSize&, LineColor%
DIM SHARED GriDStat%, GridSize%, MenuStat%, redrawstat%
GridSize% = 5: GriDStat% = 1: LineColor% = 1
DIM SHARED OutFile$, CurSTop%, CurSBot%, CurETop%, CurEBot%
CurSTop% = 100: CurSBot% = -100: CurETop% = 100: CurEBot% = -100
DIM SHARED SetHigh%, HighLine%, InitStat%
DIM SHARED mouse$: mouse$ = SPACE$(57)
DIM SHARED BTable(0 TO 7) AS INTEGER
DIM SHARED Font(32 TO 127, 0 TO 6) AS INTEGER, FontInfo AS FontStatusType
DIM SHARED scren%(32001), Box%(451), StartTime!, CurTime!
DIM SHARED wow#, wowstate%

wowstate% = 0
StartTime! = TIMER: CurTime! = TIMER

FOR y% = 0 TO 7
        BTable(y%) = 2 ^ y%
NEXT



RANDOMIZE TIMER
FOR i% = 1 TO 57:  READ a$:  H$ = CHR$(VAL("&H" + a$))
MID$(mouse$, i%, 1) = H$: NEXT i%
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00
RESTORE
ms% = Init%
IF NOT ms% THEN
  SCREEN 0
  WIDTH 80
  CLS
  PRINT "Mouse not found, woops."
END
END IF

CALL SetInit(Set())
CLS
SCREEN 13
CALL FontInit
TitleScreen
CALL PalDefine


Range 0, 0, 638, 199

GriDStat% = 0
Grid
GET (0, 0)-(319, 199), scren%
LINE (0, 0)-(319, 199), 31, B
DrawMenu
CALL ConsoleAdd("Welcome to our world creator!")
redrawstat% = 0
Show


BigLoop:

Status lb%, Rb%, x%, y%
ox% = x%
oy% = y%
SetHigh% = -1
InitStat% = 0
HighLine% = -1
COLOR 31
DO
        ' So unneccesary, it makes me cringe
        IF wowstate% = 0 THEN
                wow# = TIMER + .01
                CALL PalShade(96 + CurLow%): CurLow% = (CurLow% + 1) MOD 32
                wowstate% = 1
        ELSE
                IF TIMER >= wow# THEN wowstate% = 0
        END IF
       
       
        Status lb%, Rb%, x%, y%
        a = x% / 2
        B = y%
       
        CheckForMenu INT(a), INT(B)

        IF x% <> ox% OR y% <> oy% THEN
                Moved% = 1
        END IF
      
        DoHighlighting SetHigh%, HighLine%, InitStat%
       
        ' Right click while highlighting a line -> remove it
        IF Rb% = -1 AND HighLine% <> -1 THEN
                ' cancel highlighting stuff
                RemLine% = HighLine%
                TurnOffHighlighting
               
                ' Remove line
                SetRemove RemLine%
        END IF
        

        ' Mouse movement, update highlight stuff
        IF Moved% = 1 THEN
                ' Check for line being highlighted
                SetHigh% = CheckForLine%(x% / 2, y%)
               
               
                ' If a line is highlighted then
                IF SetHigh% <> -1 THEN
                       
                        ' If diff line was highlighted then
                        IF HighLine% <> -1 AND HighLine% <> SetHigh% THEN
                                ' "Turn off" old line
                                DoHighlighting -1, HighLine%, 1
                                InitStat% = 0
                        END IF

                        ' a) Save highlighted line
                        HighLine% = SetHigh%
                       
                        ' b) Set flag for highlight code
                        IF InitStat% <> 1 THEN InitStat% = 0
                END IF
       
                Moved% = 0: ox% = x%: oy% = y%
        END IF
        
        CALL ParseInput
     
' Mouse Input code
IF lb% = -1 THEN
        IF B > 25 THEN
                DoDrawLine
        ELSE
                ParseMInput INT(a), INT(B)
        END IF
END IF

Show
LOOP


errormsg:
CLS
SCREEN 0
WIDTH 80
PRINT "An error has occured, sorry."
PRINT "Error code: "; ERR
SYSTEM

REM $STATIC
SUB BackGround

a = 160: B = 0
FOR i = 1 TO 33
LINE (a, 0)-(0, B), i / 2 + 100: a = a - 5: B = B + 5
NEXT
a = 160: B = 0: FOR i = 1 TO 33
LINE (a, 0)-(319, B), i / 2 + 100: a = a + 5: B = B + 5:
NEXT
a = 160: B = 199
FOR i = 1 TO 33
LINE (a, 199)-(0, B), i / 2 + 100: a = a - 5: B = B - 5
NEXT
a = 160: B = 199
FOR i = 1 TO 33
LINE (a, 199)-(319, B), i / 2 + 100: a = a + 5: B = B - 5
NEXT
LINE (0, 0)-(319, 199), 31, B
END SUB

SUB BSPLoad (f$)
        ' Load a BSP file
        OPEN f$ FOR BINARY AS #1
                Valid$ = SPACE$(5)
                GET #1, , Valid$
                GET #1, , Ver!
                GET #1, , WorldSize
                GET #1, , player.X
                GET #1, , player.y
                GET #1, , ang%
               
               
                GET #1, , UpTime!: r$ = INPUT$(46, #1)
                IF INT(UpTime!) <> 0 THEN CurTime! = StartTime! - UpTime!
                
            
                FOR x% = 1 TO WorldSize
                        GET #1, , BSP(x%).VerticePtr
                        GET #1, , BSP(x%).FrontTree
                        GET #1, , BSP(x%).BackTree
                NEXT

                FOR x% = 1 TO WorldSize
                        GET #1, , sx!
                        GET #1, , sy!
                        GET #1, , ex!
                        GET #1, , ey!
                        GET #1, , Start!
                        GET #1, , EndT!
                        GET #1, , top0!
                        GET #1, , bot0!
                        GET #1, , top1!
                        GET #1, , bot1!
                        st# = StartT!
                        et# = EndT!
                        GET #1, , Col%
                        GET #1, , scol%
                        CALL InsertLine(Set(), sx!, sy!, ex!, ey!, st#, et#, top0!, bot0!, top1!, bot1!, Col%, scol%)
                        
                NEXT

        CLOSE #1
WorldSize = 0
CALL SetShakeDown(Set())
END SUB

SUB BSPWrite (f$)
        ' Write the BSP tree to disk
        OPEN f$ FOR BINARY AS #1
                IF LOF(1) > 1 THEN
                        ' if file exists clear it out
                        CLOSE #1
                        KILL f$
                        OPEN f$ FOR BINARY AS #1
                END IF
                Valid$ = "MKBSP"
                PUT #1, , Valid$
                Version! = .1
                PUT #1, , Version!
                PUT #1, , WorldSize
                PUT #1, , player.X
                PUT #1, , player.y
                ang% = 0
                PUT #1, , ang%
                reserved$ = SPACE$(46)
                tt! = TIMER - CurTime!
                PUT #1, , tt!
                PUT #1, , reserved$

                FOR x% = 1 TO WorldSize
                        PUT #1, , BSP(x%).VerticePtr
                        PUT #1, , BSP(x%).FrontTree
                        PUT #1, , BSP(x%).BackTree
                NEXT
                FOR x% = 0 TO WorldSize - 1
                        PUT #1, , World(x%).STartX
                        PUT #1, , World(x%).StartY
                        PUT #1, , World(x%).EndX
                        PUT #1, , World(x%).EndY
                        PUT #1, , World(x%).StartT
                        PUT #1, , World(x%).EndT
                        PUT #1, , World(x%).StartTop
                        PUT #1, , World(x%).StartBot
                        PUT #1, , World(x%).EndTop
                        PUT #1, , World(x%).EndBot
                        PUT #1, , World(x%).Col
                        PUT #1, , World(x%).ShadeCol
                NEXT
        FileSize& = LOF(1)
        CLOSE #1
END SUB

FUNCTION CheckForLine% (msx%, msy%)
        Answer% = -1
       
        ' Quick exit if mouse is on menu
        IF msy% <= 25 OR msy% >= 190 THEN
                CheckForLine% = Answer%
                EXIT FUNCTION
        END IF

       
        ' Looks through the set "Set" and sees if mouse
        ' pointer is currently on a line in world
        ' If yes, then return the set element number
        Threshold% = 2
        mx% = msx% - 160
        my% = msy% - 100 - 27
        
        FOR x% = 1 TO UBOUND(Set)
                IF Set(x%).Status = IsActive THEN
                        WXdelta% = Set(x%).EndX - Set(x%).STartX
                        WYDelta% = Set(x%).EndY - Set(x%).StartY
                        
                        IF ABS(WXdelta%) > ABS(WYDelta%) THEN
                                XInt# = (mx% - Set(x%).STartX) / WXdelta%
                                IF XInt# <= 1 AND XInt# >= 0 THEN
                                        YCheck% = Set(x%).StartY + XInt# * WYDelta%
                                        IF ABS(YCheck% - my%) <= Threshold% THEN
                                                Answer% = x%
                                                EXIT FOR
                                                Hit% = 1
                                        END IF
                                END IF
                        ELSE
                                YInt# = (my% - Set(x%).StartY) / WYDelta%
                                IF YInt# >= 0 AND YInt# <= 1 THEN
                                        XCheck% = Set(x%).STartX + YInt# * WXdelta%
                                        IF ABS(XCheck% - mx%) <= Threshold% THEN
                                                Answer% = x%
                                                EXIT FOR
                                                Hit% = 1
                                        END IF
                                END IF
                        END IF
                END IF
        NEXT
        CheckForLine% = Answer%
END FUNCTION

SUB CheckForMenu (mx%, my%)
'IF my% <= 26 THEN
        oldstat% = MenuStat%
        MenuStat% = 0
        
        
        ' Save, Load, set
        IF mx% > 2 AND mx% < 65 THEN
                IF my% > 2 AND my% < 10 THEN MenuStat% = 2
                IF my% > 10 AND my% < 17 THEN MenuStat% = 1
                ' 3 = color
                IF my% > 18 AND my% < 25 THEN MenuStat% = 13
        END IF

        ' Help, Quit, color
        IF mx% > 94 AND mx% < 136 THEN
                IF my% > 2 AND my% < 10 THEN MenuStat% = 4
                IF my% > 10 AND my% < 17 THEN MenuStat% = 5
                IF my% > 17 AND my% < 25 THEN MenuStat% = 3
        END IF

        ' Smooth, Grid, Size
        IF mx% > 168 AND mx% < 217 THEN
                IF my% > 2 AND my% < 10 THEN MenuStat% = 6
                'Grid
                IF my% > 10 AND my% < 17 THEN MenuStat% = 7
                'Size
                IF my% > 17 AND my% < 24 THEN MenuStat% = 12
        END IF

        ' Up
        IF mx% > 269 AND mx% < 285 THEN
                IF my% > 2 AND my% < 10 THEN MenuStat% = 8
        END IF
        ' Down
        IF mx% > 260 AND mx% < 292 THEN
                IF my% > 18 AND my% < 25 THEN MenuStat% = 9
        END IF
        IF my% > 10 AND my% < 17 THEN
                IF mx% > 239 AND mx% < 269 THEN MenuStat% = 10
                IF mx% > 279 AND x% < 319 THEN MenuStat% = 11
        END IF

        IF MenuStat% <> oldstat% THEN
                CALL ConsoleClear
                DisplayMsg
        END IF
'END IF

' Nothing highlighted, erase
IF MenuStat% = 0 AND redrawstat% = 1 AND SetHigh% = -1 THEN
        CALL ConsoleClear
        redrawstat% = 0
END IF


END SUB

SUB Colors
Hide
GET (0, 0)-(319, 199), scren%
CLS
PalDefine
BackGround
FontInfo.Style = 2: FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
CALL FontWrite(-1, 15, "Change Wall Color")
FontInfo.YScale = 1: FontInfo.Col = 1
CALL FontWrite(-1, 45, "Please click a color shade")
CALL FontWrite(-1, 55, "for walls.")
FOR x% = 1 TO 7
        LINE ((x% - 1) * 32 + 48, 80)-(x% * 32 + 48, 120), x% * 32, BF
NEXT
Show
DO
        Status lb%, Rb%, mx%, my%
        IF lb% = -1 THEN
                IF my% <= 120 AND my% >= 80 THEN
                        rx% = mx% / 2
                        IF rx% >= 48 AND rx% <= 272 THEN
                                LineColor% = INT((rx% - 48) / 32 + 1)
                                EXIT DO
                        END IF
                END IF
        END IF
LOOP

MRelease
Hide
PUT (0, 0), scren%, PSET
Show
clearbuffer$ = INKEY$
PalMouseColor
END SUB

SUB ConsoleAdd (m$)
        FontInfo.Col = 6: FontInfo.YScale = 1: FontInfo.Style = 1: FontInfo.center = 1
        Hide
        CALL FontWrite(-1, 191, m$)
        Show
        redrawstat% = 1
END SUB

SUB ConsoleClear
        Hide
        LINE (1, 191)-(318, 198), 227, BF
        Show
END SUB

SUB DisplayMsg
SELECT CASE MenuStat%
        CASE 1: CALL ConsoleAdd("Build and save world into a BSP file.")
        CASE 2: CALL ConsoleAdd("Load a BSP world.")
        CASE 3: CALL ConsoleAdd("Select color for new walls.")
        CASE 4: CALL ConsoleAdd("Exit world creator.")
        CASE 5: CALL ConsoleAdd("Display online help.")
        CASE 6: CALL ConsoleAdd("Fill in gaps between close walls.")
        CASE 7: CALL ConsoleAdd("Toggle grid.")
        CASE 8: CALL ConsoleAdd("Move world up.")
        CASE 9: CALL ConsoleAdd("Move world down.")
        CASE 10: CALL ConsoleAdd("Move world to left.")
        CASE 11: CALL ConsoleAdd("Move world to right.")
        CASE 12: CALL ConsoleAdd("Current world contains " + LTRIM$(STR$(SetSize(Set()))) + " lines.")
        CASE 13: CALL ConsoleAdd("Save only the current line endpoints.")
END SELECT
END SUB

SUB DoDrawLine
        IF SetHigh% <> -1 THEN TurnOffHighlighting
        x1 = a
        y1 = B - 27
        Hide
        GET (0, 0)-(319, 199), scren%
        Status lb%, Rb%, x%, y%
        ox% = x%
        oy% = y%
        DO
                Status lb%, Rb%, x%, y%
                a = x% / 2
                B = y% - 27
                IF x% <> ox% OR y% <> oy% THEN ReDraw% = 1
                ox% = x%
                oy% = y%
                
                IF lb% = 0 THEN EXIT DO
              
                ' Only redraw if user moves mouse
                IF ReDraw% = 1 THEN
                        CALL WaitForDisplay
                        Hide
                        PUT (0, 0), scren%, PSET
                        Show
                        GET (0, 0)-(319, 199), scren%
                        VIEW (1, 27)-(318, 189)
                        LINE (x1, y1)-(a, B), LineColor% * 32
                        VIEW (0, 0)-(319, 199)
                END IF
                ReDraw% = 0
        LOOP

        PUT (0, 0), scren%, PSET
        px1 = x1: Py1 = y1
        px2 = x% / 2: Py2 = y% - 27
        
        ' If we actually have a line draw+add it
        IF Py1 <> Py2 OR px2 <> px1 THEN
                VIEW (1, 27)-(318, 189)
                LINE (px1, Py1)-(px2, Py2), LineColor% * 32
                VIEW (0, 0)-(319, 199)
                IF px1 > px2 THEN
                        SWAP px1, px2
                        SWAP Py1, Py2
                END IF
                CsT! = CurSTop%
                CSB! = CurSBot%
                CET! = CurETop%
                CEB! = CurEBot%
                CALL InsertLine(Set(), px1 - 160, Py1 - 100, px2 - 160, Py2 - 100, 0, 1, CsT!, CSB!, CET!, CEB!, INT(LineColor%) * 32 - (RND * 27), INT(LineColor%))
        END IF
        VIEW (0, 0)-(319, 199)
END SUB

SUB DoHighlighting (SetHigh%, HighLine%, InitStat%)
' A line is highlighted
IF SetHigh% <> -1 THEN
        ' Do Set highlight init code
        IF InitStat% = 0 THEN
                Hide
                GET (0, 0)-(319, 42), scren%
                CALL ConsoleClear
                CALL ConsoleAdd("Line #" + LTRIM$(STR$(HighLine%)) + " E - Edit  R Click - Remove")
                LCol% = 12
                ColInc% = 1
                DrawLine SetHigh%, 225
                InitStat% = 1
                Show
        END IF
       
        ' Code for clicking to change a line's height
       
        IF InitStat% = 1 THEN
                ' Here is the line highlighting code
                ' Cycle palette for neat effect
                LCol% = LCol% + ColInc%
                IF LCol% = 12 THEN ColInc% = 1
                IF LCol% = 63 THEN ColInc% = -1
                PalSet 225, LCol% \ 4, LCol%, LCol%
                WaitForDisplay
        END IF
END IF

' A line is not highlighted
IF SetHigh% = -1 THEN
        IF InitStat% = 1 THEN
                ' De init highlight procedure
                Hide
                PUT (0, 0), scren%, PSET
                'Col% = (((Set(HighLine%).Col - 1) \ 32) + 1) * 31
                Col% = Set(HighLine%).ShadeCol * 32
                DrawLine HighLine%, Col%
                Show
                InitStat% = 0
                HighLine% = -1
        END IF
END IF
END SUB

SUB DosMessage
PRINT "Thank you for using our BSP World Maker."
PRINT "BSP Level Creator v0.1c (c) 2001 M \ K Productions"
PRINT "http://members.aol.com/mkwebsite"
END
END SUB

SUB DrawLine (x%, Col%)
VIEW (1, 27)-(318, 189)
LINE (Set(x%).STartX + 160, Set(x%).StartY + 100)-(Set(x%).EndX + 160, Set(x%).EndY + 100), Col%
VIEW (0, 0)-(319, 199)
END SUB

SUB DrawMenu
        LINE (1, 1)-(318, 25), 227, BF
        LINE (1, 190)-(318, 199), 227, BF
       
        'LINE (0, 26)-(319, 26), 31
        'LINE (0, 190)-(319, 199), 31, B
        FancyBorder

        LINE (73, 1)-(73, 24), 228
        LINE (153, 1)-(153, 24), 228
        LINE (231, 1)-(231, 24), 228

        FontInfo.Style = 2
        FontInfo.YScale = 1
        FontInfo.center = 0
        
        FontInfo.Col = 2
        CALL FontWrite(270, 2, "Up")
        CALL FontWrite(239, 10, "Left Right")
       
        CALL FontWrite(262, 18, "Down")
       
        FontInfo.Col = 3
        FontInfo.Col = 6
        CALL FontWrite(2, 2, "Load BSP")
        CALL FontWrite(2, 10, "Save BSP")
        CALL FontWrite(2, 18, "Save Set")
        
       
        'FontInfo.Col = 2
        CALL FontWrite(100, 2, "Quit")
        CALL FontWrite(100, 10, "Help")
        'FontInfo.Col = 6
        CALL FontWrite(96, 18, "Color")
        CALL FontWrite(170, 2, "Smooth")
        CALL FontWrite(178, 10, "Grid")
        CALL FontWrite(178, 18, "Size")
END SUB

SUB EditLine
        FontInfo.BackCol = 38
        Hide
        IF InitStat% <> 0 THEN PUT (0, 0), scren%, PSET
        GET (0, 0)-(172, 71), scren%
        'LINE (13, 13)-(171, 70), 16, BF
        LINE (10, 10)-(169, 68), 38, BF
        LINE (158, 10)-(169, 20), 32, B
        LINE (10, 10)-(169, 68), 32, B
        
        FontInfo.center = 0: FontInfo.Col = 1: FontInfo.Style = 2
        CALL FontWrite(160, 12, "X")

        FontInfo.YScale = 1: FontInfo.Col = 7: FontInfo.Style = 2: FontInfo.center = 0
        l$ = "Line" + STR$(SetHigh%)
        cent% = (160 - (LEN(l$) * 8)) / 2
        

        CALL FontWrite(12 + cent%, 12, l$)
        FontInfo.Col = 1
        CALL FontWrite(12, 21, "Left Top : ")
        CALL FontWrite(12, 30, "Left Bot : ")
        CALL FontWrite(12, 39, "Right Top: ")
        CALL FontWrite(12, 48, "Right Bot: ")
        CALL FontWrite(12, 57, "Color    : ")
        WriteFields
        Show
        MRelease
        DO
                a$ = INKEY$
                Status lb%, Rb%, XMouse%, YMouse%
                mx% = XMouse% / 2
                my% = YMouse% / 2
                IF mx% > 93 AND mx% < 125 THEN
                        IF my% >= 11 AND my% <= 14 THEN
                                IF Fld% <> 0 AND Fld% <> 1 THEN PalSet 96 - Fld%, 63 - Fld%, 63 - Fld%, 0
                                IF Fld% <> 1 THEN PalSet 95, 63, 63, 63: Fld% = 1
                        ELSEIF my% >= 15 AND my% <= 18 THEN
                                IF Fld% <> 0 AND Fld% <> 2 THEN PalSet 96 - Fld%, 63 - Fld%, 63 - Fld%, 0
                                IF Fld% <> 2 THEN PalSet 94, 63, 63, 63: Fld% = 2
                        ELSEIF my% >= 19 AND my% <= 22 THEN
                                IF Fld% <> 0 AND Fld% <> 3 THEN PalSet 96 - Fld%, 63 - Fld%, 63 - Fld%, 0
                                IF Fld% <> 3 THEN PalSet 93, 63, 63, 63: Fld% = 3
                        ELSEIF my% >= 24 AND my% <= 27 THEN
                                IF Fld% <> 0 AND Fld% <> 4 THEN PalSet 96 - Fld%, 63 - Fld%, 63 - Fld%, 0
                                IF Fld% <> 4 THEN PalSet 92, 63, 63, 63: Fld% = 4
                        ELSE
                                IF Fld% <> 0 THEN PalSet 96 - Fld%, 63 - Fld%, 63 - Fld%, 0: Fld% = 0
                        END IF
                ELSE
                        IF Fld% <> 0 THEN PalSet 96 - Fld%, 63 - Fld%, 63 - Fld%, 0: Fld% = 0
                END IF
                
                ' Edit field (height/color)
                IF lb% = -1 THEN
                        MRelease
                       
                        ' check for "X"
                        IF mx% >= 158 AND mx% <= 168 THEN
                                IF my% >= 6 AND my% <= 10 THEN EXIT DO
                        END IF
                        IF Fld% <> 0 THEN
                                PalSet 226, 16, 63, 63
                                Hide
                                LINE (93, 21 + (Fld% - 1) * 9)-(135, 28 + (Fld% - 1) * 9), FontInfo.BackCol, BF
                                N$ = FontInput(93, 21 + (Fld% - 1) * 9, 4, 0)
                                LINE (93, 21 + (Fld% - 1) * 9)-(135, 28 + (Fld% - 1) * 9), FontInfo.BackCol, BF
                                FontInfo.Style = 0
                                IF N$ = "0" OR (VAL(N$) > 0) THEN
                                        SELECT CASE Fld%
                                                CASE 1: Set(HighLine%).StartTop = VAL(N$) - 100
                                                CASE 2: Set(HighLine%).StartBot = VAL(N$) - 100
                                                CASE 3: Set(HighLine%).EndTop = VAL(N$) - 100
                                                CASE 4: Set(HighLine%).EndBot = VAL(N$) - 100
                                        END SELECT
                                END IF
                                WriteFields
                                Show
                        END IF
                       
                        LINE (93, 57)-(135, 65), Set(SetHigh%).ShadeCol * 32, BF
                        IF mx% > 93 AND mx% < 122 THEN
                                IF my% > 28 AND my% < 34 THEN
                                        Hide
                                        Set(HighLine%).ShadeCol = ((Set(HighLine%).ShadeCol) MOD 7) + 1
                                        WriteFields
                                        Show
                                        ColHigh% = 0
                                END IF
                        END IF
                END IF
        WaitForDisplay
        LOOP UNTIL a$ <> ""
        PalDefine
        FontInfo.BackCol = 0
END SUB

SUB FancyBorder
Col% = 4
r! = 24 / 160: c! = 1
FOR x% = 0 TO 159
        PSET (x%, 0), (Col% * 32) - c!
        PSET (x%, 26), (Col% * 32) - c!
        PSET (x%, 190), (Col% * 32) - c!
        PSET (x%, 199), (Col% * 32) - c!
        c! = c! + r!
NEXT
FOR x% = 159 TO 319
        PSET (x%, 0), (Col% * 32) - c!
        PSET (x%, 26), (Col% * 32) - c!
        PSET (x%, 190), (Col% * 32) - c!
        PSET (x%, 199), (Col% * 32) - c!
        c! = c! - r!
NEXT
r! = 19 / 13: c! = 1
FOR y% = 0 TO 12
        PSET (0, y%), (Col% * 32) - c!
        PSET (319, y%), (Col% * 32) - c!
        c! = c! + r!
NEXT
FOR y% = 12 TO 26
        PSET (0, y%), (Col% * 32) - c!
        PSET (319, y%), (Col% * 32) - c!
        c! = c! - r!
NEXT
r! = 52 / 162: c! = 1
FOR y% = 26 TO 107
        PSET (0, y%), (Col% * 32) - c!
        PSET (319, y%), (Col% * 32) - c!
        c! = c! + r!
NEXT
FOR y% = 107 TO 189
        PSET (0, y%), (Col% * 32) - c!
        PSET (319, y%), (Col% * 32) - c!
        c! = c! - r!
NEXT
r! = 10 / 5
FOR y% = 189 TO 194
        PSET (0, y%), (Col% * 32) - c!
        PSET (319, y%), (Col% * 32) - c!
        c! = c! + r!
NEXT
FOR y% = 194 TO 199
        PSET (0, y%), (Col% * 32) - c!
        PSET (319, y%), (Col% * 32) - c!
        c! = c! - r!
NEXT
END SUB

SUB FontInit
        COLOR 16
        FOR Char% = 32 TO 127
                LOCATE 1, 1
                PRINT CHR$(Char%)
                ' Store font
                FOR x% = 0 TO 6
                        ' extra y but makes simpler
                        FOR y% = 0 TO 7
                                IF POINT(x%, y%) <> 0 THEN Font(Char%, x%) = Font(Char%, x%) + BTable(y%)
                        NEXT
                NEXT
                LINE (0, 0)-(6, 7), 0, BF
        NEXT
        FontInfo.XScale = 1
        FontInfo.YScale = 2
        FontInfo.Col = 1
        FontInfo.Style = 1
        FontInfo.center = 1
END SUB

FUNCTION FontInput$ (xoff%, yoff%, MaxLen%, Cycle%)
        ' Input a string
        cxoff% = xoff%
        cyoff% = yoff%
        out$ = ""
        DO
                LINE (cxoff%, cyoff% + 4)-(cxoff% + 8, cyoff% + 7), 96, BF
                a$ = INKEY$
                IF a$ <> "" THEN
                        IF a$ = CHR$(8) THEN
                                IF LEN(out$) > 0 THEN
                                        out$ = LEFT$(out$, LEN(out$) - 1)
                                        LINE (cxoff%, cyoff% + 4)-(cxoff% + 8, cyoff% + 7), FontInfo.BackCol, BF
                                        cxoff% = cxoff% - 8 * FontInfo.XScale
                                        LINE (cxoff%, cyoff%)-(cxoff% + 8 * FontInfo.XScale, cyoff% + 8 * FontInfo.YScale), FontInfo.BackCol, BF
                                END IF
                        ELSEIF a$ = CHR$(27) THEN
                                out$ = ""
                                EXIT DO
                        ELSEIF a$ = CHR$(13) THEN
                                EXIT DO
                        ELSEIF ASC(a$) >= 32 AND ASC(a$) < 128 AND LEN(out$) < MaxLen% THEN
                                out$ = out$ + a$
                                LINE (cxoff%, cyoff% + 4)-(cxoff% + 8, cyoff% + 7), FontInfo.BackCol, BF
                                CALL FontWrite(cxoff%, cyoff%, a$)
                        END IF
                END IF
                IF Cycle% THEN
                        CALL PalShade(64 + Cur%)
                        CALL PalShade(160 + CurLow%)
                        CALL PalShade(32 + CurLow%)
                        CurLow% = (CurLow% + 1) MOD 32
                        Cur% = (Cur% + 4) MOD 32
                        t# = TIMER + .01: DO: LOOP UNTIL TIMER > t#
                END IF
        LOOP
        FontInput$ = out$
END FUNCTION

SUB FontWrite (xoff%, yoff%, text$)
IF FontInfo.Style = 2 THEN
        ShadowCol% = FontInfo.Col * 32 - 26
END IF
IF FontInfo.center = 1 THEN
        xoff% = (320 - (LEN(text$) * 8 * FontInfo.XScale)) / 2
END IF
FOR l% = 1 TO LEN(text$)
        Char% = ASC(MID$(text$, l%, 1))
        FOR x% = 0 TO 6 * FontInfo.XScale
                IF FontInfo.Style > 0 THEN
                        ' shaded letters
                        Col% = (FontInfo.Col - 1) * 32 + 4
                        CInc% = 28 / (8 * FontInfo.YScale)
                ELSE
                        Col% = FontInfo.Col
                        CInc% = 0
                END IF
                FOR y% = 0 TO 7 * FontInfo.YScale
                        IF Font(Char%, x% \ FontInfo.XScale) AND BTable(y% \ FontInfo.YScale) THEN
                                PSET (xoff% + x%, yoff% + y%), Col%
                                IF FontInfo.Style = 2 THEN
                                        PSET (xoff% + x% + 2, yoff% + y% + 1), ShadowCol%
                                END IF
                        END IF
                        Col% = Col% + CInc%
                NEXT
        NEXT
        xoff% = xoff% + 8 * FontInfo.XScale
NEXT
END SUB

SUB GetAnything
DO
        Status lb%, Rb%, XMouse%, YMouse%
LOOP UNTIL INKEY$ <> "" OR lb% = -1
MRelease
END SUB

FUNCTION GetAnythingCycle$
DO
        a$ = INKEY$
        CALL PalShade(160 + CurLow%)
        CALL PalShade(32 + CurLow%)
        CurLow% = (CurLow% + 1) MOD 32
        t# = TIMER + .01: DO: LOOP UNTIL TIMER > t#
        Status lb%, Rb%, XMouse%, YMouse%
        WaitForDisplay
LOOP UNTIL a$ <> "" OR lb% = -1
MRelease
PalDefine
GetAnythingCycle$ = a$
END FUNCTION

SUB GetScreen (File$)

Free = FREEFILE
OPEN File$ FOR INPUT AS #Free

INPUT #1, Statements%

FOR Times% = 1 TO Statements%

   INPUT #Free, State$
   SELECT CASE UCASE$(State$)
       CASE "L": INPUT #1, x1%, y1%, x2%, y2%, Col, Box$
                 SELECT CASE UCASE$(Box$)
                  CASE "B": LINE (x1%, y1%)-(x2%, y2%), Col, B
                  CASE "F": LINE (x1%, y1%)-(x2%, y2%), Col, BF
                  CASE ELSE: LINE (x1%, y1%)-(x2%, y2%), Col
                 END SELECT
       CASE "C": INPUT #1, x1%, y1%, siz, Col, Asp#
                 CIRCLE (x1%, y1%), siz, Col, , , Asp#
       CASE "P": INPUT #1, x1%, y1%, Col
                 PSET (x1%, y1%), Col
       CASE "F": INPUT #1, x1%, y1%, Col, bor
                 PAINT (x1%, y1%), Col, bor
  END SELECT

NEXT
CLOSE #Free

END SUB

SUB Grid
VIEW (1, 27)-(318, 189)
IF GriDStat% = 0 THEN
        FOR x% = 1 TO 320 / GridSize%
                FOR y% = 1 TO (200) / GridSize%
                        LINE ((x% - 1) * GridSize% - 1, (y% - 1) * GridSize% - 1)-(x% * GridSize% - 1, y% * GridSize% - 1), 5, B
                NEXT
        NEXT
END IF
VIEW (0, 0)-(319, 199)
END SUB

SUB Help
                IF SetHigh% <> -1 THEN TurnOffHighlighting
                Hide
                GET (0, 0)-(319, 199), scren%
                PalNull
                LINE (0, 0)-(320, 200), 0, BF
                BackGround
                FontInfo.Style = 1: FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
                CALL FontWrite(-1, 15, "Quick Key Reference")
                FontInfo.Col = 92: FontInfo.Style = 0: FontInfo.center = 0: FontInfo.YScale = 1:
                CALL FontWrite(90, 40, "L")
                CALL FontWrite(90, 49, "S")
                CALL FontWrite(90, 58, "C")
                CALL FontWrite(90, 67, "Q")
                CALL FontWrite(90, 76, "G")
                CALL FontWrite(82, 85, "+ -")
                FontInfo.Col = 1: FontInfo.Style = 2
                CALL FontWrite(105, 40, ": Load BSP Level")
                CALL FontWrite(105, 49, ": Save BSP Level")
                CALL FontWrite(105, 58, ": Select Wall Color")
                CALL FontWrite(105, 67, ": Quit Program")
                CALL FontWrite(105, 76, ": Toggle grid")
                CALL FontWrite(105, 85, ": Change Grid Size")
                FontInfo.center = 1: FontInfo.Col = 5
                CALL FontWrite(-1, 110, "Click and drag with mouse to draw")
                CALL FontWrite(-1, 119, "lines.  Right click a highlighted line")
                CALL FontWrite(-1, 128, "line to remove it from the world.")
                FontInfo.Col = 6: FontInfo.Style = 1
                CALL FontWrite(-1, 157, "page 1 of 4")
                CALL FontWrite(-1, 166, "[hit any key]")
                Show
                PalDefine
                t$ = GetAnythingCycle
                Hide
                LINE (0, 0)-(319, 199), 0, BF
                BackGround
                FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
                CALL FontWrite(-1, 15, "Editing Walls")
                FontInfo.Col = 1: FontInfo.YScale = 1: FontInfo.Style = 2
                CALL FontWrite(-1, 40, "Various properties of a wall can be")
                CALL FontWrite(-1, 49, "edited by pressing E when the desired")
                CALL FontWrite(-1, 58, "line is highlighted.  This will bring")
                CALL FontWrite(-1, 67, "up a box with the line's properties")
                CALL FontWrite(-1, 76, "which you can individually edit by")
                CALL FontWrite(-1, 85, "clicking. Heights can range from")
                CALL FontWrite(-1, 94, "0 to 9999.")
                FontInfo.Col = 5
                CALL FontWrite(-1, 112, "If you want to change a lot of lines")
                CALL FontWrite(-1, 121, "to the same height, you can copy a")
                CALL FontWrite(-1, 130, "line's height values by pressing O when")
                CALL FontWrite(-1, 139, "it is highlighted, and paste those")
                CALL FontWrite(-1, 148, "values onto other lines by pressing P.")
                FontInfo.Col = 6: FontInfo.Style = 1
                CALL FontWrite(-1, 166, "page 2 of 4")
                CALL FontWrite(-1, 175, "[hit any key]")
                Show
                t$ = GetAnythingCycle
                Hide
                LINE (0, 0)-(319, 199), 0, BF
                BackGround
                FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
                CALL FontWrite(-1, 15, "Troubleshooting")
                FontInfo.Col = 1: FontInfo.YScale = 1: FontInfo.Style = 2
                CALL FontWrite(-1, 40, "Building BSP trees is a recursive")
                CALL FontWrite(-1, 49, "process and may require a lot of")
                CALL FontWrite(-1, 58, "stack space. The stack size can")
                CALL FontWrite(-1, 67, "be set as a command line parameter")
                CALL FontWrite(-1, 76, "but the default amount (25000) should")
                CALL FontWrite(-1, 85, "be plenty. Larger levels can")
                CALL FontWrite(-1, 94, "require a moderate amount of memory.")
                CALL FontWrite(-1, 103, "Running the EXE may give you an extra")
                CALL FontWrite(-1, 112, "200k or so, and is recommended.")
                FontInfo.Col = 6: FontInfo.Style = 1
                CALL FontWrite(-1, 157, "page 3 of 4")
                CALL FontWrite(-1, 166, "[hit any key]")
                FontInfo.center = 0: FontInfo.Col = 1
                CALL FontWrite(50, 130, "Free Stack Space :")
                CALL FontWrite(50, 139, "Free Memory      :")
                FontInfo.Col = 5
                CALL FontWrite(200, 130, STR$(FRE(-2)))
                CALL FontWrite(200, 139, STR$(FRE(-1)))
                Show
                t$ = GetAnythingCycle
                PalNull
                Hide
                LINE (0, 0)-(319, 199), 0, BF
                BackGround
                FontInfo.Style = 1: FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
                CALL FontWrite(-1, 15, "Program Information")
                FontInfo.Style = 2: FontInfo.center = 1: FontInfo.YScale = 1: FontInfo.Col = 1
                CALL FontWrite(-1, 50, "Molnar \ Kucalaba Productions'")
                CALL FontWrite(-1, 59, "BSP Level Editor v0.1c")
                FontInfo.Col = 7
                CALL FontWrite(-1, 77, "Last Updated: 8-29-01")
                FontInfo.Col = 1
                CALL FontWrite(-1, 95, "We can be found online at")
                FontInfo.Col = 5
                CALL FontWrite(1, 104, "http://members.aol.com/mkwebsite")
                FontInfo.Col = 1
                CALL FontWrite(1, 122, "If you create any good levels please")
                CALL FontWrite(1, 131, "contact us.")
                FontInfo.Col = 6: FontInfo.Style = 1
                CALL FontWrite(-1, 157, "page 4 of 4")
                CALL FontWrite(-1, 166, "[hit any key]")
                Show
                PalDefine
                t$ = GetAnythingCycle
                Hide
                PUT (0, 0), scren%, PSET
                Show
END SUB

DEFINT A-Z
SUB Hide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

DEFLNG A-Z
FUNCTION Init%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  Init% = ax%
END FUNCTION

DEFSNG A-Z
SUB InsertLine (Set() AS SetOfLinesType, xo!, yo!, xe!, ye!, ts#, te#, top0!, bot0!, top1!, bot1!, Col%, ShadeCol%)
      
        ' Takes input points (Xo%,Yo%)-(Xe%,Ye%) and translates into
        ' parametric line

        ' Don't add points, must be lines
        IF xe! <> xo! OR ye! <> yo! THEN
        'IF ABS(Xe! - xo!) + ABS(ye! - yo!) <> 0 THEN
                NextFree% = SetNextItem(Set())
                Set(NextFree%).STartX = xo!
                Set(NextFree%).StartY = yo!
                Set(NextFree%).EndX = xe!
                Set(NextFree%).EndY = ye!
                Set(NextFree%).StartT = ts#
                Set(NextFree%).EndT = te#
                Set(NextFree%).StartTop = top0!
                Set(NextFree%).StartBot = bot0!
                Set(NextFree%).EndTop = top1!
                Set(NextFree%).EndBot = bot1!
                Set(NextFree%).Col = Col%
                Set(NextFree%).ShadeCol = ShadeCol%
                Set(NextFree%).Status = IsActive
        END IF
END SUB

DEFLNG A-Z
SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(mouse$)
  mouse% = SADD(mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, mouse%)
END SUB

SUB Mput (x%, y%)
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

DEFSNG A-Z
SUB MRelease
        DO
                Status lb%, Rb%, x%, y%
        LOOP UNTIL lb% = 0
END SUB

SUB PalDefine
        ' Initialize Palette
        ' low color = low intensity, high color = high intensity
      
        ' Shades 1-16 (Shade Color 1) is white
        Start% = 0
        FOR x% = 1 TO 32
                CALL PalSet(x%, Start%, Start%, Start%)
                Start% = Start% + 2
        NEXT
        ' make mouse white, nobody will notice
        PalSet 15, 63, 63, 63
        ' Shades 33-64 (Shade Color 2) is red
        Start% = 0
        FOR x% = 33 TO 64
                CALL PalSet(x%, Start%, 0, 0)
                Start% = Start% + 2
        NEXT
        ' Shades 65-96 (Shade Color 3) is green
        Start% = 0
        FOR x% = 65 TO 96
                CALL PalSet(x%, Start%, Start%, 0)
                Start% = Start% + 2
        NEXT
        ' Shades 97-128 (Shade Color 4) is blue
        Start% = 0
        FOR x% = 97 TO 128
                CALL PalSet(x%, 0, 0, Start%)
                Start% = Start% + 2
        NEXT
        ' Shades 129-160 (Shade Color 5) is green
        Start% = 0
        FOR x% = 129 TO 160
                CALL PalSet(x%, 0, Start%, 0)
                Start% = Start% + 2
        NEXT
        ' Shades 161-192 (Shade Color 6) is purple
        Start% = 0
        FOR x% = 161 TO 192
                CALL PalSet(x%, Start%, 0, Start%)
                Start% = Start% + 2
        NEXT
        ' Shades 193-224 (Shade Color 7) is orange
        Start% = 0
        FOR x% = 193 TO 224
                CALL PalSet(x%, Start%, Start% / 2, Start% / 12)
                Start% = Start% + 2
        NEXT
        ' Shades 225-255 (Shade Color 8) are reserved for other uses
        PalMouseColor
        PalSet 226, 13, 63, 63
        PalSet 227, 0, 0, 8
        PalSet 228, 0, 0, 16
END SUB

SUB PalMouseColor
SELECT CASE LineColor%
        CASE 1: PalSet 15, 63, 63, 63
        CASE 2: PalSet 15, 63, 0, 0
        CASE 3: PalSet 15, 63, 63, 0
        CASE 4: PalSet 15, 0, 0, 63
        CASE 5: PalSet 15, 0, 63, 0
        CASE 6: PalSet 15, 63, 0, 63
        CASE 7: PalSet 15, 63, 63 / 2, 63 / 12
END SELECT
END SUB

SUB PalNull
FOR x% = 1 TO 255
         PalSet x%, 0, 0, 0
NEXT
END SUB

SUB PalSet (at%, r%, g%, B%)
OUT &H3C8, at%
OUT &H3C9, r%: OUT &H3C9, g%: OUT &H3C9, B%
END SUB

SUB PalShade (Offset%)


        c% = ((Offset%) \ 32)
        Inc% = 2
        Start% = 31
        FOR i% = 0 TO 31
                ColAtt% = ((Offset% + i%) MOD 32 + 1) + c% * 32
                IF ColAtt% = 128 THEN ColAtt% = 127
                IF Start% = 64 THEN Start% = 63
                SELECT CASE c% + 1
                        CASE 1: PalSet ColAtt%, Start%, Start%, Start%
                        CASE 2: PalSet ColAtt%, Start%, 0, 0
                        CASE 3: PalSet ColAtt%, Start%, Start%, 0
                        CASE 4: PalSet ColAtt%, 0, 0, Start%
                        CASE 5: PalSet ColAtt%, 0, Start%, 0
                        CASE 6: PalSet ColAtt%, Start%, 0, Start%
                        CASE 7: PalSet ColAtt%, Start%, Start% / 2, Start% / 12
                END SELECT
                Start% = Start% + Inc%
                IF i% = 15 THEN Inc% = -2
        NEXT

END SUB

SUB ParseInput
 aa$ = INKEY$

 SELECT CASE UCASE$(aa$)
   CASE "O":    ' Copy current lines heights
                IF SetHigh% <> -1 THEN
                        CurSTop% = Set(HighLine%).StartTop
                        CurSBot% = Set(HighLine%).StartBot
                        CurETop% = Set(HighLine%).EndTop
                        CurEBot% = Set(HighLine%).EndBot
                        CALL ConsoleClear
                        CALL ConsoleAdd("Copied wall heights to clipboard.")
                END IF
   CASE "P":
                ' Paste current line heights over highlighted line heights
                IF SetHigh% <> -1 THEN
                        Set(HighLine%).StartTop = CurSTop%
                        Set(HighLine%).StartBot = CurSBot%
                        Set(HighLine%).EndTop = CurETop%
                        Set(HighLine%).EndBot = CurEBot%
                        CALL ConsoleClear
                        CALL ConsoleAdd("Pasted wall heights onto wall.")
                END IF
   CASE "E":
                IF SetHigh% <> -1 THEN
                        CALL EditLine
                        PUT (0, 0), scren%, PSET
                        ColInc% = -34.54
                        TurnOffHighlighting
                END IF
   CASE "G": CALL PgmGrid
   CASE "+":
               IF SetHigh% <> -1 THEN TurnOffHighlighting
               IF GridSize% < 60 THEN GridSize% = GridSize% + 2
               Hide
               LINE (1, 38)-(318, 198), 0, BF
               Grid
               CALL SetDraw(Set(), 1)
               Show

   CASE "-":
               IF SetHigh% <> -1 THEN TurnOffHighlighting
               IF GridSize% >= 4 THEN GridSize% = GridSize% - 2
               Hide
               LINE (1, 38)-(318, 198), 0, BF
               Grid
               CALL SetDraw(Set(), 1)
               Show
   CASE "Q": CALL PgmQuit
          
   CASE CHR$(27): Help

   CASE "S": CALL PgmSave
   CASE "C": Colors: EXIT SUB
   CASE "L": CALL PgmLoad
 END SELECT

END SUB

SUB ParseMInput (mx%, my%)
IF MenuStat% > 1 AND MenuStat% <= 7 THEN MRelease
SELECT CASE MenuStat%
        CASE 1: CALL PgmSave
        CASE 2: CALL PgmLoad
        CASE 3: CALL Colors
        CASE 4: CALL PgmQuit
        CASE 5: CALL Help
        CASE 6: CALL PgmSmooth
        CASE 7: CALL PgmGrid
        CASE 8: CALL SetShift(0, -5)
        CASE 9: CALL SetShift(0, 5)
        CASE 10: CALL SetShift(-5, 0)
        CASE 11: CALL SetShift(5, 0)
        CASE 13: CALL PgmSetSave
END SELECT
END SUB

SUB PgmGrid
                IF SetHigh% <> -1 THEN TurnOffHighlighting
                Hide
                LINE (1, 27)-(318, 189), 0, BF
                GriDStat% = (GriDStat% + 1) MOD 2
                Grid
                CALL SetDraw(Set(), 1)
                Show
END SUB

SUB PgmLoad
                IF SetHigh% <> -1 THEN TurnOffHighlighting
                Hide
                GET (0, 0)-(319, 199), scren%
                                
                COLOR 31
                LINE (0, 0)-(319, 199), 0, BF
                PalDefine
                BackGround
                FontInfo.Style = 1: FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
                CALL FontWrite(-1, 15, "Load BSP File")
                FontInfo.Style = 2: FontInfo.YScale = 1: FontInfo.Col = 1
                CALL FontWrite(-1, 80, "BSP File to load:")
                FontInfo.Col = 6: FontInfo.Style = 1
                CALL FontWrite(-1, 110, "[Hit escape to cancel]")
                FontInfo.center = 0
                FontInfo.Col = 5
                f$ = FontInput(10, 95, 400, 1)
              
           
                IF f$ <> "" THEN
                        OPEN f$ FOR BINARY AS #1
                                IF LOF(1) < 1 THEN
                                        CLOSE #1
                                        KILL f$
                                        FontInfo.Col = 3: FontInfo.center = 1
                                        CALL FontWrite(-1, 125, "Error: File does not exist")
                                        DO: LOOP UNTIL INKEY$ <> ""
                                        Hide
                                        PUT (0, 0), scren%, PSET
                                        Show
                                        PalDefine
                                        EXIT SUB
                                END IF
                                a$ = INPUT$(5, #1)
                                IF a$ <> "MKBSP" THEN
                                        CLOSE #1
                                        CALL FontWrite(-1, 125, "Error: Not a valid M \ K BSP file.")
                                        GetAnything
                                        Hide
                                        PUT (0, 0), scren%, PSET
                                        Show
                                        PalDefine
                                        EXIT SUB
                                END IF
                                GET #1, , v!
                                IF v! > .1 THEN
                                        CLOSE #1
                                        CALL FontWrite(-1, 125, "Error: Advanced BSP file type.")
                                        GetAnything
                                        Hide
                                        PUT (0, 0), scren%, PSET
                                        Show
                                        PalDefine
                                        EXIT SUB
                                END IF
                        CLOSE #1
                        ' Erase old set
                        CALL SetInit(Set())
                        CALL TreeInit
                        CALL BSPLoad(f$)
                     
                        ' Put set back together again
                        CALL SetCombine(Set())
                        PUT (0, 0), scren%, PSET
                        LINE (1, 27)-(318, 189), 0, BF
                        Grid
                        PalDefine
                        CALL SetDraw(Set(), 1)
                        GET (0, 0)-(319, 199), scren%
                        Show
                        PalDefine
                        EXIT SUB
                END IF
                PalDefine
                PUT (0, 0), scren%, PSET
                Show
END SUB

SUB PgmQuit
                IF SetHigh% <> -1 THEN TurnOffHighlighting
                Hide
                GET (0, 0)-(319, 199), scren%
                LINE (0, 0)-(319, 199), 0, BF
                PalNull
                BackGround
                FontInfo.Style = 1: FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
                CALL FontWrite(-1, 15, "Exit Program")
                FontInfo.YScale = 1: FontInfo.Col = 1: FontInfo.Style = 2
                CALL FontWrite(-1, 90, "Are you sure you want to quit?")
                CALL FontWrite(-1, 100, "(y/n)")
                PalDefine
                a$ = UCASE$(GetAnythingCycle$)
                IF a$ = "Y" THEN
                        SCREEN 0
                        WIDTH 80
                        DosMessage
                ELSE
                        PUT (0, 0), scren%, PSET
                        Show
                END IF
END SUB

SUB PgmSave
                MRelease
                IF SetHigh% <> -1 THEN TurnOffHighlighting
                FontInfo.Style = 2: FontInfo.Col = 2: FontInfo.YScale = 1: FontInfo.center = 1
                Hide
                CALL ConsoleClear
                CALL ConsoleAdd("Please click the starting point")
                Show
                DO
                        Status lb%, Rb%, XMouse%, YMouse%
                        player.X = (XMouse% / 2) - 160
                        player.y = (YMouse%) - 100 - 37
                LOOP UNTIL lb% = -1
                Hide
                CALL ConsoleClear
                GET (0, 0)-(319, 199), scren%
                LINE (0, 0)-(320, 200), 0, BF
                PalDefine
                BackGround
                FontInfo.Style = 1: FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
                CALL FontWrite(-1, 15, "Save BSP File")
                FontInfo.YScale = 1: FontInfo.Col = 1: FontInfo.Style = 2
                CALL FontWrite(-1, 80, "Please enter filename for BSP Level:")
                FontInfo.Col = 6: FontInfo.Style = 1
                CALL FontWrite(-1, 110, "[Hit escape to cancel]")
                FontInfo.center = 0
                FontInfo.Col = 5
                OutFile$ = FontInput(10, 95, 400, 1)
              
                IF OutFile$ <> "" THEN
                        SCREEN 0
                        WIDTH 80
                        PRINT "BSP Compilation Status"
                        ERASE scren%
                        Stack# = FRE(-2)
                        PRINT "Saving debug lines to DEBUG.DBG....";
                        CALL SetSave("DEBUG.DBG")
                        PRINT "done."
                        PRINT "Free Stack Space: "; Stack#
                        PRINT "Free Memory     : "; FRE(-1)
                        PRINT "Building Tree.........";
                        ' Initialize Tree
                        CALL TreeInit
                        Root% = SetFindBestRoot(Set())
                        CALL TreeBuild(Set(), Root%, 1)
                        PRINT "done.  (Took"; Stack# - FRE(-2); "bytes off stack through recursion.)"
                        PRINT "BSP world contains"; WorldSize; "lines/nodes."
                        PRINT "Writing BSP file......";
                        CALL BSPWrite(OutFile$)
                        PRINT "done."
                        OPEN OutFile$ FOR BINARY AS #1
                        PRINT "Wrote"; LOF(1); "bytes."
                        CLOSE #1
                        PRINT "Erasing DEBUG.DBG file.....";
                        KILL "DEBUG.DBG"
                        PRINT "done."
                ELSE
                        PUT (0, 0), scren%, PSET
                        Grid
                        CALL SetDraw(Set(), 1)
                        Show
                        lb% = 0
                        PalDefine
                        EXIT SUB
                END IF
                PRINT "-------------------------------------------------"
                DosMessage
END SUB

SUB PgmSetSave
                MRelease
                Hide
                IF SetHigh% <> -1 THEN TurnOffHighlighting
                FontInfo.Style = 2: FontInfo.Col = 2: FontInfo.YScale = 1: FontInfo.center = 1
                GET (0, 0)-(319, 199), scren%
                LINE (0, 0)-(320, 200), 0, BF
                PalDefine
                BackGround
                FontInfo.Style = 1: FontInfo.YScale = 2: FontInfo.Col = 2: FontInfo.center = 1
                CALL FontWrite(-1, 15, "Save World Data")
                FontInfo.YScale = 1: FontInfo.Col = 1: FontInfo.Style = 2
                CALL FontWrite(-1, 80, "Please enter filename for Set data:")
                FontInfo.Col = 6: FontInfo.Style = 1
                CALL FontWrite(-1, 110, "[Hit escape to cancel]")
                FontInfo.center = 0
                FontInfo.Col = 5
                OutFile$ = FontInput(10, 95, 400, 1)
             
                IF OutFile$ <> "" THEN
                        SCREEN 0
                        WIDTH 80
                        PRINT "Writing line vertices...";
                        CALL SetSave(OutFile$)
                        PRINT "done."
                ELSE
                        PUT (0, 0), scren%, PSET
                        Grid
                        CALL SetDraw(Set(), 1)
                        Show
                        lb% = 0
                        PalDefine
                        EXIT SUB
                END IF
                PRINT "-------------------------------------------------"
                DosMessage
END SUB

SUB PgmSmooth
        Hide
        CALL SetDraw(Set(), 0)
        Grid
        CALL ConsoleClear
        CALL ConsoleAdd("Smoothing out set")
        CALL SetSmoothOut(Set())
        CALL SetShakeDown(Set())
        CALL SetDraw(Set(), 1)
        CALL ConsoleClear
END SUB

DEFLNG A-Z
SUB Range (x1%, y1%, x2%, y2%)
  ax% = 7
  cx% = x1%
  dx% = x2%
MouseDriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = y1%
  dx% = y2%
  MouseDriver ax%, 0, cx%, dx%
END SUB

DEFSNG A-Z
SUB SetCombine (Set() AS SetOfLinesType)
' How its done:
' 1) find matching slope
' 2) find matching vertice point
' 3) Combine lines and disable one of them

' WALL HEIGHT CHANGES
' split walls will always have the same wall height, so a simple
' compare should suffice
'

Threshold! = .01

DO

        Combs% = 0
        FOR x% = 1 TO UBOUND(Set)
                IF Set(x%).Status = IsActive THEN
                        ' Calculate slope of line X
                        XSlope# = Slope#(x%)
                        ' Look for matches across set
                        XDelta% = Set(x%).EndX - Set(x%).STartX
                        YDelta% = Set(x%).EndY - Set(x%).StartY
                        IF XDelta% <> 0 THEN
                                XTopSlope! = (Set(x%).EndTop - Set(x%).StartTop) / XDelta%
                                XBotSlope! = (Set(x%).EndBot - Set(x%).StartBot) / XDelta%
                        ELSE
                                XTopSlope! = (Set(x%).EndTop - Set(x%).StartTop) / YDelta%
                                XBotSlope! = (Set(x%).EndBot - Set(x%).StartBot) / YDelta%
                        END IF

                        FOR y% = 1 TO UBOUND(Set)
                                IF Set(y%).Status = IsActive AND x% <> y% THEN
                                        ' Calculate slope of line Y
                                       
                                        YSlope# = Slope#(y%)
                                       
                                        ' Calculate both wall slopes, must
                                        ' be the same for a split line
                                        XDelta% = Set(y%).EndX - Set(y%).STartX
                                        YDelta% = Set(y%).EndY - Set(y%).StartY
                                        IF XDelta% <> 0 THEN
                                                YTopSlope! = (Set(y%).EndTop - Set(y%).StartTop) / XDelta%
                                                YBotSlope! = (Set(y%).EndBot - Set(y%).StartBot) / XDelta%
                                        ELSE
                                                YTopSlope! = (Set(y%).EndTop - Set(y%).StartTop) / YDelta%
                                                YBotSlope! = (Set(y%).EndBot - Set(y%).StartBot) / YDelta%
                                        END IF
                                        
                                        IF (ABS(XTopSlope! - YTopSlope!) <= Threshold!) AND (ABS(XBotSlope! - YBotSlope!) <= Threshold!) THEN
                                        IF ABS(XSlope# - YSlope#) <= Threshold! THEN
                                                IF Set(x%).STartX = Set(y%).STartX THEN
                                                        IF Set(x%).StartY = Set(y%).StartY THEN
                                                                ' They share point so check for
                                                                Set(x%).STartX = Set(x%).EndX
                                                                Set(x%).StartY = Set(x%).EndY
                                                                Set(x%).EndX = Set(y%).EndX
                                                                Set(x%).EndY = Set(y%).EndY
                                                                Set(y%).Status = IsNotActive
                                                                Combs% = Combs% + 1
                                                                EXIT FOR
                                                        END IF
                                                END IF
                                                IF Set(x%).STartX = Set(y%).EndX THEN
                                                        IF Set(x%).StartY = Set(y%).EndY THEN
                                                                 Set(x%).STartX = Set(x%).EndX
                                                                 Set(x%).StartY = Set(x%).EndY
                                                                 Set(x%).EndX = Set(y%).STartX
                                                                 Set(x%).EndY = Set(y%).StartY
                                                                 Set(y%).Status = IsNotActive
                                                                 Combs% = Combs% + 1
                                                                 EXIT FOR
                                                        END IF
                                                END IF
                                                IF Set(x%).EndX = Set(y%).STartX THEN
                                                        IF Set(x%).EndY = Set(y%).StartY THEN
                                                                Set(x%).STartX = Set(x%).STartX ' dumb
                                                                Set(x%).StartY = Set(x%).StartY ' dumb
                                                                Set(x%).EndX = Set(y%).EndX
                                                                Set(x%).EndY = Set(y%).EndY
                                                                Set(y%).Status = IsNotActive
                                                                Combs% = Combs% + 1
                                                                EXIT FOR
                                                        END IF
                                                END IF
                                                IF Set(x%).EndX = Set(y%).EndX THEN
                                                        IF Set(x%).EndY = Set(y%).EndY THEN
                                                                Set(x%).STartX = Set(x%).STartX
                                                                Set(x%).StartY = Set(x%).StartY
                                                                Set(x%).EndX = Set(y%).STartX
                                                                Set(x%).EndY = Set(y%).StartY
                                                                Set(y%).Status = IsNotActive
                                                                Combs% = Combs% + 1
                                                                EXIT FOR
                                                        END IF
                                                END IF
                                        END IF
                                        END IF
                                END IF
                        NEXT
                END IF
        NEXT

LOOP UNTIL Combs% = 0

' Eliminate gaps in set
CALL SetShakeDown(Set())
END SUB

SUB SetDraw (Set() AS SetOfLinesType, Col%)
        ' Draw a set of parametric lines
        VIEW (1, 27)-(318, 189)

        FOR a% = 1 TO UBOUND(Set)
                IF Set(a%).Status = IsActive THEN
                        x1% = Set(a%).STartX + Set(a%).StartT * (Set(a%).EndX - Set(a%).STartX)
                        y1% = Set(a%).StartY + Set(a%).StartT * (Set(a%).EndY - Set(a%).StartY)
                      
                        x2% = Set(a%).STartX + Set(a%).EndT * (Set(a%).EndX - Set(a%).STartX)
                        y2% = Set(a%).StartY + Set(a%).EndT * (Set(a%).EndY - Set(a%).StartY)
              
                        IF Col% <> 0 THEN
                                Col% = Set(a%).ShadeCol * 32
                        END IF
                        LINE (x1% + 160, 100 + y1%)-(160 + x2%, 100 + y2%), Col%
                END IF
        NEXT
        VIEW (0, 0)-(319, 199)
END SUB

FUNCTION SetFindBestRoot% (Set() AS SetOfLinesType)
        ' Returns a pointer to the best item in set to use, which
        ' for now means the item that splits the fewest lines
        Min% = 32000
        FOR x% = 1 TO UBOUND(Set)
                IF Set(x%).Status = IsActive THEN
                        N% = SetNumberOfSplits(Set(), x%)
                        IF N% < Min% THEN
                                Best% = x%
                                Min% = N%
                        END IF
                END IF
        NEXT

        SetFindBestRoot% = Best%
END FUNCTION

SUB SetInit (Set() AS SetOfLinesType)
FOR x% = 1 TO UBOUND(Set)
        Set(x%).Status = IsNotActive
NEXT
END SUB

FUNCTION SetNextItem% (Set() AS SetOfLinesType)

        ' Returns the next free item in the set
        Size% = UBOUND(Set)
        FOR x% = 1 TO Size%
                IF Set(x%).Status <> IsActive THEN EXIT FOR
        NEXT
        Set(x%).Status = IsActive
        SetNextItem% = x%
END FUNCTION

FUNCTION SetNumberOfSplits% (Set() AS SetOfLinesType, RootSet%)
' Counts how many times RootSet% item splits other lines in its set
' (Basically a stripped-down SetSplit)

' Take the root and find its normal vector
nx# = (Set(RootSet%).StartY - Set(RootSet%).EndY)
ny# = -(Set(RootSet%).STartX - Set(RootSet%).EndX)
 
' Loop through the entire source set and partition into front and
' back sets
Size% = UBOUND(Set)
FOR CurLine% = 1 TO Size%
        IF (Set(CurLine%).Status = IsActive) THEN
                ' Now we have to compare this line to the root
                Numer# = nx# * (Set(CurLine%).STartX - Set(RootSet%).STartX)
                Numer# = Numer# + (ny# * (Set(CurLine%).StartY - Set(RootSet%).StartY))
                 
                denom# = (-nx#) * (Set(CurLine%).EndX - Set(CurLine%).STartX)
                denom# = denom# + ((-ny#) * (Set(CurLine%).EndY - Set(CurLine%).StartY))

                ' Now we can make comparions using numer% and denom%
                IF denom# <> 0 THEN
                        ' If are not parallel compute the intersection T point
                        tint# = Numer# / denom#
                        IF tint# > 0 AND tint# < 1 THEN NumSplits% = NumSplits% + 1
                END IF
        END IF
NEXT
SetNumberOfSplits% = NumSplits%
END FUNCTION

SUB SetRemove (x%)
        Hide
        DrawLine x%, 0
        Set(x%).Status = IsNotActive
        CALL SetShakeDown(Set())
        Grid
        CALL SetDraw(Set(), 1)
        Show
END SUB

SUB SetSave (OutFile$)
        OPEN OutFile$ FOR OUTPUT AS #1
                PRINT #1, "This file contains only line endpoints.  No line properties,"
                PRINT #1, "no BSP information, nothing.  Just the line information."
                PRINT #1, "The line data will likely needed to be shifted."
                PRINT #1, "There are " + STR$(SetSize%(Set())) + " lines."
                PRINT #1, (SetSize%(Set()))
                PRINT #1, "Data follows in (x0,y0)-(x1,y1) format:"
                FOR x% = 1 TO UBOUND(Set)
                        IF Set(x%).Status = IsActive THEN
                                WRITE #1, Set(x%).STartX, Set(x%).StartY, Set(x%).EndX, Set(x%).EndY
                        END IF
                NEXT

        CLOSE #1
END SUB

SUB SetShakeDown (Set() AS SetOfLinesType)
' In the process of combining line segments we might leave some
' holes that we don't want in the set.  This fixes those holes
' and also eliminates lines that are actually dots
DO
        changed% = 0
        FOR x% = 1 TO UBOUND(Set) - 1
                WXdelta% = Set(x%).EndX - Set(x%).STartX
                WYDelta% = Set(x%).EndY - Set(x%).StartY
                IF WXdelta% = 0 AND WYDelta% = 0 THEN
                        Set(x%).Status = IsNotActive
                END IF
               
                IF Set(x%).Status = IsNotActive AND Set(x% + 1).Status = IsActive THEN
                        SWAP Set(x%), Set(x% + 1)
                        changed% = 1
                END IF
        NEXT
LOOP UNTIL changed% = 0
END SUB

SUB SetShift (xs%, ys%)
        SoftRelease
        Hide
        CALL SetDraw(Set(), 0)

        ' Shift a set up/down etc
        FOR x% = 1 TO UBOUND(Set)
                IF Set(x%).Status = IsActive THEN
                        Set(x%).STartX = Set(x%).STartX + xs%
                        Set(x%).EndX = Set(x%).EndX + xs%
                        Set(x%).StartY = Set(x%).StartY + ys%
                        Set(x%).EndY = Set(x%).EndY + ys%
                END IF
        NEXT

        ' ReDraw Code
        Grid
        CALL SetDraw(Set(), 1)
        Show
END SUB

FUNCTION SetSize% (Set() AS SetOfLinesType)
        ' Return the size of a given set
        FOR x% = 1 TO UBOUND(Set)
                IF Set(x%).Status = IsActive THEN Size% = Size% + 1
        NEXT
        SetSize% = Size%
END FUNCTION

SUB SetSmoothOut (Set() AS SetOfLinesType)
        ' Smoothes out a set of lines, because when you draw with the mouse
        ' sometimes it is hard to connect walls perfectly without leaving
        ' little gaps.  This takes a relatively long time to run but
        ' since it is only done at the compilation stage who cares.
        ' This routine is to be called before the BSP tree is built
        ' so we don't have to worry about split lines.
       
        ' Define the largest possible distance between two points
        Threshold% = 2
        FOR x% = 1 TO UBOUND(Set)
                ' Compare the Xth line against all other lines
                FOR y% = x% TO UBOUND(Set)
                        IF y% <> x% AND Set(y%).Status = IsActive THEN
                                ' Calc Distance between start vertices
                                Dist! = SQR((Set(x%).STartX - Set(y%).STartX) ^ 2 + (Set(x%).StartY - Set(y%).StartY) ^ 2)
                                IF Dist! < Threshold% AND Dist! > 0 THEN
                                        Set(y%).STartX = Set(x%).STartX
                                        Set(y%).StartY = Set(x%).StartY
                                END IF
                                ' Calc Distance between end vertices
                                Dist! = SQR((Set(x%).EndX - Set(y%).EndX) ^ 2 + (Set(x%).EndY - Set(y%).EndY) ^ 2)
                                IF Dist! < Threshold% AND Dist! > 0 THEN
                                        Set(y%).EndX = Set(x%).EndX
                                        Set(y%).EndY = Set(x%).EndY
                                END IF
                                ' Calc Distance between start+end
                                Dist! = SQR((Set(x%).STartX - Set(y%).EndX) ^ 2 + (Set(x%).StartY - Set(y%).EndY) ^ 2)
                                IF Dist! < Threshold% AND Dist! > 0 THEN
                                        Set(y%).EndX = Set(x%).STartX
                                        Set(y%).EndY = Set(x%).StartY
                                END IF
                                ' Calc Distance between end+start
                                Dist! = SQR((Set(x%).EndX - Set(y%).STartX) ^ 2 + (Set(x%).EndY - Set(y%).StartY) ^ 2)
                                IF Dist! < Threshold% AND Dist! > 0 THEN
                                        Set(y%).STartX = Set(x%).EndX
                                        Set(y%).StartY = Set(x%).EndY
                                END IF
                        END IF
                NEXT
        NEXT
END SUB

SUB SetSplit (Set() AS SetOfLinesType, FrontSet() AS SetOfLinesType, BackSet() AS SetOfLinesType, RootSet%)

nx# = (Set(RootSet%).StartY - Set(RootSet%).EndY)
ny# = -(Set(RootSet%).STartX - Set(RootSet%).EndX)
  

' Loop through the entire source set and partition into front and
' back sets
Size% = UBOUND(Set)
FOR CurLine% = 1 TO Size%

        IF (Set(CurLine%).Status = IsActive) THEN
                ' Now we have to compare this line to the root
                  
                ' Calculate dot product between splitter normal vector and
                ' current line
            
                Numer# = nx# * (Set(CurLine%).STartX - Set(RootSet%).STartX)
                Numer# = Numer# + (ny# * (Set(CurLine%).StartY - Set(RootSet%).StartY))
                   
                denom# = (-nx#) * (Set(CurLine%).EndX - Set(CurLine%).STartX)
                denom# = denom# + ((-ny#) * (Set(CurLine%).EndY - Set(CurLine%).StartY))

compareagain:
                ' Now we can make comparisons using numer% and denom%
                IF ABS(denom#) <= Zero THEN
                        ' If denom is zero then they are parallel so won't intersect
                        IF Numer# > Zero THEN
                                CALL InsertLine(FrontSet(), Set(CurLine%).STartX, Set(CurLine%).StartY, Set(CurLine%).EndX, Set(CurLine%).EndY, Set(CurLine%).StartT, Set(CurLine%).EndT, Set(CurLine%).StartTop, Set(CurLine%).StartBot, Set(CurLine%). _
EndTop, Set(CurLine%).EndBot, Set(CurLine%).Col, Set(CurLine%).ShadeCol)
                        ELSE
                                CALL InsertLine(BackSet(), Set(CurLine%).STartX, Set(CurLine%).StartY, Set(CurLine%).EndX, Set(CurLine%).EndY, Set(CurLine%).StartT, Set(CurLine%).EndT, Set(CurLine%).StartTop, Set(CurLine%).StartBot, Set(CurLine%). _
EndTop, Set(CurLine%).EndBot, Set(CurLine%).Col, Set(CurLine%).ShadeCol)
                        END IF
                ELSE
                        ' If are not parallel compute the intersection T point
                        tint# = ((Numer# / denom#))
                        IF tint# <= 0 OR tint# >= 1 THEN
                                ' In this case the two line do not intersect
                                ' so
                                IF Numer# > Zero THEN
                                        CALL InsertLine(FrontSet(), Set(CurLine%).STartX, Set(CurLine%).StartY, Set(CurLine%).EndX, Set(CurLine%).EndY, Set(CurLine%).StartT, Set(CurLine%).EndT, Set(CurLine%).StartTop, Set(CurLine%).StartBot, Set( _
CurLine%).EndTop, Set(CurLine%).EndBot, Set(CurLine%).Col, Set(CurLine%).ShadeCol)
                                ELSEIF Numer# < -Zero THEN
                                        CALL InsertLine(BackSet(), Set(CurLine%).STartX, Set(CurLine%).StartY, Set(CurLine%).EndX, Set(CurLine%).EndY, Set(CurLine%).StartT, Set(CurLine%).EndT, Set(CurLine%).StartTop, Set(CurLine%).StartBot, Set( _
CurLine%).EndTop, Set(CurLine%).EndBot, Set(CurLine%).Col, Set(CurLine%).ShadeCol)
                                ELSE
                                        Numer# = nx# * (Set(CurLine%).EndX - Set(RootSet%).STartX)
                                        Numer# = Numer# + (ny# * (Set(CurLine%).EndY - Set(RootSet%).StartY))
                                        ' Need to loop through a do all comparisons again
                                        ' quick + easy: GOTO
                                        GOTO compareagain
                                END IF
                        ELSE
                                CEX! = Set(CurLine%).STartX + tint# * (Set(CurLine%).EndX - Set(CurLine%).STartX)
                                CEY! = Set(CurLine%).StartY + tint# * (Set(CurLine%).EndY - Set(CurLine%).StartY)
                                                                   
                                ' Also need ot split heights
                                CT! = Set(CurLine%).StartTop + tint# * (Set(CurLine%).EndTop - Set(CurLine%).StartTop)
                                CB! = Set(CurLine%).StartBot + tint# * (Set(CurLine%).EndBot - Set(CurLine%).StartBot)

                                IF Numer# > Zero THEN
                                        ' First portion of split line is in front of root line
                                        ' Compute the split points
                                        CALL InsertLine(FrontSet(), Set(CurLine%).STartX, Set(CurLine%).StartY, CEX!, CEY!, 0, 1, Set(CurLine%).StartTop, Set(CurLine%).StartBot, CT!, CB!, Set(CurLine%).Col, Set(CurLine%).ShadeCol)
                                        CALL InsertLine(BackSet(), CEX!, CEY!, Set(CurLine%).EndX, Set(CurLine%).EndY, 0, 1, CT!, CB!, Set(CurLine%).EndTop, Set(CurLine%).EndBot, Set(CurLine%).Col, Set(CurLine%).ShadeCol)
                                ELSE
                                        ' First portion of split line is behind root line     
                                        CALL InsertLine(BackSet(), Set(CurLine%).STartX, Set(CurLine%).StartY, CEX!, CEY!, 0, 1, Set(CurLine%).StartTop, Set(CurLine%).StartBot, CT!, CB!, Set(CurLine%).Col, Set(CurLine%).ShadeCol)
                                        CALL InsertLine(FrontSet(), CEX!, CEY!, Set(CurLine%).EndX, Set(CurLine%).EndY, 0, 1, CT!, CB!, Set(CurLine%).EndTop, Set(CurLine%).EndBot, Set(CurLine%).Col, Set(CurLine%).ShadeCol)
                                END IF
                        END IF
                END IF
        END IF
NEXT
END SUB

DEFLNG A-Z
SUB Show
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

DEFSNG A-Z
FUNCTION Slope# (x%)
        ' Returns the slope of line X% in Set
        x0# = Set(x%).STartX
        x1# = Set(x%).EndX
        y0# = Set(x%).StartY
        y1# = Set(x%).EndY
        IF x1# > x0# THEN
                SWAP x1#, x0#
                SWAP y1#, y0#
        END IF
        XDelta# = x1# - x0#
        IF XDelta# <> 0 THEN
                YDelta# = y1# - y0#
                IF YDelta# = 0 THEN S# = 999999 ELSE S# = (YDelta# / XDelta#)
        ELSE
                S# = 0
        END IF
        Slope# = S#
END FUNCTION

SUB SoftRelease
        t! = TIMER
        DO
                Status lb%, Rb%, x%, y%
        LOOP UNTIL lb% = 0 OR TIMER - t! > .0005
END SUB

DEFLNG A-Z
SUB Status (lb%, Rb%, XMouse%, YMouse%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  lb% = ((bx% AND 1) <> 0)
  Rb% = ((bx% AND 2) <> 0)
  XMouse% = cx%
  YMouse% = dx%
END SUB

DEFSNG A-Z
SUB TitleScreen
CLS
SCREEN 13
PalDefine
FontInfo.YScale = 1: FontInfo.Col = 1: FontInfo.center = 1: FontInfo.Style = 2
LINE (0, 0)-(319, 199), 106, BF
LINE (0, 0)-(319, 199), 31, B
CALL FontWrite(-1, 12, "Molnar \ Kucalaba Productions")
CALL FontWrite(-1, 22, "proudly present")
FontInfo.YScale = 4: FontInfo.XScale = 2: FontInfo.Col = 4
CALL FontWrite(-1, 42, "The")
FontInfo.XScale = 5
CALL FontWrite(-1, 122, "Maker")
FontInfo.Col = 2: FontInfo.YScale = 4: FontInfo.XScale = 4: FontInfo.Style = 2
CALL FontWrite(-1, 82, "BSP")
FontInfo.YScale = 1: FontInfo.XScale = 1: FontInfo.Col = 6
CALL FontWrite(-1, 176, "version 0.1c updated 08-29-01")
Show
'a$ = GetAnythingCycle
GetAnything
Hide
LINE (0, 0)-(319, 199), 0, BF
END SUB

SUB TreeBuild (Set() AS SetOfLinesType, RootSet%, RootNode%)
        ' Disable/Remove the root in the set
        Set(RootSet%).Status = IsNotActive
        ' Fill in the line information in BSP tree
        BSP(RootNode%).VerticePtr = WorldAdd%(Set(RootSet%).STartX, Set(RootSet%).StartY, Set(RootSet%).EndX, Set(RootSet%).EndY, Set(RootSet%).StartT, Set(RootSet%).EndT, Set(RootSet%).StartTop, Set(RootSet%).StartBot, Set(RootSet%).EndTop, Set( _
RootSet%).EndBot, Set(RootSet%).Col, Set(RootSet%).ShadeCol)
        BSP(RootNode%).Status = IsActive

        ' Create two new sets for front and back spaces
        MaxSubSpaceSize% = SetSize%(Set())
      
        ' Keep recursing until source set is empty
        IF MaxSubSpaceSize% > 0 THEN
              
                ' Create two new subsets
                DIM BackSet(1 TO MaxSubSpaceSize%) AS SetOfLinesType
                DIM FrontSet(1 TO MaxSubSpaceSize%) AS SetOfLinesType

                ' Now we need to go through each line in the set and decide
                ' if it is in front, behind, or split by the splitter and create
                ' two appropiate sets
                CALL SetSplit(Set(), FrontSet(), BackSet(), RootSet%)
                ERASE Set
                ' Now we have two sets, one containing all lines in front of root
                ' and one containing all lines behind root.

                ' If front set isnt empty than divide it
                IF SetSize%(FrontSet()) > 0 THEN
                        ' Get free node in tree
                        FreeNode% = TreeNextItem%
              
                        ' Link parent node to child
                        BSP(RootNode%).FrontTree = FreeNode%

                        ' Recursively build subtree
                        ' Optimization can be implemented to choose
                        ' a different starting line from the set
                        ' instead of always 1
                      
                        BestRoot% = SetFindBestRoot(FrontSet())
                        'BestRoot% = 1
                        CALL TreeBuild(FrontSet(), BestRoot%, FreeNode%)
                        ERASE FrontSet
                END IF
     
                ' If back set isnt empty than divide it
                IF SetSize%(BackSet()) > 0 THEN
                        ' Get free node in tree
                        FreeNode% = TreeNextItem%
             
                        ' Link parent node to child
                        BSP(RootNode%).BackTree = FreeNode%

                        ' Recursively build subtree
                        BestRoot% = SetFindBestRoot(BackSet())
                        'BestRoot% = 1
                        CALL TreeBuild(BackSet(), BestRoot%, FreeNode%)
                        ERASE BackSet
                END IF

        END IF

END SUB

SUB TreeInit
FOR x% = 1 TO UBOUND(BSP)
        BSP(x%).VerticePtr = NULL
        BSP(x%).FrontTree = NULL
        BSP(x%).BackTree = NULL
        BSP(x%).Status = IsNotActive
NEXT
WorldSize = 0
END SUB

FUNCTION TreeNextItem%
        ' Returns the next free item in the tree
        Size% = UBOUND(BSP)
        FOR x% = 1 TO Size%
                IF BSP(x%).Status <> IsActive THEN EXIT FOR
        NEXT
        BSP(x%).Status = IsActive
TreeNextItem% = x%
END FUNCTION

SUB TurnOffHighlighting
        SetHigh% = -1:  InitStat% = 1
        DoHighlighting SetHigh%, HighLine%, InitStat%
END SUB

SUB WaitForDisplay
' waitdisp
WAIT &H3DA, 8
END SUB

FUNCTION WorldAdd% (x0!, y0!, x1!, y1!, ts#, te#, top0!, bot0!, top1!, bot1!, Col%, ShadeCol%)
        ' Add a parameterized line to the world vertice list
        ' and return a pointer to added line
        World(WorldSize%).STartX = x0!
        World(WorldSize%).StartY = y0!
        World(WorldSize%).EndX = x1!
        World(WorldSize%).EndY = y1!
        World(WorldSize%).StartT = ts#
        World(WorldSize%).EndT = te#
        World(WorldSize%).StartTop = top0!
        World(WorldSize%).StartBot = bot0!
        World(WorldSize%).EndTop = top1!
        World(WorldSize%).EndBot = bot1!
        World(WorldSize%).Col = Col%
        World(WorldSize%).ShadeCol = ShadeCol%
        WorldSize% = WorldSize% + 1
        WorldAdd% = (WorldSize% - 1)
END FUNCTION

SUB WriteFields
        FontInfo.Style = 0
        FontInfo.Col = 95
        CALL FontWrite(85, 21, STR$(Set(SetHigh%).StartTop + 100))
        FontInfo.Col = 94
        CALL FontWrite(85, 30, STR$(Set(SetHigh%).StartBot + 100))
        FontInfo.Col = 93
        CALL FontWrite(85, 39, STR$(Set(SetHigh%).EndTop + 100))
        FontInfo.Col = 92
        CALL FontWrite(85, 48, STR$(Set(SetHigh%).EndBot + 100))
        LINE (93, 57)-(135, 65), Set(SetHigh%).ShadeCol * 32, BF
END SUB

