' -----------------------------
' Rotating polygons that bounce around the
' screen.  This program is pretty much the
' peak of our 2D polygon programs, although
' it does not use scaling in any major way.

' As always, compiling will increase the
' performance of this program greatly.
' However, we've included several polygon
' objects of varying complexity, so there
' is something for everyone.

' Written by M \ K Productions
' http://members.aol.com/mkwebsite/index.html
' -----------------------------


DECLARE SUB LoadObject (C%)
DECLARE SUB SelectObject ()
DECLARE SUB BuildTables ()
DECLARE SUB Setpal ()
DECLARE SUB Delay (X!)
DECLARE SUB Fset (Col%, r%, g%, b%)
DECLARE SUB FillPolygon (Col%)
DECLARE SUB DrawObject ()
DECLARE SUB BuildEdges (Q%)
DECLARE SUB ClearEdges ()


CLS
DEFINT A-Z
RANDOMIZE TIMER
'$DYNAMIC

TYPE PType
        X AS INTEGER
        Y AS INTEGER
END TYPE

DIM SHARED XOrigin, YOrigin, XOrDir, YOrDir
XOrigin = 160: XOrDir = 1
YOrigin = 100: YOrDir = 1

DIM SHARED ColDir%
ColDir% = 1
CONST pi = 3.141592

DIM SHARED PolNumber%
SelectObject


DIM SHARED Polygon(0 TO PolNumber%, 0 TO 2) AS PType
DIM SHARED P(0 TO PolNumber%, 0 TO 2)  AS PType
DIM SHARED Fixed!, Speed%, Mspd%
DIM SHARED SINt(0 TO 360) AS SINGLE, COSt(0 TO 360) AS SINGLE
DIM SHARED Edges%(0 TO 320, 0 TO 1)
DIM SHARED XMin%, XMax%, Trails%

CLS
SCREEN 7

LoadObject PolNumber%
BuildTables


Col% = 1
DO
FOR Angle% = 0 TO 360 STEP Speed%
       
        a$ = INKEY$
        IF a$ <> "" THEN EXIT DO
        PCOPY 3, 2
        SCREEN , , 2, 0
      
        FOR Y% = 0 TO PolNumber%
                FOR X% = 0 TO 2
               
                        lx = P(Y%, X%).X '- XOrigin
                        ly = P(Y%, X%).Y '- YOrigin
     
                        nx = COSt(Angle%) * lx - SINt(Angle%) * ly
                        ny = COSt(Angle%) * ly + SINt(Angle%) * lx
               
                        Polygon(Y%, X%).X = XOrigin + nx * Fixed!
                        Polygon(Y%, X%).Y = YOrigin + ny * Fixed!

                        SELECT CASE Polygon(Y%, X%).X
                                CASE IS > 319: Polygon(Y%, X%).X = 319
                                               XOrDir = -1 * Mspd%
                                CASE IS < 0:   Polygon(Y%, X%).X = 0
                                               XOrDir = 1 * Mspd%
                        END SELECT
                        SELECT CASE Polygon(Y%, X%).Y
                                CASE IS > 199: Polygon(Y%, X%).Y = 199
                                               YOrDir = -1 * Mspd%
                                CASE IS < 0:   Polygon(Y%, X%).Y = 0
                                               YOrDir = 1 * Mspd%
                        END SELECT

                NEXT
        NEXT
       
        FOR X% = 0 TO PolNumber%
                ClearEdges
                BuildEdges X%
                FillPolygon 4
        NEXT
       
        XOrigin = XOrigin + XOrDir * Mspd%
        YOrigin = YOrigin + YOrDir * Mspd%

        PCOPY 2, 0
        SCREEN , , 2, 0


NEXT

LOOP
CLS
SCREEN 0
WIDTH 80
SYSTEM



MKPolygonData:
DATA 14
DATA 60,50,70,50,60,150, 70,50,60,150,70,150, 70,50,70,60,120,110
DATA 70,50,120,100,120,110, 120,100,130,100,120,110, 120,110,130,110,130,100
DATA 130,110,180,50,180,60, 130,110,130,100,180,50, 180,50,190,50,180,150
DATA 180,150,190,150,190,50, 195,100,190,105,190,95, 195,100,235,50,245,50
DATA 190,95,195,100,235,50, 235,150,195,100,190,105, 235,150,245,150,195,100


Triangle:
DATA 0
DATA 160,60,180,140,140,140


Square:
DATA 1
DATA 140,80,180,120,140,120,   140,80,180,80,180,120




Star:
DATA 7
DATA 148,84,172,84,160,60,    172,84,198,88,179,106,  179,106,160,120,184,132
DATA 160,120,141,106,136,132,  141,106,148,84,122,88
DATA 160,120,179,106,141,106,   141,106,179,106,172,84,   172,84,148,84,141,106

REM $STATIC
DEFSNG A-Z
SUB BuildEdges (Q%)


        ' Find the x min and max values
        XMin% = 32767
        XMax% = -32767
        FOR X% = 0 TO 2
                IF Polygon(Q%, X%).X > XMax% THEN XMax% = Polygon(Q%, X%).X
                IF Polygon(Q%, X%).X < XMin% THEN XMin% = Polygon(Q%, X%).X
        NEXT


        ' Build a list of edges
        FOR Node% = 0 TO 2
              
                Pnt1% = Node%                 ' Calculate which two points of
                Pnt2% = (Node% + 1) MOD 3     ' the polygon to trace
              
                ' Sort the two X point values
                IF Polygon(Q%, Pnt1%).X > Polygon(Q%, Pnt2%).X THEN SWAP Pnt1%, Pnt2%
              
                x1% = Polygon(Q%, Pnt1%).X
                x2% = Polygon(Q%, Pnt2%).X
                y1% = Polygon(Q%, Pnt1%).Y
                y2% = Polygon(Q%, Pnt2%).Y
               
                Xdelta% = x2% - x1%
                YDelta% = y2% - y1%

                ' Calculate the Y slope (increment)
                IF Xdelta% <> 0 THEN
                        YSlope! = YDelta% / Xdelta%
                ELSE
                        YSlope! = 0
                END IF
                YStep! = Polygon(Q%, Pnt1%).Y
              
               
                ' Loop from x pos to next x pos, filling in edges with ystep
                FOR X% = x1% TO x2%

                        IF Edges%(X%, 0) = -1 THEN
                                Edges%(X%, 0) = YStep!
                        ELSE
                                IF YStep! > Edges%(X%, 1) THEN
                                        Edges%(X%, 1) = YStep!
                                ELSEIF YStep! < Edges%(X%, 0) THEN
                                        Edges%(X%, 0) = YStep!
                                END IF
                                        IF Edges%(X%, 0) > Edges%(X%, 1) THEN SWAP Edges%(X%, 1), Edges%(X%, 0)
                                
                        END IF
                       
                        YStep! = YStep! + YSlope!
                        
                NEXT


        NEXT


END SUB

DEFINT A-Z
SUB BuildTables
        'create corrected sinus/cos tables
        FOR Angle% = 0 TO 360
                SINt(Angle%) = SIN(Angle% * pi / 180)
                COSt(Angle%) = COS(Angle% * pi / 180)
        NEXT


END SUB

DEFSNG A-Z
SUB ClearEdges
FOR X% = 0 TO 320
        Edges%(X%, 0) = -1
        Edges%(X%, 1) = -1
NEXT
END SUB

DEFINT A-Z
SUB Delay (X!)
C! = TIMER + X!
DO: LOOP UNTIL TIMER >= C!
END SUB

DEFSNG A-Z
SUB DrawObject
FOR X% = 0 TO PolNumber%
        ClearEdges
        BuildEdges X%
        FillPolygon 1
NEXT
END SUB

SUB FillPolygon (Col%)
        FOR X% = XMin% TO XMax%
                LINE (X%, Edges%(X%, 0))-(X%, Edges%(X%, 1)), Col%
        NEXT
END SUB

SUB LoadObject (C%)
FOR X% = 0 TO C%
        READ P(X%, 0).X, P(X%, 0).Y
        READ P(X%, 1).X, P(X%, 1).Y
        READ P(X%, 2).X, P(X%, 2).Y
       
        P(X%, 0).X = P(X%, 0).X - 160
        P(X%, 1).X = P(X%, 1).X - 160
        P(X%, 2).X = P(X%, 2).X - 160

        P(X%, 0).Y = P(X%, 0).Y - 100
        P(X%, 1).Y = P(X%, 1).Y - 100
        P(X%, 2).Y = P(X%, 2).Y - 100
NEXT
END SUB

DEFINT A-Z
SUB SelectObject
CLS
PRINT "Welcome."
PRINT
PRINT "Please select an object :"
PRINT "1) M \ K Logo    (Polygon count : 15)"
PRINT "2) Triangle      (Polygon count : 1)"
PRINT "3) Square        (Polygon count : 2)"
PRINT "4) Star          (Polygon count : 8)"
INPUT X%
SELECT CASE X%
        CASE 1: RESTORE MKPolygonData
        CASE 2: RESTORE Triangle
        CASE 3: RESTORE Square
        CASE 4: RESTORE Star
END SELECT
READ PolNumber%
PRINT
PRINT "Please select a rotation speed"
INPUT Speed%
IF Speed% = 0 THEN Speed% = 5
PRINT
PRINT "Please select a moving speed"
INPUT Mspd%
IF Mspd% = 0 THEN Mspd% = 1
XOrDir = Mspd%
YOrDir = Mspd%
PRINT
PRINT "Please enter a scale factor. (.75)"
INPUT Fixed!
IF Fixed! = 0 THEN Fixed! = .75
END SUB

