' -----------------------------
' Sample usage of these programs.
' Rotating and scaling effect.

' Written by M \ K Productions
' http://members.aol.com/mkwebsite/index.html
' -----------------------------


DECLARE SUB Delay (x!)
DECLARE SUB Fset (Col%, r%, g%, b%)
DECLARE SUB FillPolygon (Col%)
DECLARE SUB DrawObject ()
DECLARE SUB LoadObject ()
DECLARE SUB BuildEdges (Q%)
DECLARE SUB ClearEdges ()


CLS
SCREEN 13
DEFINT A-Z
RANDOMIZE TIMER
'$DYNAMIC

TYPE PType
        x AS INTEGER
        y AS INTEGER
END TYPE

CONST XOrigin = 160
CONST YOrigin = 100
CONST pi = 3.141592
CONST PolNumber% = 14

DIM SHARED Polygon(0 TO PolNumber%, 0 TO 2) AS PType
DIM SHARED P(0 TO PolNumber%, 0 TO 2)  AS PType

DIM SHARED Scale(0 TO 360) AS SINGLE
DIM SINt(0 TO 360) AS SINGLE, COSt(0 TO 360) AS SINGLE
DIM SHARED Edges%(0 TO 320, 0 TO 1)
DIM SHARED XMin%, XMax%

'create corrected sinus/cos tables
FOR Angle% = 0 TO 360
        SINt(Angle%) = SIN(Angle% * pi / 180)
        COSt(Angle%) = COS(Angle% * pi / 180)
NEXT


a! = 0
FOR Angle% = 0 TO 180
        Scale(Angle%) = 1 - SIN(a! * pi / 180)
        a! = a! + .5
NEXT
Ctr% = 0
FOR x% = 180 TO 360
        Scale(x%) = Scale(x% - Ctr%)
        Ctr% = Ctr% + 2
NEXT

LoadObject




o! = 0
FOR x% = 0 TO 36
        Fset x%, INT(o!), 0, 0
        o! = o! + 1.5
NEXT
Col% = 0



FOR Angle% = 180 TO 360 STEP 5

       
        FOR y% = 0 TO PolNumber%
                FOR x% = 0 TO 2
               
                        lx = P(y%, x%).x - 160
                        ly = P(y%, x%).y - 100
     
                        nx = COSt(Angle%) * lx - SINt(Angle%) * ly
                        ny = COSt(Angle%) * ly + SINt(Angle%) * lx
               
                        Polygon(y%, x%).x = 160 + (nx * Scale(Angle%))
                        Polygon(y%, x%).y = 100 + (ny * Scale(Angle%))

                        IF Polygon(y%, x%).x > 319 THEN Polygon(y%, x%).x = 319
                        IF Polygon(y%, x%).x < 0 THEN Polygon(y%, x%).x = 0
               
                        IF Polygon(y%, x%).y > 199 THEN Polygon(y%, x%).y = 199
                        IF Polygon(y%, x%).y < 0 THEN Polygon(y%, x%).y = 0

                NEXT
        NEXT
       
        FOR x% = 0 TO PolNumber%
                ClearEdges
                BuildEdges x%
                FillPolygon Col%
        NEXT
        Col% = Col% + 1
NEXT

FOR x% = 0 TO 35
        Fset x%, 0, 0, 0
        Delay .01
NEXT


LOCATE 2, 5
COLOR 36: PRINT " Molnar \ Kucalaba Productions"
LOCATE 23, 12
COLOR 36: PRINT "Proudly Present"

DO: LOOP UNTIL INKEY$ <> ""


PolygonData:
DATA 60,50,70,50,60,150, 70,50,60,150,70,150, 70,50,70,60,120,110
DATA 70,50,120,100,120,110, 120,100,130,100,120,110, 120,110,130,110,130,100
DATA 130,110,180,50,180,60, 130,110,130,100,180,50, 180,50,190,50,180,150
DATA 180,150,190,150,190,50, 195,100,190,105,190,95, 195,100,235,50,245,50
DATA 190,95,195,100,235,50, 235,150,195,100,190,105, 235,150,245,150,195,100

REM $STATIC
DEFSNG A-Z
SUB BuildEdges (Q%)


        ' Find the x min and max values
        XMin% = 32767
        XMax% = -32767
        FOR x% = 0 TO 2
                IF Polygon(Q%, x%).x > XMax% THEN XMax% = Polygon(Q%, x%).x
                IF Polygon(Q%, x%).x < XMin% THEN XMin% = Polygon(Q%, x%).x
        NEXT


        ' Build a list of edges
        FOR Node% = 0 TO 2
              
                Pnt1% = Node%                 ' Calculate which two points of
                Pnt2% = (Node% + 1) MOD 3     ' the polygon to trace
              
                ' Sort the two X point values
                IF Polygon(Q%, Pnt1%).x > Polygon(Q%, Pnt2%).x THEN SWAP Pnt1%, Pnt2%
              
                x1% = Polygon(Q%, Pnt1%).x
                x2% = Polygon(Q%, Pnt2%).x
                y1% = Polygon(Q%, Pnt1%).y
                y2% = Polygon(Q%, Pnt2%).y
               
                Xdelta% = x2% - x1%
                YDelta% = y2% - y1%

                ' Calculate the Y slope (increment)
                IF Xdelta% <> 0 THEN
                        YSlope! = YDelta% / Xdelta%
                ELSE
                        YSlope! = 0
                END IF
                YStep! = Polygon(Q%, Pnt1%).y
              
               
                ' Loop from x pos to next x pos, filling in edges with ystep
                FOR x% = x1% TO x2%

                        IF Edges%(x%, 0) = -1 THEN
                                Edges%(x%, 0) = YStep!
                        ELSE
                                IF YStep! > Edges%(x%, 1) THEN
                                        Edges%(x%, 1) = YStep!
                                ELSEIF YStep! < Edges%(x%, 0) THEN
                                        Edges%(x%, 0) = YStep!
                                END IF
                                        IF Edges%(x%, 0) > Edges%(x%, 1) THEN SWAP Edges%(x%, 1), Edges%(x%, 0)
                                
                        END IF
                       
                        YStep! = YStep! + YSlope!
                        
                NEXT


        NEXT


END SUB

SUB ClearEdges
FOR x% = 0 TO 320
        Edges%(x%, 0) = -1
        Edges%(x%, 1) = -1
NEXT
END SUB

DEFINT A-Z
SUB Delay (x!)
c! = TIMER + x!
DO: LOOP UNTIL TIMER >= c!
END SUB

DEFSNG A-Z
SUB DrawObject
FOR x% = 0 TO PolNumber%
        ClearEdges
        BuildEdges x%
        FillPolygon 1
NEXT
END SUB

SUB FillPolygon (Col%)
        FOR x% = XMin% TO XMax%
                LINE (x%, Edges%(x%, 0))-(x%, Edges%(x%, 1)), Col%
        NEXT
END SUB

DEFINT A-Z
SUB Fset (Col%, r%, g%, b%)
OUT &H3C8, Col%
OUT &H3C9, r%
OUT &H3C9, g%
OUT &H3C9, b%
END SUB

DEFSNG A-Z
SUB LoadObject
RESTORE PolygonData
FOR x% = 0 TO PolNumber%
        READ P(x%, 0).x, P(x%, 0).y
        READ P(x%, 1).x, P(x%, 1).y
        READ P(x%, 2).x, P(x%, 2).y
NEXT
END SUB

