' -----------------------------
' Basic polygon fill routine.  Fills triangles
' only, although changing that shouldn't
' be too hard.

' Written by M \ K Productions
' http://members.aol.com/mkwebsite/index.html
' -----------------------------

DECLARE SUB BuildEdges ()
DECLARE SUB ClearEdges ()
DECLARE SUB FillPolygon (Col%)

CLS
SCREEN 13
DEFINT A-Z
RANDOMIZE TIMER
'$DYNAMIC

TYPE ptype
        X AS INTEGER
        y AS INTEGER
END TYPE

CONST NumPts = 2


DIM SHARED Polygon(NumPts) AS ptype  ' Polygon holds the rotated points

DIM SHARED Edges%(0 TO 320, 0 TO 1)
DIM SHARED XMin%, XMax%

'initialize random triangle
FOR X% = 0 TO NumPts
        Polygon(X%).X = INT(RND * 320) + 1
        Polygon(X%).y = INT(RND * 200) + 1
        PSET (Polygon(X%).X, Polygon(X%).y), 31
NEXT

DO: LOOP UNTIL INKEY$ <> ""



ClearEdges
BuildEdges
FillPolygon 31


DO: LOOP UNTIL INKEY$ <> ""

REM $STATIC
DEFSNG A-Z
SUB BuildEdges

        ' Find the x min and max values
        XMin% = 32767
        XMax% = -32767
        FOR X% = 0 TO 2
                IF Polygon(X%).X > XMax% THEN XMax% = Polygon(X%).X
                IF Polygon(X%).X < XMin% THEN XMin% = Polygon(X%).X
        NEXT


        ' Build a list of edges
        FOR Node% = 0 TO 2
              
                Pnt1% = Node%                 ' Calculate which two points of
                Pnt2% = (Node% + 1) MOD 3     ' the polygon to trace
              
                ' Sort the two X point values
                IF Polygon(Pnt1%).X > Polygon(Pnt2%).X THEN SWAP Pnt1%, Pnt2%
              
                x1% = Polygon(Pnt1%).X
                x2% = Polygon(Pnt2%).X
                y1% = Polygon(Pnt1%).y
                y2% = Polygon(Pnt2%).y
               
                Xdelta% = x2% - x1%
                YDelta% = y2% - y1%

                ' Calculate the Y slope (increment)
                IF Xdelta% <> 0 THEN
                        YSlope! = YDelta% / Xdelta%
                ELSE
                        YSlope! = 0
                END IF
                YStep! = Polygon(Pnt1%).y
              
               
                ' Loop from x pos to next x pos, filling in edges with ystep
                FOR X% = x1% TO x2%
                        
                        IF X% = 160 THEN
                        h = 1
                        END IF

                        IF Edges%(X%, 0) = -1 THEN
                                Edges%(X%, 0) = YStep!
                        ELSE
                                IF YStep! > Edges%(X%, 1) THEN
                                        Edges%(X%, 1) = YStep!
                                ELSEIF YStep! < Edges%(X%, 0) THEN
                                        Edges%(X%, 0) = YStep!
                                END IF
                                        IF Edges%(X%, 0) > Edges%(X%, 1) THEN SWAP Edges%(X%, 1), Edges%(X%, 0)
                                
                        END IF
                       
                        YStep! = YStep! + YSlope!
                        
                NEXT


        NEXT


END SUB

SUB ClearEdges
FOR X% = 0 TO 320
        Edges%(X%, 0) = -1
        Edges%(X%, 1) = -1
NEXT
END SUB

SUB FillPolygon (Col%)
        FOR X% = XMin% TO XMax%
                LINE (X%, Edges%(X%, 0))-(X%, Edges%(X%, 1)), Col%
        NEXT
END SUB

