' -----------------------------
' Rotating polygon demo.

' Written by M \ K Productions
' http://members.aol.com/mkwebsite/index.html
' -----------------------------

DECLARE SUB buildedges ()
DECLARE SUB clearedges ()
DECLARE SUB FillPolygon (Col%)

CLS
SCREEN 7
DEFINT A-Z
RANDOMIZE TIMER
'$DYNAMIC

TYPE ptype
        X AS INTEGER
        Y AS INTEGER
END TYPE

CONST XOrigin = 160
CONST YOrigin = 100
CONST NumPts = 2
CONST pi = 3.141592

DIM SHARED P(NumPts) AS ptype        ' P holds the orignal polygon data
DIM SHARED Polygon(NumPts) AS ptype  ' Polygon holds the rotated points

DIM SINt(0 TO 360) AS SINGLE, COSt(0 TO 360) AS SINGLE
DIM SHARED Edges%(0 TO 320, 0 TO 1)
DIM SHARED XMin%, XMax%

'initialize random triangle
FOR X% = 0 TO NumPts
        P(X%).X = INT(RND * 320) + 1
        P(X%).Y = INT(RND * 200) + 1
NEXT
P(0).X = 160
P(0).Y = 60

P(1).X = 180
P(1).Y = 140

P(2).X = 140
P(2).Y = 140



'create corrected sinus/cos tables
FOR angle% = 0 TO 360
        SINt(angle%) = SIN(angle% * pi / 180)
        COSt(angle%) = COS(angle% * pi / 180)
NEXT


ActivePage% = 2
SCREEN , , ActivePage%, 0
DO
FOR angle% = 0 TO 360 STEP 3

        PCOPY 3, ActivePage%


        FOR X% = 0 TO NumPts
               
                lx = P(X%).X - 160
                ly = P(X%).Y - 100
     
                nx = COSt(angle%) * lx - SINt(angle%) * ly
                ny = COSt(angle%) * ly + SINt(angle%) * lx
               
                Polygon(X%).X = 160 + nx
                Polygon(X%).Y = 100 + ny
                IF Polygon(X%).X > 319 THEN Polygon(X%).X = 319
                IF Polygon(X%).X < 0 THEN Polygon(X%).X = 0
               
                IF Polygon(X%).Y > 199 THEN Polygon(X%).Y = 199
                IF Polygon(X%).Y < 0 THEN Polygon(X%).Y = 0

        NEXT
       
        clearedges
        buildedges
        FillPolygon 31

        PCOPY ActivePage%, 0

NEXT
LOOP UNTIL INKEY$ <> ""

REM $STATIC
DEFSNG A-Z
SUB buildedges

        ' Find the x min and max values
        XMin% = 32767
        XMax% = -32767
        FOR X% = 0 TO 2
                IF Polygon(X%).X > XMax% THEN XMax% = Polygon(X%).X
                IF Polygon(X%).X < XMin% THEN XMin% = Polygon(X%).X
        NEXT


        ' Build a list of edges
        FOR Node% = 0 TO 2
              
                Pnt1% = Node%                 ' Calculate which two points of
                Pnt2% = (Node% + 1) MOD 3     ' the polygon to trace
              
                ' Sort the two X point values
                IF Polygon(Pnt1%).X > Polygon(Pnt2%).X THEN SWAP Pnt1%, Pnt2%
              
                x1% = Polygon(Pnt1%).X
                x2% = Polygon(Pnt2%).X
                y1% = Polygon(Pnt1%).Y
                y2% = Polygon(Pnt2%).Y
               
                Xdelta% = x2% - x1%
                YDelta% = y2% - y1%

                ' Calculate the Y slope (increment)
                IF Xdelta% <> 0 THEN
                        YSlope! = YDelta% / Xdelta%
                ELSE
                        YSlope! = 0
                END IF
                YStep! = Polygon(Pnt1%).Y
              
               
                ' Loop from x pos to next x pos, filling in edges with ystep
                FOR X% = x1% TO x2%
                        
                        IF X% = 160 THEN
                        h = 1
                        END IF

                        IF Edges%(X%, 0) = -1 THEN
                                Edges%(X%, 0) = YStep!
                        ELSE
                                IF YStep! > Edges%(X%, 1) THEN
                                        Edges%(X%, 1) = YStep!
                                ELSEIF YStep! < Edges%(X%, 0) THEN
                                        Edges%(X%, 0) = YStep!
                                END IF
                                        IF Edges%(X%, 0) > Edges%(X%, 1) THEN SWAP Edges%(X%, 1), Edges%(X%, 0)
                                
                        END IF
                       
                        YStep! = YStep! + YSlope!
                        
                NEXT


        NEXT


END SUB

SUB clearedges
FOR X% = 0 TO 320
        Edges%(X%, 0) = -1
        Edges%(X%, 1) = -1
NEXT
END SUB

SUB FillPolygon (Col%)
        FOR X% = XMin% TO XMax%
                LINE (X%, Edges%(X%, 0))-(X%, Edges%(X%, 1)), Col%
        NEXT
END SUB

