' -----------------------------
' Scaling and rotation demo.  This
' combination produces some pretty
' nice results.  I thought the trails
' and multi colors would look better
' than page flipped mode 7 graphics,
' so I wrote this program for screen
' 13.

' This is probably the most computational
' intensive program included, so compiling
' would make a very noticable differnece.

' Written by M \ K Productions
' http://members.aol.com/mkwebsite/index.html
' -----------------------------

DECLARE SUB LoadObject (C%)
DECLARE SUB SelectObject ()
DECLARE SUB BuildTables ()
DECLARE SUB SetPal ()
DECLARE SUB Delay (X!)
DECLARE SUB fset (Col%, r%, g%, b%)
DECLARE SUB FillPolygon (Col%)
DECLARE SUB DrawObject ()
DECLARE SUB dumpedges ()
DECLARE SUB BuildEdges (Q%)
DECLARE SUB ClearEdges ()


CLS
DEFINT A-Z
RANDOMIZE TIMER
'$DYNAMIC

TYPE PType
        X AS INTEGER
        Y AS INTEGER
END TYPE

CONST XOrigin = 160
CONST YOrigin = 100
CONST pi = 3.141592

DIM SHARED PolNumber%
SelectObject


DIM SHARED Polygon(0 TO PolNumber%, 0 TO 2) AS PType
DIM SHARED P(0 TO PolNumber%, 0 TO 2)  AS PType

DIM SHARED Scale(0 TO 360) AS SINGLE
DIM SHARED SINt(0 TO 360) AS SINGLE, COSt(0 TO 360) AS SINGLE
DIM SHARED Edges%(0 TO 320, 0 TO 1)
DIM SHARED XMin%, XMax%, Trails%

CLS
SCREEN 13

LoadObject PolNumber%
BuildTables
SetPal

Sc% = 0
DO
FOR Angle% = 0 TO 360 STEP 5
      
        FOR Y% = 0 TO PolNumber%
                FOR X% = 0 TO 2
               
                        lx = P(Y%, X%).X - 160
                        ly = P(Y%, X%).Y - 100
     
                        nx = COSt(Angle%) * lx - SINt(Angle%) * ly
                        ny = COSt(Angle%) * ly + SINt(Angle%) * lx
               
                        Polygon(Y%, X%).X = 160 + (nx * Scale(Sc%))
                        Polygon(Y%, X%).Y = 100 + (ny * Scale(Sc%))

                        IF Polygon(Y%, X%).X > 319 THEN Polygon(Y%, X%).X = 319
                        IF Polygon(Y%, X%).X < 0 THEN Polygon(Y%, X%).X = 0
               
                        IF Polygon(Y%, X%).Y > 199 THEN Polygon(Y%, X%).Y = 199
                        IF Polygon(Y%, X%).Y < 0 THEN Polygon(Y%, X%).Y = 0

                NEXT
        NEXT
       
        FOR X% = 0 TO PolNumber%
                ClearEdges
                BuildEdges X%
                FillPolygon Col%
        NEXT
       
        Col% = Col% + 1
        IF Col% = 143 THEN
                CLS
                Col% = 0
                SetPal
        END IF
        fset Col% - Trails%, 0, 0, 0

        Sc% = Sc% + 1
        IF Sc% = 180 THEN Sc% = 1
NEXT

LOOP UNTIL INKEY$ <> ""
CLS
SCREEN 0
WIDTH 80
SYSTEM



MKPolygonData:
DATA 14
DATA 60,50,70,50,60,150, 70,50,60,150,70,150, 70,50,70,60,120,110
DATA 70,50,120,100,120,110, 120,100,130,100,120,110, 120,110,130,110,130,100
DATA 130,110,180,50,180,60, 130,110,130,100,180,50, 180,50,190,50,180,150
DATA 180,150,190,150,190,50, 195,100,190,105,190,95, 195,100,235,50,245,50
DATA 190,95,195,100,235,50, 235,150,195,100,190,105, 235,150,245,150,195,100


Triangle:
DATA 0
DATA 160,60,180,140,140,140


Square:
DATA 1
DATA 140,60,180,140,140,140,   140,60,180,60,180,140


Star:
DATA 7
DATA 148,84,172,84,160,60,    172,84,198,88,179,106,  179,106,160,120,184,132
DATA 160,120,141,106,136,132,  141,106,148,84,122,88
DATA 160,120,179,106,141,106,   141,106,179,106,172,84,   172,84,148,84,141,106

REM $STATIC
DEFSNG A-Z
SUB BuildEdges (Q%)


        ' Find the x min and max values
        XMin% = 32767
        XMax% = -32767
        FOR X% = 0 TO 2
                IF Polygon(Q%, X%).X > XMax% THEN XMax% = Polygon(Q%, X%).X
                IF Polygon(Q%, X%).X < XMin% THEN XMin% = Polygon(Q%, X%).X
        NEXT


        ' Build a list of edges
        FOR Node% = 0 TO 2
              
                Pnt1% = Node%                 ' Calculate which two points of
                Pnt2% = (Node% + 1) MOD 3     ' the polygon to trace
              
                ' Sort the two X point values
                IF Polygon(Q%, Pnt1%).X > Polygon(Q%, Pnt2%).X THEN SWAP Pnt1%, Pnt2%
              
                x1% = Polygon(Q%, Pnt1%).X
                x2% = Polygon(Q%, Pnt2%).X
                y1% = Polygon(Q%, Pnt1%).Y
                y2% = Polygon(Q%, Pnt2%).Y
               
                Xdelta% = x2% - x1%
                YDelta% = y2% - y1%

                ' Calculate the Y slope (increment)
                IF Xdelta% <> 0 THEN
                        YSlope! = YDelta% / Xdelta%
                ELSE
                        YSlope! = 0
                END IF
                YStep! = Polygon(Q%, Pnt1%).Y
              
               
                ' Loop from x pos to next x pos, filling in edges with ystep
                FOR X% = x1% TO x2%

                        IF Edges%(X%, 0) = -1 THEN
                                Edges%(X%, 0) = YStep!
                        ELSE
                                IF YStep! > Edges%(X%, 1) THEN
                                        Edges%(X%, 1) = YStep!
                                ELSEIF YStep! < Edges%(X%, 0) THEN
                                        Edges%(X%, 0) = YStep!
                                END IF
                                        IF Edges%(X%, 0) > Edges%(X%, 1) THEN SWAP Edges%(X%, 1), Edges%(X%, 0)
                                
                        END IF
                       
                        YStep! = YStep! + YSlope!
                        
                NEXT


        NEXT


END SUB

DEFINT A-Z
SUB BuildTables
        'create corrected sinus/cos tables
        FOR Angle% = 0 TO 360
                SINt(Angle%) = SIN(Angle% * pi / 180)
                COSt(Angle%) = COS(Angle% * pi / 180)
        NEXT


        'build a scale list for scaling/shrinking the object
        a! = 0
        FOR Angle% = 0 TO 180
                Scale(Angle%) = 1 - SIN(a! * pi / 180)
                a! = a! + 2
        NEXT
        'Ctr% = 0
        'FOR x% = 180 TO 360
        '        Scale(x%) = Scale(x% - Ctr%)
        '        Ctr% = Ctr% + 2
        'NEXT
END SUB

DEFSNG A-Z
SUB ClearEdges
FOR X% = 0 TO 320
        Edges%(X%, 0) = -1
        Edges%(X%, 1) = -1
NEXT
END SUB

DEFINT A-Z
SUB Delay (X!)
C! = TIMER + X!
DO: LOOP UNTIL TIMER >= C!
END SUB

DEFSNG A-Z
SUB DrawObject
FOR X% = 0 TO PolNumber%
        ClearEdges
        BuildEdges X%
        FillPolygon 1
NEXT
END SUB

DEFINT A-Z
SUB dumpedges
a$ = INPUT$(1)
CLS
SCREEN 0
WIDTH 80
FOR X% = 0 TO 320
        IF Edges(X%, 0) <> -1 THEN
                PRINT Edges(X%, 0); Edges(X%, 1), X%
        END IF
NEXT
END SUB

DEFSNG A-Z
SUB FillPolygon (Col%)
        FOR X% = XMin% TO XMax%
                LINE (X%, Edges%(X%, 0))-(X%, Edges%(X%, 1)), Col%
        NEXT
END SUB

DEFINT A-Z
SUB fset (Col%, r%, g%, b%)
OUT &H3C8, Col%
OUT &H3C9, r%
OUT &H3C9, g%
OUT &H3C9, b%
END SUB

DEFSNG A-Z
SUB LoadObject (C%)
FOR X% = 0 TO C%
        READ P(X%, 0).X, P(X%, 0).Y
        READ P(X%, 1).X, P(X%, 1).Y
        READ P(X%, 2).X, P(X%, 2).Y
NEXT
END SUB

DEFINT A-Z
SUB SelectObject
CLS
PRINT "Welcome."
PRINT
PRINT "Please select an object :"
PRINT "1) M \ K Logo    (Polygon count : 15)"
PRINT "2) Triangle      (Polygon count : 1)"
PRINT "3) Square        (Polygon count : 2)"
PRINT "4) Star          (Polygon count : 8)"
INPUT X%
SELECT CASE X%
        CASE 1: RESTORE MKPolygonData
        CASE 2: RESTORE Triangle
        CASE 3: RESTORE Square
        CASE 4: RESTORE Star
END SELECT
READ PolNumber%
PRINT
PRINT "Please input a number of trails"
INPUT Trails%
END SUB

SUB SetPal
        o! = 0
        FOR X% = 1 TO 36
                fset X%, INT(o!), 0, 0
                fset 72 - X%, INT(o!), 0, 0
                fset X% + 71, INT(o!), 0, 0
                fset 143 - X%, INT(o!), 0, 0
                o! = o! + 1.5
        NEXT
        Col% = 0
END SUB

