'******************--> 3D ++ <--*****************
'*                                              *
'*             A Graphics Library               *
'*                                              *
'*              By David Nielson                *
'*                                              *
'*        nielsonkid@pop.slkc.uswest.net        *
'* HTTP://members.tripod.com/~two_to_the_eighth *
'*                                              *
'************************************************
'
'Authors may use this to write programs.
'Authors may modify it, but may not distribute the modified version in
'any way, shape, or form.
'Authors may not sell, lease, liscence, offer on a pay-per-use basis,
'require royalties, etc.
'This code and its copyrights belong to David K. Nielson.
'If this is used in a game, the author must mention me in the credits.
'You may not say that this is your work.
'You may not copy parts of it and say they are yours.

DECLARE SUB hspan (x1!, x2!, y!, tx1!, ty1!, tx2!, ty2!)
DECLARE SUB fhspan (x1!, x2!, y!, tx1!, ty1!, tx2!, ty2!)
DECLARE SUB fttri (rx1!, ry1!, rx2!, ry2!, rx3!, ry3!, rtx1!, rty1!, rtx2!, rty2!, rtx3!, rty3!)
DECLARE SUB ttri (rx1!, ry1!, rx2!, ry2!, rx3!, ry3!, rtx1!, rty1!, rtx2!, rty2!, rtx3!, rty3!)
DECLARE SUB initslopes ()
DECLARE SUB gtri (rx1!, ry1!, rx2!, ry2!, rx3!, ry3!, rc1!, rc2!, rc3!)
DECLARE SUB tri (rx1!, ry1!, rx2!, ry2!, rx3!, ry3!, c!)
DECLARE SUB fspanmap (tx1!, ty1!, tx2!, ty2!, x!, y1!, y2!)
DECLARE SUB spanmap (tx1!, ty1!, tx2!, ty2!, x!, y1!, y2!)
DECLARE SUB tmap (x!, y1!, y2!, ofs!)
DECLARE SUB ftmap (x!, y1!, y2!, ofs!)
COMMON SHARED tsize AS INTEGER

RANDOMIZE TIMER

DIM SHARED xslop45!(44)
DIM SHARED xslope(359)
DIM SHARED yslope(359)
tsize = 63
DIM SHARED surface(tsize, tsize, 3)
FOR y = 0 TO tsize
FOR x = 0 TO tsize
surface(x, y, 0) = RND * 63
NEXT x, y

CALL initslopes

SCREEN 13

FOR p = 0 TO 63
OUT &H3C8, p
OUT &H3C9, p
OUT &H3C9, p
OUT &H3C9, p
NEXT p

p = 0

SLEEP

'Triangle-drawing demo
GOSUB tridemo

SLEEP

'Gourad-triangle demo
GOSUB gtridemo

SLEEP

'Wolf-mapping Demo
GOSUB tmapdemo

'SLEEP

'Span-mapping Demo
GOSUB spandemo

SLEEP

'Horizontal Span-mapping Demo
GOSUB hspandemo

SLEEP

'filtered Wolf-mapping
GOSUB ftmapdemo

SLEEP

'filtered Span-mapping
GOSUB fspandemo

SLEEP

'Horizontal Span-mapping Demo
GOSUB fhspandemo

SLEEP

'Texture-mapped Triangle demo
GOSUB ttridemo

SLEEP

'Filtered, Texture-mapped Triangle demo
GOSUB ftridemo

SLEEP

'Simple Texture-morphing demo
GOSUB tmorph

SLEEP

CLS
'Palette initialization for next demo
FOR b = 0 TO 63 STEP 4
FOR r = 0 TO 63 STEP 4
OUT &H3C8, p
OUT &H3C9, r
OUT &H3C9, b
OUT &H3C9, b
p = p + 1
NEXT r, b

'Texture remake for this demo
FOR y = 0 TO tsize
FOR x = 0 TO tsize
surface(x, y, 0) = RND * 15
NEXT x, y

'Transparent Texture-morphing demo
GOSUB tmorph2

SLEEP


END

tmorph2:
FOR d = 0 TO 15 STEP .25
CALL fttri(0, 0, .1, 63, 63, 63, 0, d * 2, d * 2, 31, 31, 31 - d * 2)
CALL fttri(0, 0, 63, 63, 63, 0, 0, d * 2, 31, 31 - d * 2, 31 - d * 2, 0)
CALL fttri(64, 0, 64.1, 63, 127, 63, 0, 15 - d, 15 - d, 15, 15, d)
CALL fttri(64, 0, 127, 63, 127, 0, 0, 15 - d, 15, d, d, 0)
FOR y = 0 TO 63
 FOR x = 0 TO 63
  c1 = POINT(x, y)
  c2 = POINT(x + 64, y) * 16
  c = c2 + c1
  PSET (x, y + 64), c
 NEXT x, y
NEXT d
RETURN

tmorph:
FOR d = 0 TO 63
x1 = 0
y1 = 0
x2 = .01
y2 = 64
x3 = 64
y3 = 64
x4 = 64
y4 = 0
CALL ttri(x1, y1, x2, y2, x3, y3, 0, d, d, 63, 63, 63 - d)
CALL ttri(x1, y1, x3, y3, x4, y4, 0, d, 63, 63 - d, 63 - d, 0)
NEXT d
RETURN

ftridemo:
FOR d = 1 TO 10
x1 = RND * 319
y1 = RND * 199
x2 = RND * 319
y2 = RND * 199
x3 = RND * 319
y3 = RND * 199
CALL fttri(x1, y1, x2, y2, x3, y3, 0, 0, 63, 63, 0, 63)
NEXT d
RETURN

ttridemo:
FOR d = 1 TO 20
x1 = RND * 319
y1 = RND * 199
x2 = RND * 319
y2 = RND * 199
x3 = RND * 319
y3 = RND * 199
CALL ttri(x1, y1, x2, y2, x3, y3, 0, 0, 63, 63, 0, 63)
NEXT d
RETURN

gtridemo:
FOR d = 1 TO 50
x1 = RND * 319
y1 = RND * 199
x2 = RND * 319
y2 = RND * 199
x3 = RND * 319
y3 = RND * 199
CALL gtri(x1, y1, x2, y2, x3, y3, 63, 31, 0)
NEXT d
RETURN

tridemo:
FOR d = 1 TO 50
x1 = RND * 319
y1 = RND * 199
x2 = RND * 319
y2 = RND * 199
x3 = RND * 319
y3 = RND * 199
CALL tri(x1, y1, x2, y2, x3, y3, 63)
x1 = RND * 319
y1 = RND * 199
x2 = RND * 319
y2 = RND * 199
x3 = RND * 319
y3 = RND * 199
CALL tri(x1, y1, x2, y2, x3, y3, 0)
NEXT d
RETURN

fspandemo:
FOR d = 0 TO 179
tx1 = 31 + (xslope(d) * 30)
ty1 = 31 + (yslope(d) * 30)
tx2 = 31 - (xslope(d) * 30)
ty2 = 31 - (yslope(d) * 30)
CALL fspanmap(tx1, ty1, tx2, ty2, d, 0, 199)
NEXT d
RETURN

tmapdemo:
FOR x = 0 TO 63 STEP .25
CALL tmap(x * 4, 0, 199, 63 - x)
NEXT x
RETURN

ftmapdemo:
FOR x = 0 TO 63 STEP .25
CALL ftmap(x * 4, 0, 199, 63 - x)
NEXT x
RETURN

spandemo:
FOR d = 0 TO 179
tx1 = 31 + (xslope(d) * 30)
ty1 = 31 + (yslope(d) * 30)
tx2 = 31 - (xslope(d) * 30)
ty2 = 31 - (yslope(d) * 30)
CALL spanmap(tx1, ty1, tx2, ty2, d, 0, 199)
NEXT d
RETURN

hspandemo:
FOR d = 0 TO 179
tx1 = 31 + (xslope(d) * 30)
ty1 = 31 + (yslope(d) * 30)
tx2 = 31 - (xslope(d) * 30)
ty2 = 31 - (yslope(d) * 30)
CALL hspan(0, 319, d, tx1, ty1, tx2, ty2)
NEXT d
RETURN

fhspandemo:
FOR d = 0 TO 179
tx1 = 31 + (xslope(d) * 30)
ty1 = 31 + (yslope(d) * 30)
tx2 = 31 - (xslope(d) * 30)
ty2 = 31 - (yslope(d) * 30)
CALL fhspan(0, 319, d, tx1, ty1, tx2, ty2)
NEXT d
RETURN

SUB fhspan (x1, x2, y, tx1, ty1, tx2, ty2)
xd = x1 - x2                                 'Distance between Screen points
txd = tx1 - tx2                              'Distance between Texture points
tyd = ty1 - ty2                              '   "        "       "      "

IF xd <> 0 THEN
 txi = txd / xd        'Find texture pointer increment for x.
 tyi = tyd / xd        'Find texture pointer increment for y.
ELSE
 txi = 1
 tyi = 1
END IF

tx = tx1
ty = ty1

'Now we are ready to begin scanning.

FOR x = x1 TO x2      'Mapping is oriented to the screen, from top to bottom.

 ftx = FIX(tx)                    'These four variables
 fty = FIX(ty)                    'are the four texels that
 ftx2 = ftx + 1                   'we will be combining
 fty2 = fty + 1                   'together.
 wtx = tx - ftx                   'These four values
 wty = ty - fty                   'are the percentages that
 wtx2 = 1 - (tx - ftx)            'each texel will take up
 wty2 = 1 - (ty - fty)            'in the final color.
 IF ftx2 > tsize THEN ftx2 = ftx2 MOD tsize        'Make sure we stay
 IF fty2 > tsize THEN fty2 = tsize                 'ON the texture...
 IF ftx > tsize THEN ftx = tsize
 IF fty > tsize THEN fty = tsize
 c1 = surface(ftx, fty, 0) * wtx2                  'Get the colors to blend
 c2 = surface(ftx2, fty, 0) * wtx
 c11 = (c1 + c2) * wty2                            'Blending, step 1
 c3 = surface(ftx, fty2, 0) * wtx2
 c4 = surface(ftx2, fty2, 0) * wtx
 c22 = (c3 + c4) * wty                             'Blending, step 2
 c = c11 + c22                                     'Final calculation

 PSET (x, y), c             'Draw the pixel.

 tx = tx + txi              'Increment texture pointers.
 ty = ty + tyi

NEXT x                'Finish loop
END SUB

SUB fspanmap (tx1, ty1, tx2, ty2, x, y1, y2)
yd = y1 - y2
txd = tx1 - tx2
tyd = ty1 - ty2
IF yd <> 0 THEN
 txi = txd / yd
 tyi = tyd / yd
END IF
tx = tx1
ty = ty1
FOR y = y1 TO y2
 ftx = FIX(tx)                    'These four variables
 fty = FIX(ty)                    'are the four texels that
 ftx2 = ftx + 1                   'we will be combining
 fty2 = fty + 1                   'together.
 wtx = tx - ftx                   'These four values
 wty = ty - fty                   'are the percentages that
 wtx2 = 1 - (tx - ftx)            'each texel will take up
 wty2 = 1 - (ty - fty)            'in the final color.
 IF ftx2 > tsize THEN ftx2 = ftx2 MOD tsize        'Make sure we stay
 IF fty2 > tsize THEN fty2 = tsize                 'ON the texture...
 IF ftx > tsize THEN ftx = tsize
 IF fty > tsize THEN fty = tsize
 c1 = surface(ftx, fty, 0) * wtx2                  'Get the colors to blend
 c2 = surface(ftx2, fty, 0) * wtx
 c11 = (c1 + c2) * wty2                            'Blending, step 1
 c3 = surface(ftx, fty2, 0) * wtx2
 c4 = surface(ftx2, fty2, 0) * wtx
 c22 = (c3 + c4) * wty                             'Blending, step 2
 c = c11 + c22                                     'Final calculation
 PSET (x, y), c                                    'Draw the pixel!
 tx = tx + txi                                     'Increment pointer
 ty = ty + tyi
 IF tx > tsize THEN tx = tx MOD tsize
 IF ty > tsize THEN ty = tx MOD tsize
NEXT y
END SUB

SUB ftmap (x, y1, y2, ofs)
IF y1 > y2 THEN d = y1 - y2 ELSE d = y2 - y1
d = tsize / d
d2 = 0
w3 = ofs - FIX(ofs)
w4 = 1 - w3
ofs = FIX(ofs)
ofs2 = ofs + 1
IF ofs2 > tsize THEN ofs2 = tsize
FOR y = y1 TO y2
 d2 = d2 + d
 fuy = FIX(d2)
 fuy2 = fuy + 1
 IF fuy > tsize THEN fuy = tsize
 IF fuy2 > tsize THEN fuy2 = tsize
 w1 = d2 - fuy
 w2 = 1 - w1
 wc1 = surface(ofs, fuy, 0) * w2
 wc2 = surface(ofs, fuy2, 0) * w1
 wc3 = surface(ofs2, fuy, 0) * w2
 wc4 = surface(ofs2, fuy2, 0) * w1
 c1 = (wc1 + wc2) * w4
 c2 = (wc3 + wc4) * w3
 c = c1 + c2
 IF d2 > tsize THEN d2 = tsize
 PSET (x, y), c
NEXT y
END SUB

SUB fttri (rx1, ry1, rx2, ry2, rx3, ry3, rtx1, rty1, rtx2, rty2, rtx3, rty3)
DIM tripoints(319, 6)
IF rx1 < rx2 THEN
 IF rx1 < rx3 THEN
  x1 = rx1: y1 = ry1: tx1 = rtx1: ty1 = rty1
  IF rx2 < rx3 THEN
   x2 = rx2: y2 = ry2: tx2 = rtx2: ty2 = rty2
   x3 = rx3: y3 = ry3: tx3 = rtx3: ty3 = rty3
  ELSE
   x3 = rx2: y3 = ry2: tx3 = rtx2: ty3 = rty2
   x2 = rx3: y2 = ry3: tx2 = rtx3: ty2 = rty3
  END IF
 ELSE
  x1 = rx3: y1 = ry3: tx1 = rtx3: ty1 = rty3
  IF rx1 < rx2 THEN
   x2 = rx1: y2 = ry1: tx2 = rtx1: ty2 = rty1
   x3 = rx2: y3 = ry2: tx3 = rtx2: ty3 = rty2
  ELSE
   x2 = rx2: y2 = ry2: tx2 = rtx2: ty2 = rty2
   x3 = rx1: y3 = ry1: tx3 = rtx1: ty3 = rty1
  END IF
 END IF
ELSE
 x1 = rx2: y1 = ry2: tx1 = rtx2: ty1 = rty2
 IF rx1 < rx3 THEN
  x2 = rx1: y2 = ry1: tx2 = rtx1: ty2 = rty1
  x3 = rx3: y3 = ry3: tx3 = rtx1: ty3 = rty3
 ELSE
  x2 = rx3: y2 = ry3: tx2 = rtx3: ty2 = rty3
  x3 = rx1: y3 = ry1: tx3 = rtx1: ty3 = rty1
 END IF
END IF
IF y1 < y3 THEN
 yi = (y3 - y1) / (x3 - x1)
 txi = (tx3 - tx1) / (x3 - x1)
 tyi = (ty3 - ty1) / (x3 - x1)
 y = y1
 tx = tx1
 ty = ty1
 FOR x = x1 TO x3
  tripoints(x, 0) = -1
  tripoints(x, 1) = y
  tripoints(x, 2) = y
  tripoints(x, 3) = tx
  tripoints(x, 4) = ty
  tripoints(x, 5) = tx
  tripoints(x, 6) = ty
  y = y + yi
  tx = tx + txi
  ty = ty + tyi
 NEXT x
ELSE
 IF x3 - x1 <> 0 THEN
  yi = (y1 - y3) / (x3 - x1)
  txi = (tx3 - tx1) / (x3 - x1)
  tyi = (ty3 - ty1) / (x3 - x1)
 ELSE
  yi = 1
  txi = 1
  tyi = 1
 END IF
 y = y1
 tx = tx1
 ty = ty1
 FOR x = x1 TO x3
  tripoints(x, 0) = -1
  tripoints(x, 1) = y
  tripoints(x, 2) = y
  tripoints(x, 3) = tx
  tripoints(x, 4) = ty
  tripoints(x, 5) = tx
  tripoints(x, 6) = ty
  y = y - yi
  tx = tx + txi
  ty = ty + tyi
 NEXT x
END IF
IF x2 <> x1 THEN
 yi = (y2 - y1) / (x2 - x1)
 txi = (tx2 - tx1) / (x2 - x1)
 tyi = (ty2 - ty1) / (x2 - x1)
ELSE
 yi = 1
 txi = 1
 tyi = 1
END IF
y = y1
tx = tx1
ty = ty1
FOR x = x1 TO x2
 IF y > tripoints(x, 1) THEN
  tripoints(x, 2) = y
  tripoints(x, 5) = tx
  tripoints(x, 6) = ty
 ELSE
  tripoints(x, 1) = y
  tripoints(x, 3) = tx
  tripoints(x, 4) = ty
 END IF
 y = y + yi
 tx = tx + txi
 ty = ty + tyi
NEXT x
IF x3 <> x2 THEN
 yi = (y3 - y2) / (x3 - x2)
 txi = (tx3 - tx2) / (x3 - x2)
 tyi = (ty3 - ty2) / (x3 - x2)
ELSE
 yi = 1
 txi = 1
 tyi = 1
END IF
y = y2
tx = tx2
ty = ty2
FOR x = x2 TO x3
 IF y > tripoints(x, 1) THEN
  tripoints(x, 2) = y
  tripoints(x, 5) = tx
  tripoints(x, 6) = ty
 ELSE
  tripoints(x, 1) = y
  tripoints(x, 3) = tx
  tripoints(x, 4) = ty
 END IF
 y = y + yi
 tx = tx + txi
 ty = ty + tyi
NEXT x
FOR x = 0 TO 319
 IF tripoints(x, 0) THEN
  tx1 = tripoints(x, 3)
  ty1 = tripoints(x, 4)
  tx2 = tripoints(x, 5)
  ty2 = tripoints(x, 6)
  y1 = tripoints(x, 1)
  y2 = tripoints(x, 2)
 CALL fspanmap(tx1, ty1, tx2, ty2, x, y1, y2)
 END IF
NEXT x
END SUB

SUB gtri (rx1, ry1, rx2, ry2, rx3, ry3, rc1, rc2, rc3)
DIM tripoints(319, 4)
IF rx1 < rx2 THEN
 IF rx1 < rx3 THEN
  x1 = rx1: y1 = ry1: c1 = rc1
  IF rx2 < rx3 THEN
   x2 = rx2: y2 = ry2: c2 = rc2
   x3 = rx3: y3 = ry3: c3 = rc3
  ELSE
   x2 = rx3: y2 = ry3: c2 = rc3
   x3 = rx2: y3 = ry2: c3 = rc2
  END IF
 ELSE
  x1 = rx3: y1 = ry3: c1 = rc3
  IF rx1 < rx2 THEN
   x2 = rx1: y2 = ry1: c2 = rc1
   x3 = rx2: y3 = ry2: c3 = rc2
  ELSE
   x2 = rx2: y2 = ry2: c2 = rc2
   x3 = rx1: y3 = ry1: c3 = rc1
  END IF
 END IF
ELSE
  x1 = rx2: y1 = ry2: c1 = rc2
  IF rx1 < rx3 THEN
   x2 = rx1: y2 = ry1: c2 = rc1
   x3 = rx3: y3 = ry3: c3 = rc3
  ELSE
   x2 = rx3: y2 = ry3: c2 = rc3
   x3 = rx1: y3 = ry1: c3 = rc1
  END IF
END IF
IF y1 < y3 THEN
 yi = (y3 - y1) / (x3 - x1)
 gi = (c3 - c1) / (x3 - x1)
 y = y1
 c = c1
 FOR x = x1 TO x3
  tripoints(x, 0) = -1
  tripoints(x, 1) = y
  tripoints(x, 2) = y
  tripoints(x, 3) = c
  tripoints(x, 4) = c
  y = y + yi
  c = c + gi
 NEXT x
ELSE
 yi = (y1 - y3) / (x3 - x1)
 gi = (c3 - c1) / (x3 - x1)
 y = y1
 c = c1
 FOR x = x1 TO x3
  tripoints(x, 0) = -1
  tripoints(x, 1) = y
  tripoints(x, 2) = y
  tripoints(x, 3) = c
  tripoints(x, 4) = c
  y = y - yi
  c = c + gi
 NEXT x
END IF
yi = (y2 - y1) / (x2 - x1)
gi = (c2 - c1) / (x2 - x1)
y = y1
c = c1
FOR x = x1 TO x2
 IF y > tripoints(x, 1) THEN
  tripoints(x, 2) = y
  tripoints(x, 4) = c
 ELSE
  tripoints(x, 1) = y
  tripoints(x, 3) = c
 END IF
 y = y + yi
 c = c + gi
NEXT x
yi = (y3 - y2) / (x3 - x2)
gi = (c3 - c2) / (x3 - x2)
y = y2
c = c2
FOR x = x2 TO x3
 IF y > tripoints(x, 1) THEN
  tripoints(x, 2) = y
  tripoints(x, 4) = c
 ELSE
  tripoints(x, 1) = y
  tripoints(x, 3) = c
 END IF
 y = y + yi
 c = c + gi
NEXT x
FOR x = 0 TO 319
 IF tripoints(x, 0) THEN
  c1 = tripoints(x, 3)
  c2 = tripoints(x, 4)
  y1 = tripoints(x, 1)
  y2 = tripoints(x, 2)
  IF y2 - y1 <> 0 THEN
   gi = (c2 - c1) / (y2 - y1)
  END IF
  c = c1
  FOR y = y1 TO y2
   PSET (x, y), c
   c = c + gi
  NEXT y
 END IF
NEXT x
END SUB

SUB hspan (x1, x2, y, tx1, ty1, tx2, ty2)
xd = x1 - x2                                 'Distance between Screen points
txd = tx1 - tx2                              'Distance between Texture points
tyd = ty1 - ty2                              '   "        "       "      "

IF xd <> 0 THEN
 txi = txd / xd        'Find texture pointer increment for x.
 tyi = tyd / xd        'Find texture pointer increment for y.
ELSE
 txi = 1
 tyi = 1
END IF

tx = tx1
ty = ty1

'Now we are ready to begin scanning.

FOR x = x1 TO x2      'Mapping is oriented to the screen, from top to bottom.

 IF tx < 0 THEN tx = 0            'Make sure we stay ON the texture!
 IF ty < 0 THEN ty = 0
 IF tx > tsize THEN tx = tsize
 IF ty > tsize THEN ty = tsize

 c = surface(tx, ty, 0)     'Get color.
                            'This will be replaced with code for weighted
                            'point sampling.
 PSET (x, y), c             'Draw the pixel.

 tx = tx + txi              'Increment texture pointers.
 ty = ty + tyi

NEXT x                'Finish loop
END SUB

SUB initslopes
xslop45!(0) = 0
FOR s = 1 TO 44
xslop45!(s) = s / 45
NEXT s
FOR d = 0 TO 44
xslope(d) = xslop45!(d)
yslope(d) = -1
xslope(d + 45) = 1
yslope(d + 45) = -xslop45!(44 - d)
xslope(d + 90) = 1
yslope(d + 90) = xslop45!(d)
xslope(d + 135) = xslop45!(44 - d)
yslope(d + 135) = 1
xslope(d + 180) = -xslop45!(d)
yslope(d + 180) = 1
xslope(d + 225) = -1
yslope(d + 225) = xslop45!(44 - d)
xslope(d + 270) = -1
yslope(d + 270) = -xslop45!(d)
xslope(d + 315) = -xslop45!(44 - d)
yslope(d + 315) = -1
NEXT d
FOR d = 0 TO 359
IF xslope(d) <> 0 AND yslope(d) <> 0 THEN
 rd = ((xslope(d) ^ 2) + (yslope(d) ^ 2)) ^ .5
 dc = 1 / rd
 xslope(d) = xslope(d) * dc
 yslope(d) = yslope(d) * dc
ELSE
END IF
NEXT d
END SUB

SUB spanmap (tx1, ty1, tx2, ty2, x, y1, y2)
yd = y1 - y2                                 'Distance between Screen points
txd = tx1 - tx2                              'Distance between Texture points
tyd = ty1 - ty2                              '   "        "       "      "

IF yd <> 0 THEN
 txi = txd / yd        'Find texture pointer increment for x.
 tyi = tyd / yd        'Find texture pointer increment for y.
ELSE
 txi = 1
 tyi = 1
END IF

tx = tx1
ty = ty1

'Now we are ready to begin scanning.

FOR y = y1 TO y2      'Mapping is oriented to the screen, from top to bottom.

 IF tx < 0 THEN tx = 0            'Make sure we stay ON the texture!
 IF ty < 0 THEN ty = 0
 IF tx > tsize THEN tx = tsize
 IF ty > tsize THEN ty = tsize

 c = surface(tx, ty, 0)     'Get color.
                            'This will be replaced with code for weighted
                            'point sampling.
 PSET (x, y), c             'Draw the pixel.

 tx = tx + txi              'Increment texture pointers.
 ty = ty + tyi

NEXT y                'Finish loop
END SUB

SUB sqrmap (x1, y1, x2, y2, tx1, ty1, tx2, ty2, tx3, ty3, tx4, ty4)

END SUB

SUB tmap (x, y1, y2, ofs)
IF y1 > y2 THEN d = y1 - y2 ELSE d = y2 - y1
d = tsize / d
d2 = 0
FOR y = y1 TO y2
 c = surface(FIX(ofs + .5), FIX(d2 + .5), 0)
 d2 = d2 + d
 PSET (x, y), c
NEXT y
END SUB

SUB tri (rx1, ry1, rx2, ry2, rx3, ry3, c)
DIM tripoints(319, 2)
IF rx1 < rx2 THEN
 IF rx1 < rx3 THEN
  x1 = rx1: y1 = ry1
  IF rx2 < rx3 THEN
   x2 = rx2: y2 = ry2
   x3 = rx3: y3 = ry3
  ELSE
   x2 = rx3: y2 = ry3
   x3 = rx2: y3 = ry2
  END IF
 ELSE
  x1 = rx3: y1 = ry3
  IF rx1 < rx2 THEN
   x2 = rx1: y2 = ry1
   x3 = rx2: y3 = ry2
  ELSE
   x2 = rx2: y2 = ry2
   x3 = rx1: y3 = ry1
  END IF
 END IF
ELSE
 x1 = rx2: y1 = ry2
  IF rx1 < rx3 THEN
   x2 = rx1: y2 = ry1
   x3 = rx3: y3 = ry3
  ELSE
   x2 = rx3: y2 = ry3
   x3 = rx1: y3 = ry1
  END IF
END IF
IF y1 < y3 THEN
 yi = (y3 - y1) / (x3 - x1)
 y = y1
 FOR x = x1 TO x3
  tripoints(x, 0) = -1
  tripoints(x, 1) = y
  tripoints(x, 2) = y
  y = y + yi
 NEXT x
ELSE
 yi = (y1 - y3) / (x3 - x1)
 y = y1
 FOR x = x1 TO x3
  tripoints(x, 0) = -1
  tripoints(x, 1) = y
  tripoints(x, 2) = y
  y = y - yi
 NEXT x
END IF
yi = (y2 - y1) / (x2 - x1)
y = y1
FOR x = x1 TO x2
 IF y > tripoints(x, 1) THEN
  tripoints(x, 2) = y
 ELSE
  tripoints(x, 2) = y
 END IF
 y = y + yi
NEXT x
yi = (y3 - y2) / (x3 - x2)
y = y2
FOR x = x2 TO x3
 IF y > tripoints(x, 1) THEN
  tripoints(x, 2) = y
 ELSE
  tripoints(x, 2) = y
 END IF
 y = y + yi
NEXT x
FOR x = 0 TO 319
 IF tripoints(x, 0) THEN
  LINE (x, tripoints(x, 1))-(x, tripoints(x, 2)), c
 END IF
NEXT x
END SUB

SUB ttri (rx1, ry1, rx2, ry2, rx3, ry3, rtx1, rty1, rtx2, rty2, rtx3, rty3)
DIM tripoints(319, 6)
IF rx1 < rx2 THEN
 IF rx1 < rx3 THEN
  x1 = rx1: y1 = ry1: tx1 = rtx1: ty1 = rty1
  IF rx2 < rx3 THEN
   x2 = rx2: y2 = ry2: tx2 = rtx2: ty2 = rty2
   x3 = rx3: y3 = ry3: tx3 = rtx3: ty3 = rty3
  ELSE
   x3 = rx2: y3 = ry2: tx3 = rtx2: ty3 = rty2
   x2 = rx3: y2 = ry3: tx2 = rtx3: ty2 = rty3
  END IF
 ELSE
  x1 = rx3: y1 = ry3: tx1 = rtx3: ty1 = rty3
  IF rx1 < rx2 THEN
   x2 = rx1: y2 = ry1: tx2 = rtx1: ty2 = rty1
   x3 = rx2: y3 = ry2: tx3 = rtx2: ty3 = rty2
  ELSE
   x2 = rx2: y2 = ry2: tx2 = rtx2: ty2 = rty2
   x3 = rx1: y3 = ry1: tx3 = rtx1: ty3 = rty1
  END IF
 END IF
ELSE
 x1 = rx2: y1 = ry2: tx1 = rtx2: ty1 = rty2
 IF rx1 < rx3 THEN
  x2 = rx1: y2 = ry1: tx2 = rtx1: ty2 = rty1
  x3 = rx3: y3 = ry3: tx3 = rtx1: ty3 = rty3
 ELSE
  x2 = rx3: y2 = ry3: tx2 = rtx3: ty2 = rty3
  x3 = rx1: y3 = ry1: tx3 = rtx1: ty3 = rty1
 END IF
END IF
IF y1 < y3 THEN
 yi = (y3 - y1) / (x3 - x1)
 txi = (tx3 - tx1) / (x3 - x1)
 tyi = (ty3 - ty1) / (x3 - x1)
 y = y1
 tx = tx1
 ty = ty1
 FOR x = x1 TO x3
  tripoints(x, 0) = -1
  tripoints(x, 1) = y
  tripoints(x, 2) = y
  tripoints(x, 3) = tx
  tripoints(x, 4) = ty
  tripoints(x, 5) = tx
  tripoints(x, 6) = ty
  y = y + yi
  tx = tx + txi
  ty = ty + tyi
 NEXT x
ELSE
 IF x3 - x1 <> 0 THEN
  yi = (y1 - y3) / (x3 - x1)
  txi = (tx3 - tx1) / (x3 - x1)
  tyi = (ty3 - ty1) / (x3 - x1)
 ELSE
  yi = 1
  txi = 1
  tyi = 1
 END IF
 y = y1
 tx = tx1
 ty = ty1
 FOR x = x1 TO x3
  tripoints(x, 0) = -1
  tripoints(x, 1) = y
  tripoints(x, 2) = y
  tripoints(x, 3) = tx
  tripoints(x, 4) = ty
  tripoints(x, 5) = tx
  tripoints(x, 6) = ty
  y = y - yi
  tx = tx + txi
  ty = ty + tyi
 NEXT x
END IF
IF x2 <> x1 THEN
 yi = (y2 - y1) / (x2 - x1)
 txi = (tx2 - tx1) / (x2 - x1)
 tyi = (ty2 - ty1) / (x2 - x1)
END IF
y = y1
tx = tx1
ty = ty1
FOR x = x1 TO x2
 IF y > tripoints(x, 1) THEN
  tripoints(x, 2) = y
  tripoints(x, 5) = tx
  tripoints(x, 6) = ty
 ELSE
  tripoints(x, 1) = y
  tripoints(x, 3) = tx
  tripoints(x, 4) = ty
 END IF
 y = y + yi
 tx = tx + txi
 ty = ty + tyi
NEXT x
IF x3 <> x2 THEN
 yi = (y3 - y2) / (x3 - x2)
 txi = (tx3 - tx2) / (x3 - x2)
 tyi = (ty3 - ty2) / (x3 - x2)
END IF
y = y2
tx = tx2
ty = ty2
FOR x = x2 TO x3
 IF y > tripoints(x, 1) THEN
  tripoints(x, 2) = y
  tripoints(x, 5) = tx
  tripoints(x, 6) = ty
 ELSE
  tripoints(x, 1) = y
  tripoints(x, 3) = tx
  tripoints(x, 4) = ty
 END IF
 y = y + yi
 tx = tx + txi
 ty = ty + tyi
NEXT x
FOR x = 0 TO 319
 IF tripoints(x, 0) THEN
  tx1 = tripoints(x, 3)
  ty1 = tripoints(x, 4)
  tx2 = tripoints(x, 5)
  ty2 = tripoints(x, 6)
  y1 = tripoints(x, 1)
  y2 = tripoints(x, 2)
 CALL spanmap(tx1, ty1, tx2, ty2, x, y1, y2)
 END IF
NEXT x
END SUB

