COMMON SHARED xo AS INTEGER, yo AS INTEGER
COMMON SHARED xo1 AS INTEGER, yo1 AS INTEGER
COMMON SHARED x AS INTEGER, y AS INTEGER, c AS INTEGER

RANDOMIZE TIMER

'This is the alpha-buffer that contains the image of the blob
DIM dotz(15, 15) AS INTEGER

'set screen mode
SCREEN 13

'initialize palette
FOR p = 0 TO 63
OUT &H3C8, p
OUT &H3C9, 0
OUT &H3C9, p
OUT &H3C9, 0
NEXT p

'Initialize blob
'Uses distance formula & floating point, but small enough to not matter
FOR y = 1 TO 15
FOR x = 1 TO 15
dotz(x, y) = 63 - (ABS((((x - 7) ^ 2) + ((y - 7) ^ 2)) ^ .5) * 8)
IF dotz(x, y) < 0 THEN dotz(x, y) = 0
NEXT x, y

'Make end text visible
COLOR 63

'Initialize blob locations
xo = 151
yo = 91
xo1 = 230
yo1 = 30

'Clear background to neutral, middle blue
LINE (0, 0)-(319, 199), 31, BF

'Begin main loop
DO

'Update position
xo = xo + FIX(RND * 10 - 5)
yo = yo + FIX(RND * 10 - 5)
xo1 = xo1 + FIX(RND * 10 - 5)
yo1 = yo1 + FIX(RND * 10 - 5)

'Attractiveness factor
'Light blob 'attacks' dark blob - ultracool
IF xo < xo1 THEN xo = xo + .55
IF xo > xo1 THEN xo = xo - .55
IF yo < yo1 THEN yo = yo + .55
IF yo > yo1 THEN yo = yo - .55

'Check boundaries. If outside clip box, wrap.
IF xo < 0 THEN xo = 304
IF xo1 < 0 THEN xo1 = 304
IF yo < 0 THEN yo = 176
IF yo1 < 0 THEN yo1 = 176
IF xo > 304 THEN xo = 0
IF xo1 > 304 THEN xo1 = 0
IF yo > 176 THEN yo = 0
IF yo1 > 176 THEN yo1 = 0

'Flicker-free update - - - :)
WAIT &H3DA, 8

'Draw the first dot (light)
FOR y = 1 TO 15
FOR x = 1 TO 15
c = dotz(x, y) + POINT(x + xo, y + yo)
IF c > 63 THEN c = 63
PSET (xo + x, yo + y), c
NEXT x, y

'Draw the second dot (Dark)
FOR y = 1 TO 15
FOR x = 1 TO 15
c = POINT(x + xo1, y + yo1) - dotz(x, y)
IF c < 0 THEN c = 0
PSET (xo1 + x, yo1 + y), c
NEXT x, y

LOOP UNTIL INKEY$ = CHR$(27)

