'*******************************************************************
''''
'''' How to use Acid Works Draw files
''''
''''by Acid Works Software, Steve Nunnally
''''
'*******************************************************************
''''
''''  Go to each sub for an explanation on what variables are needed
'''' to be passed in for the sub to work properly
''''
DECLARE SUB PalLoad (palname$)
DECLARE SUB LoadPic (nfile$, darray() AS INTEGER)
DECLARE SUB FindBytes (nfile$, BytesNeeded%)
DEFINT A-Z: SCREEN 13

''''
'''' Loading a palette file
''''Ex:

 CALL PalLoad("awdraw.pal")


''''
'''' Loading a picture   NOTE: You must first call FindBytes to find
''''                           out how big the array must be dimensioned
''''                           to.
''''Ex:

 CALL FindBytes("example.awd", BytesNeeded)
 DIM pic(BytesNeeded)
 CALL LoadPic("example.awd", pic())

''''
'''' To put it somewhere just do this:
''''
 '''x is the over position, y is the up position on the screen

 x = 1
 y = 1

 PUT (x, y), pic, XOR

''''
'''' The following is just to show how fast this is, you dont need it in
'''' your program  :)
''''

FOR g = 1 TO 150 STEP 50
 FOR i = 1 TO 250 STEP 50
  PUT (i, g), pic, PSET
NEXT i, g

'*************************************************************************
' nfile$      - file to load from
' BytesNeeded - once bytes needed is calcualted it is stored in
'               this variable
'*************************************************************************
SUB FindBytes (nfile$, BytesNeeded)

 ff = FREEFILE
 OPEN nfile$ FOR BINARY AS ff
  GET ff, , xx: GET ff, , yy
 CLOSE ff
 BytesNeeded = (xx * yy * .55)

END SUB

'*************************************************************************
' nfile$ - file to load from
' darray - array to load into
'*************************************************************************
SUB LoadPic (nfile$, darray() AS INTEGER)

 ff = FREEFILE
 OPEN nfile$ FOR BINARY AS ff
  GET ff, , xx: GET ff, , yy
  lb = LBOUND(darray)
  DEF SEG = VARSEG(darray(lb))
  ptr& = VARPTR(darray(lb))
  pline$ = SPACE$((xx * yy) + 4)
  GET ff, , pline$
  FOR aa = 1 TO ((xx * yy) + 4)
   pl = ASC(MID$(pline$, aa, 1))
   POKE ptr&, pl
   ptr& = ptr& + 1
  NEXT aa
 CLOSE ff
 DEF SEG

END SUB

'*************************************************************************
' palname$ - Name of the palette file to load
'*************************************************************************
SUB PalLoad (palname$)

 Bc$ = " ": ff = FREEFILE
 OPEN palname$ FOR BINARY AS ff
  FOR i% = 0 TO 255
   OUT &H3C8, i%
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
  NEXT i%
 CLOSE ff

END SUB

