#!/usr/bin/perl
#
#
# instpd.pl - generate an article for every file in a given archive.
#	      the article is build for a seleced newsgroup and it contains
#             a description, taken from a 4dos-like descript.ion file.
#
# modification log:
#	28-Apr-93 - juergen waibel - original
#
#
#------------- variables to be used -----------------------------------------
#
$NEWSCMD="/usr/local/lib/news/inews -h"; 	# command to use
$DESCRIPTION="descript.ion";			# name of the description file
$TEMPFILE="/home/bbs/article.tmp";		# name of temp. article File
#
#------------- get the given parameters -------------------------------------
#
$NEWSGROUP = $ARGV[0];				# newsgroup
$ARCHIVE = $ARGV[1];				# pd-archive
#
#----------------------------------------------------------------------------
# read in the file of filenames and relate the decsriptions to them.
# the format is like 4dos's
#
open (STDIN,$DESCRIPTION) || die "cannot open stdin $DESCRIPTION: $!\n";
while ( <STDIN> ) {
	chop;
	next unless /^[a-zA-Z0-9_]/;
	($name,$description) = split(' ',$_,2);
	$description{$name} = $description;
}
close (STDIN);

chdir $ARCHIVE || die "Can't cd to $ARCHIVE: $!\n";

#-------------- get the list of files in the directory ----------------------

opendir(DIR, '.') || die "Can't open $dir";
local(@filenames) = readdir(DIR);
closedir(DIR);

#-------------- process all files in directory ------------------------------

for (@filenames) {
    next if $_ eq '.';
    next if $_ eq '..';
    $name = "$_";
    ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
        $attime,$mtime,$ctime,$blksize,$blocks) = stat($name);

    #---------- find the owner of the file 
    ($user) = getpwuid($uid);

    #---------- set a description text if none exists
    if ($description{$name} eq "") { $description{$name} = "(NO DESCRIPTION AVAILABLE)";}

    #---------- make me feel better it's doing *something*
    select(stderr) ; printf("%20s\r",$name) ; select(stdout);
	
    $pathname = $ARCHIVE."/".$name;

    # --------- create temp. file for article    
    open (TMP,">$TEMPFILE") || die "cannot open stdout $TEMPFILE: $!\n";
    write(TMP);
    close(TMP);

    # --------- start newscommand to build article
    system ("$NEWSCMD < $TEMPFILE");
}
#----------------------------------------------------------------------------

format TMP =
Newsgroups: @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	    $NEWSGROUP
From: @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
      $user
Subject: @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
         $name
Keywords: @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
          $description{$name}
Distribution: local

BINFILE
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$pathname
.
