/* ix/MBox/WENDY (block.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #BS block_set()           mark a block of text
   #BW block_ctrlw()         save a block
   #BA block_ctrlu()         put RTF to a block		
   #BD block_ctrly()         erase a block

   Contact <volkers@unnet.wupper.de> for help! */










#include "wendy.h"


/* #BS - Mark a block of text */

block_set()
{
  int xa, ya;

  if((BLOCK.status == 0) || (BLOCK.status == BLOCKMODE)){
	BLOCK.status = 1;
	BLOCK.x1     = x;
	BLOCK.y1     = (ypos + y) -1;
	BLOCK.ypos   = ypos;
	BLOCK.y	     = y;
#ifdef _LOCAL
	show_status( " WENDY: Blockanfang markiert. " );
#else
	show_status( " WENDY: Begin of block marked. " );
#endif
  }
  else{
	if(BLOCK.status == 1){
		BLOCK.status = BLOCKMODE;
		BLOCK.x2 = x;
		BLOCK.y2 = (ypos + y) -1;

		if((BLOCK.y1 == BLOCK.y2) && (BLOCK.x1 == BLOCK.x2)){
			printf("%c", 7);
#ifdef _LOCAL
			show_status( " WENDY: Hae? " );
#else		
			show_status( " WENDY: So what? ");
#endif
			BLOCK.status = 0;
		}
		else{
			if(BLOCK.y1 > BLOCK.y2){
				ya = BLOCK.y1;
				xa = BLOCK.x1;
				BLOCK.y1 = BLOCK.y2;
				BLOCK.x1 = BLOCK.x2;
				BLOCK.y2 = ya;
				BLOCK.x2 = xa;
			}

			if(BLOCK.y1 == BLOCK.y2){
				if(BLOCK.x1 > BLOCK.x2){
					xa = BLOCK.x1;
					BLOCK.x1 = BLOCK.x2;
					BLOCK.x2 = xa;
				}
			}
#ifdef _LOCAL
			show_status( " WENDY: Blockende markiert. " );
#else
			show_status( " WENDY: End of block marked. ");
#endif
		}
		show_screen( START );
	}
  }
  activate( RTF_attrib );
  ansi2( "cm", x, y );
}



/* #BW - Save a block */

block_ctrlw()
{
  FILE *fp;
  unsigned char s[LONGSTRING];
  unsigned char a[LONGSTRING];  
  unsigned char p[STRING];
  int i;
  int o = BLOCK.y1;

#ifdef _LOCAL
  show_status( " WENDY: Block sichern. Dateiname? " );
#else
  show_status( " WENDY: Save block. Filename? " );
#endif
  ansi( "mr", 0, 0 );
  strcpy(p, (unsigned char *) getline( 20, 1, ' ', "" ));

  fp = fopen( p, "w" );
  if(fp == NULL){
	printf("%c", 7);
#ifdef _LOCAL
	sprintf(s, " WENDY: Fehler <%d>! ", p);
#else
	sprintf(s, " WENDY: Error <%d>! ", p);
#endif
	show_screen( s );
	return;
  }

  rtf_convert( TEXT[o], 1, o);
  strcpy(s, (unsigned char *) strcopy(SCREEN[1], (BLOCK.x1 -1), MAXX));
  strcpy(a, (unsigned char *) strcopy(ATTRIB[1], (BLOCK.x1 -1), MAXX));
  if(BLOCK.y1 == BLOCK.y2){
	s[(BLOCK.x2 - BLOCK.x1 + 1)] = '\0';
	a[(BLOCK.x2 - BLOCK.x1 + 1)] = '\0';
  }

  fprintf(fp, "%s\n", (unsigned char *) make_rtf( s, a ));
  o++;

  if(BLOCK.y1 == BLOCK.y2) goto NOTAUSGANG;

  if((BLOCK.y2 - BLOCK.y1) > 1){ 
	do{
		fprintf(fp, "%s\n", (unsigned char *) TEXT[o]);
		o++;
	}while(o < BLOCK.y2); 
  }

  rtf_convert( TEXT[o], 1, o);
  strcpy(s, (unsigned char *) strcopy(SCREEN[1], 0, (BLOCK.x2 -1)));
  strcpy(a, (unsigned char *) strcopy(ATTRIB[1], 0, (BLOCK.x2 -1)));
  fprintf(fp, "%s\n", (unsigned char *) make_rtf( s, a ));

  NOTAUSGANG:

  fclose(fp);

  BLOCK.status = 0;

  activate( RTF_attrib );
  ansi2( "cm", x, y );  
}



/* #BA - Put RTF to a block */	

block_ctrlu()
{
  int i;
  int o = BLOCK.y1;
  int ymem = y;

  restore_screen( ypos );

  rtf_convert( TEXT[o], 1, o );
  y = 1;

  if(BLOCK.y1 == BLOCK.y2){
	for(i = (BLOCK.x1 -1); i <= (BLOCK.x2 -1); i++){
		ATTRIB[1][i] = RTF_attrib;
	}
  }
  else{
	for(i = (BLOCK.x1 -1); i <= MAXX; i++){
		ATTRIB[1][i] = RTF_attrib;
	}
  }
  if(FORMATTER == 'b') blockset();
  strcpy(TEXT[o], (unsigned char *) make_rtf( SCREEN[1], ATTRIB[1] ));
  if(FORMATTER == 'c') FLAG[o] |= is_centered;
  if(BLOCK.y1 == BLOCK.y2) goto NOTAUSGANG;
  o++;

  if((BLOCK.y2 - BLOCK.y1) > 1){
	do{
		rtf_convert( TEXT[o], 1, o );
		memset(ATTRIB[1], RTF_attrib, MAXX);
		if(FORMATTER == 'b') blockset();
		strcpy(TEXT[o], (unsigned char *) make_rtf( SCREEN[1], ATTRIB[1] ));
		if(FORMATTER == 'c') FLAG[o] |= is_centered;
		o++;
	}while(o < BLOCK.y2); 
  }
  rtf_convert( TEXT[o], 1, o );
  
  for(i = 0; i <= (BLOCK.x2 -1); i++){
	ATTRIB[1][i] = RTF_attrib;
  }
  if(FORMATTER == 'b') blockset();
  strcpy(TEXT[o], (unsigned char *) make_rtf( SCREEN[1], ATTRIB[1] ));
  if(FORMATTER == 'c') FLAG[o] |= is_centered;

  NOTAUSGANG:

  BLOCK.status = 0;

  prep_screen( ypos );
  show_screen( START );
  y = ymem;
  ansi2( "cm", x, y );  
}


/* #BD - Erase a block */

block_ctrly()
{
  int i;
  int start = BLOCK.y1 + 1;
  int diff  = BLOCK.y2 - BLOCK.y1; /* + 1 */
  int dummy;

  unsigned char s[LONGSTRING];
  unsigned char a[LONGSTRING];

  restore_screen( ypos );

  if(BLOCK.y1 == BLOCK.y2){
	dummy = MAXX - (BLOCK.x2 - BLOCK.x1);
	for(i = 0; i < dummy; i++){
		SCREEN[y][(BLOCK.x1 + i - 1)] = SCREEN[y][(BLOCK.x2 + i)];
		ATTRIB[y][(BLOCK.x1 + i - 1)] = ATTRIB[y][(BLOCK.x2 + i)];
	}       
	diff = i + 1;
	for(i = diff; i < MAXX; i++){
		SCREEN[y][i] = ' ';
		ATTRIB[y][i] = '0';
	}	
	strcpy(TEXT[(ypos + y - 1)], (unsigned char *) make_rtf( SCREEN[y], ATTRIB[y] ));
	goto NOTAUSGANG;
  }

  SCREEN[BLOCK.y1][(BLOCK.x1 - 1)] = '\0';
  ATTRIB[BLOCK.y1][(BLOCK.x1 - 1)] = '\0';

  rtf_convert( TEXT[BLOCK.y2], 26, BLOCK.y2 );  

  strcpy(s, (unsigned char *) SCREEN[BLOCK.y1]);
  strcpy(a, (unsigned char *) ATTRIB[BLOCK.y1]);

  strcat(s, (unsigned char *) strcopy(SCREEN[26], BLOCK.x2, MAXX));
  strcat(a, (unsigned char *) strcopy(ATTRIB[26], BLOCK.x2, MAXX));

  strcpy(TEXT[BLOCK.y1], (unsigned char *) make_rtf( s, a ));  

  for(i = start; i <= lastline; i++){
	strcpy(TEXT[i], (unsigned char *) TEXT[(i + diff)]);
  	FLAG[i] = FLAG[(i + diff)];
  } 
  lastline -= diff;

  lastline++; /* ??? */

  NOTAUSGANG:

  BLOCK.status = 0;
  ypos = BLOCK.ypos;
  x = BLOCK.x1;
  y = BLOCK.y;

  prep_screen( ypos );
  show_screen( START );
  ansi2( "cm", x, y );  
}
