/* ix/MBox (subscribe.c) by Volker Schuermann, 09.04.1994

   This C source code contains the following functions:

   #IS is_subscribed()    check if user has subscribed to a newsgroup
   #SB subscribe()        (un-) subscribe to newsgroups
   #GL gloom()		  compile a "weather report"
   #MN menue()		  fake a FIDO style bbs

   Contact <volkers@unnet.wupper.de> for help! */










#include <stdio.h>

#include "mbox.h"


/* #IS - Check if users subscribed to a newsgroup [s].

   This function returns 1 if the user has subscribed to the group, or
   0 otherwise. */

int is_subscribed( s )
UNSIGNED char s[];
{
  FILE *subfp;

  UNSIGNED char t[STRING];
  int is = 0;

  sprintf(t, "%s/usr/%c/%d/.subscribe", HOME, USER.name[0], USER.id);
  subfp = fopen( t, "r" );
  if(subfp == NULL){
	return (int) 1;		/* 1 is correct !!! */
  }
  while((fgets(t, STRING, subfp) != NULL) && (is == 0)){
	if(strcomp(s, t) == 0) is = 1;
  }
  fclose(subfp);

  return (int) is;
}


/* #SB - (Un-) subscribe to newsgroups. */

void subscribe()
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char tmp[STRING];

  UNSIGNED char g[45][STRING];

  int a, b, c, i = 0, p = 1;
  int OK = 1;
  int SKIP = 0;

  int help_shown = 0;

  int m[45];


  if(USER.tlines > 45){
	nerror("subscribe.c", 57, "subscribe", "Terminal made up with more than", "45 lines ???");
  }


  sprintf(s, " %s %d] ", SUB01_MSG, p);
  headline( s );


  sprintf(tmp, "%s/subscribe.%d", TMP, getpid() );
  ff = fopen(tmp, "w");
  if(ff == NULL){
	nerror("subscribe.c", 68, "subscribe", "Can't write to", tmp);
  }

  fp = fopen( NGROUPS, "r" );
  if(fp == NULL){
	nerror("subscribe.c", 73, "subscribe", "Can't read", NGROUPS);
  }

  while(OK == 1){
	if(fscanf(fp, "%s %d %d %s", s, &a, &b, t) <= 0){
	        OK--;
	}
	else{
	        if(chk_newsgrp( s ) != -1){

	                strcpy(g[(i+1)], (UNSIGNED char *) s);
	                if(is_subscribed( s )){
	                        if(!SKIP){
					if((i + 'A') <= 'Z')
						printf("-> %c  %-40s  %d\n", (i + 'A'), s, (a -b));
					else
						printf("-> %c  %-40s  %d\n", (i + 'A' + 6), s, (a -b));
				}
	                        m[(i+1)] = 1;
	                }
	                else{
				if(!SKIP){
					if((i + 'A') <= 'Z')
					  	printf("   %c  %-40s  %d\n", (i + 'A'), s, (a -b));
					else
						
					  	printf("   %c  %-40s  %d\n", (i + 'A' + 6), s, (a -b));
				}
	                        m[(i+1)] = 0;
	                }
	                i++;
	        }
	}

	if((i == (USER.tlines -1)) || (OK != 1)){
		if(!SKIP){
		        printf("\n");
		        ansi2( "mr", 0, 0 );
		        printf("[A-%c, !, *] (?) > ", (i + 'A' -1));
		        ansi2( "me", 0, 0 );
		        c = 0;
		        while(c != ' '){
		                c = getint();
	        	        if(help_shown == 1){
					clearline();
					ansi2( "mr", 0, 0 );
			                    printf("[A-%c, !, *] (?) > ", (i + 'A' -1));
	                	        ansi2( "me", 0, 0 );
		                        help_shown = 0;
		                }
		                if(c == '?'){
		                        clearline();
		                        ansi2( "mr", 0, 0 );
		                        printf("%s > ", SUB02_MSG);
		                        ansi2( "me", 0, 0 );
		                        help_shown = 1;
		                }
		                if(c == '*'){
		                        sprintf(s, "%s/usr/%c/%d/.subscribe", HOME, USER.name[0], USER.id);
		                        unlink(s);
		                        ansi2( "cm", 20, (i + 3) );
		                        printf(" %s ", SUB06_MSG);
					sleep(1);
		                        OK = 99;
		                        c = ' ';
		                }
				if(c == '!'){	
					printf(" %s ", SUB06aMSG);
					sleep(1);
					SKIP = 1;
					c = ' ';
				}
				if(USER.tlines > 40){
					if(c > 'Z') c -= 6;
				}
				else{
					if(c >  96) c -= 96;
				}
		                if(c > 64) c -= 64;
		                if(c <= i){
					ansi2( "cm", 1, (c + 1) );
		                        ansi2( "md", 0, 0 );
		                        if(m[c] == 0){
		                                m[c] = 1;
		                                printf("->");
		                                ansi2( "cm", 20, (i + 3) );
		                                ansi2( "me", 0, 0 );
		                                printf(" %s <%s> %s           ", SUB03_MSG, g[c], SUB04_MSG );
		                        }

		                        else{
		                                m[c] = 0;
		                                printf("  ");
		                                ansi2( "cm", 20, (i + 3) );
		                                ansi2( "me", 0, 0 );
		                                printf(" %s <%s> %s            ", SUB03_MSG, g[c], SUB05_MSG );
		                        }
		                        ansi2( "cm", 19, (i + 3) );
		                }
		        }
		}
	        for(a = 1; a <= i; a++){
	                if(m[a] == 1) fprintf(ff, "%s\n", g[a]);
	        }
		fflush(ff);
		if((OK == 1) && (!SKIP)){
	                p++;
	                sprintf(s, " %s %d] ", SUB01_MSG, p);
	                headline( s );
	        }
		i = 0;		
	}
  }
  clearline();

  fclose(fp);
  fclose(ff);

  if(OK != 99){
	sprintf(s, "%s/usr/%c/%d/.subscribe", HOME, USER.name[0], USER.id);
	mbrename( tmp, s );
  }
  else{
	unlink( tmp );
  }

  init_user( SUB07_MSG, 1 );

  printf("\n");
}



/* #GL - compile a "weather report" */

void gloom()
{
  UNSIGNED char wet[17][STRING];
  UNSIGNED char tem[11][STRING];
  UNSIGNED char l[LONGSTRING];
  int c = srand( getpid() );		/* No comments needed! */
  int hit = (rand() % 15) + 1;
  int temp = (rand() % 10) + 1; 
  int i;
 
  FILE *fp;


 
  strcpy(wet[ 1], (UNSIGNED char *) "it was hot and dry all day");
  strcpy(wet[ 2], (UNSIGNED char *) "it has been sunny and mild");
  strcpy(wet[ 3], (UNSIGNED char *) "is was cloudy with sunny spells");
  strcpy(wet[ 4], (UNSIGNED char *) "the skies have been cloudy");
  strcpy(wet[ 5], (UNSIGNED char *) "the skies were overcast with showers");
  strcpy(wet[ 6], (UNSIGNED char *) "we had hail and thunder");
  strcpy(wet[ 7], (UNSIGNED char *) "we had torrential rain");
  strcpy(wet[ 8], (UNSIGNED char *) "it has been sunny all day");
  strcpy(wet[ 9], (UNSIGNED char *) "it was foggy and misty");
  strcpy(wet[10], (UNSIGNED char *) "it was misty and murky");
  strcpy(wet[11], (UNSIGNED char *) "we had gails and gusts");
  strcpy(wet[12], (UNSIGNED char *) "we had showery rain and snow");
  strcpy(wet[13], (UNSIGNED char *) "it was foggy with showers");
  strcpy(wet[14], (UNSIGNED char *) "we had clouds and high winds");
  strcpy(wet[15], (UNSIGNED char *) "it was freezing cold");
  strcpy(wet[16], (UNSIGNED char *) "it has had blizzard conditions");

  strcpy(tem[ 1], (UNSIGNED char *) "-25 C (-13 F)");
  strcpy(tem[ 2], (UNSIGNED char *) "-10 C (14 F)");
  strcpy(tem[ 3], (UNSIGNED char *) "5 C (41 F)");
  strcpy(tem[ 4], (UNSIGNED char *) "10 C (50 F)");
  strcpy(tem[ 5], (UNSIGNED char *) "15 C (60 F)");
  strcpy(tem[ 6], (UNSIGNED char *) "20 C (68 F)");
  strcpy(tem[ 7], (UNSIGNED char *) "25 C (75 F)");
  strcpy(tem[ 8], (UNSIGNED char *) "30 C (86 F)");
  strcpy(tem[ 9], (UNSIGNED char *) "35 C (95 F)");
  strcpy(tem[10], (UNSIGNED char *) "40 C (104 F)");

  do{
	headline( " Weather Report (MET Office) " );

	ansi2( "cm", 1, 6 );

  	for(i = 1; i <= 16; i++){
		printf("%c ... %s\n", (i + 64), wet[i]);
	}

	ansi2( "md", 0, 0 );

	for(i = 1; i <= 10; i++){
		ansi2( "cm", 48, (5 + i) );
		if(i < 3)
			printf("%d ... %s", (i - 1), tem[i]);
		if( i == 3)
			printf("%d ...   %s", (i - 1), tem[i]);
		if( i > 3)
			printf("%d ...  %s", (i - 1), tem[i]);
	}

	ansi2( "me", 0, 0 );

	sprintf(l, "This weather report has been compiled in %s, where %s. %s %s.", 
		    LOCATION, wet[hit],
		   "Daytime temperatures reached", tem[temp]);

	i = 78;
	while((l[i] != ' ') && (i > 0)) i--;
	l[i] = '\n';


	ansi2( "cm", 1, 3 );
	ansi2( "us", 0, 0 );
	printf("%s", l);
	ansi2( "me", 0, 0 );

	ansi2( "cm", 1, 23 );
	ansi2( "md", 0, 0 );
	printf("[A-P, 0-9] Und? > ");
  	ansi2( "me", 0, 0 );

	c = getch();

	if(c >= 97) c -= 32;


	if((c >= 'A') && (c <= 'P')) hit = (c - 64);

	if((c >= '0') && (c <= '9')) temp = (c - 47);
		
  }while((c != CR) && (c != LF));

  ansi2( "cm", 0, 22 ); 

  fp = fopen( WEATHER_REPORT, "w" );
  if(fp == NULL){
	nerror("subscribe.c", 321, "gloom", "Can't open", WEATHER_REPORT);
  }
  fputs("\n------------------------------------------------------------------------------\n", fp); 
  fputs(l, fp);
  fclose(fp);
}



UNSIGNED char *fido_befehl( no )
int no;
{
  static UNSIGNED char t[STRING];
  int i;

  t[0] = '\0'; i = 0;
  while((t[0] == '\0') && (BEF[i].id != -1)){
	if(BEF[i].id == no) strcpy(t, (UNSIGNED char *) BEF[i].befehl);
	i++;
  }

  return (UNSIGNED char *) t;
}




void fido_prompt( s )
UNSIGNED char s[];
{
  if(USER.terminal != ISO6429)
	ansi2("md", 0, 0);
  else
	ansi2("X4", 0, 0);
  printf("%s", s);
  ansi2("me", 0, 0);
  printf(" ");
}



UNSIGNED char *fido_areas()
{
  FILE *fp;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING]; 
  UNSIGNED char ae[MAX_AREACONT][STRING]; 

  int i, j, a, b;

  sprintf(t, "%s/etc/sigs+areas/list.areas", HOME);

  fp = fopen( t, "r" );
  if(fp == NULL){
	return;
  }

  headblock( " MENUE Steuerung ", "Auswahl einer AREA" );

  a = 0; b = 0; j = 1;

  while(fgets(s, STRING, fp) != 0){
	if(strcomp("AREA", s) == 0){
		strcpy(t, (UNSIGNED char *) strcopy(s, 5, strlen(s)));
		i = 1;
		while((t[i] != ' ') && (t[i] != '\0')) i++;
		t[i] = '\0';
		a++; b++;
		printf("%4d  %-20s", a, t);
		strcpy(ae[j], (UNSIGNED char *) t); j++;
		if(j > MAX_AREACONT) j--; /* ??????????? */
		if(b == 3){
			b = 0;
			printf("\n");
		}
	}
  }
  fclose(fp);

  printf("\n\n");
  fido_prompt( SUB11_MSG );

  strcpy(t, (UNSIGNED char *) getline( 5, 100, ' ', "") );
  a = atoi(t); if(a < 1) a = 1; if(a > j) a = j-1;

  return (UNSIGNED char *) ae[a];
}


 


UNSIGNED char *fido_echos( mode )
char mode;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[3][STRING];
  UNSIGNED char d[STRING];
  UNSIGNED char f[STRING];

  FILE *fp, *ff;

  int i = 0, j = 0, a, b, stop = 0;

  if(mode != 'F')
	headblock( SUB08_MSG, SUB09_MSG ); 
  else
	headblock( SUB08_MSG, SUB10_MSG );
    
  sprintf(f, "%s/fido.%d", TMP, getpid());
  ff = fopen( f, "w" );

  fp = fopen( AGROUPS, "r" );
  if(fp == NULL){
  }
 
  t[0][0] = '\0'; t[1][0] = '\0'; t[2][0] = '\0';

  while (fscanf(fp, "%s %d %d", t[j], &a, &b) > 0) {
		t[j][18] = '\0';
		if(mode == 'F'){
			if((strcomp(PDNG, t[j]) == 0) && (strcomp(CDROM_DUMMY, t[j]) != 0)) j++;
		}
		else{
			if((strcomp(CDROMNG, t[j]) != 0) && (strcomp(ADULTNG, t[j]) != 0)) j++;
			if(USE_AREAS != 0){
				if(chk_area( t[j-1] ) != 1) j--;
				if(j < 0) j = 0;
			}
		}
		if(j == 3){
			fprintf(ff, "%4d  %-18.18s   %4d  %-18.18s   %4d  %-18.18s\n",
				i+1, t[0], i+2, t[1], i+3, t[2]);
			i += 3;	
			j = 0;
			t[0][0] = '\0'; t[1][0] = '\0'; t[2][0] = '\0';
		}	
  }

  for(a = 0; a < j; a++){
	fprintf(ff, "%4d  %-18.18s   ", ++i, t[a]);
  }
  fprintf(ff, "\n");

  fclose(fp);
  fclose(ff);

  show( f, 9999, USER.more + 100 );
 
  unlink( f ); 

  printf("\n");
  fido_prompt( SUB11_MSG );

  strcpy(d, (UNSIGNED char *) getline( 5, 100, ' ', "") );
  a = atoi(d); if(a < 1) a = 1;

  fp = fopen( AGROUPS, "r" );
  if(fp == NULL){
  }
  i = 0;
  while((stop == 0) && (fscanf(fp, "%s %d %d", s, &b, &b) > 0)){
	if(mode == 'F'){
		if((strcomp(PDNG, s) == 0) && (strcomp(CDROM_DUMMY, s) != 0)) i++;
	}
	else{
		if((strcomp(CDROMNG, s) != 0) && (strcomp(ADULTNG, s) != 0)) i++;
	}

	if(i == a) stop++;
  }
  fclose(fp);

  return (UNSIGNED char *) s;  
}



void fido_sysop()
{
  UNSIGNED char s[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char t[STRING];

  FILE *fp;
  FILE *ff;

  int c;

  long timer;


  sprintf(f, "%s/fido.%d", TMP, getpid());
  sprintf(s, "%s/bled %s", HOME, f);
  
  system( s );
  
  printf("\n\n%s\n\n", SUB12_MSG);

  sprintf(s, "[%s] %s?", NG, SUB13_MSG); 
  fido_prompt( s );

  do{
	  c = getint();
	  if(c >= 97) c -= 32;
  }while((c != SUB12aMSG) && (c != SUB12bMSG));

  printf("%c", c);

  if(c == 'S'){

	sprintf(t, "%s/fidosysop.%d", TMP, getpid());

	ff = fopen( t, "w" );

	c = 0; strcpy(s, (UNSIGNED char *) USER.name);
	while(s[c] != '\0'){
		if(s[c] == ' ') s[c] = '.';
		c++;
	}

	time(&timer);

	fprintf(ff, "From: %s@%s (%s)\n", s, UUCPID2, USER.name); 
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
	fprintf(ff, "To: %s\n", POSTMASTER);
	fprintf(ff, "Subject: Just another letter ...\n");
	fprintf(ff, "X-Mailer: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	
	fprintf(ff, "Message-Id: <%x.%d@%s>\n", timer, USER.id, UUCPID2);
	fputs("\n", ff);

	fp = fopen( f, "r" );

	while(fgets(s, STRING, fp) != 0) fputs(s, ff);
	fclose(fp);
	fclose(ff);

	sprintf(s, "/bin/sh ./etc/rmail.sh %s %s", t, POSTMASTER);
	system( s );

	unlink( f );
	unlink( t );
  }

  unlink(f);
}


void fido_help()
{
  UNSIGNED char s[STRING];
  
  int c;

 
  sprintf(s, "%s [%s]", SUB14_MSG, NG );
  headblock( SUB08_MSG, s ); 

  printf("\n%s\n", SUB15_MSG);
  printf("%s\n\n\n", SUB16_MSG);

  printf("%s\n\n", SUB18_MSG);
  printf("%s\n\n", SUB19_MSG);
  printf("%s\n\n\n", SUB20_MSG);
  printf("%s\n\n\n", SUB21_MSG);
  
  fido_prompt( SUB22_MSG );

  do{
	  c = getint();
	  if(c >= 97) c -= 32;
  }while((c !=SUB22dMSG) && (c != SUB22cMSG) && (c != SUB22bMSG) && (c != SUB22aMSG));

  switch(c){
	case SUB22aMSG :	sprintf(s, "exec cat ./src/languages/%s.asc", LANGUAGE);	
				break;	
	case SUB22bMSG :	sprintf(s, "exec %s ./src/languages/%s.asc", SX, LANGUAGE);
				break;
	case SUB22cMSG :	sprintf(s, "exec %s ./src/languages/%s.asc", SZ, LANGUAGE);
				break;
  }

  if(c != SUB22dMSG){
	printf("\n\n");
	system( s );
  }
}



/* #MN - Fake a FIDO style bbs for your newbies */

UNSIGNED char *fido_menue()
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  char c; 
  int i;


  if((strcomp(CDROMNG, NG) == 0) || (strcomp(ADULTNG, NG) == 0)){
	sprintf(s, "%s +", (UNSIGNED char *) fido_befehl( 460 ));
	return (UNSIGNED char *) s;
  }

  s[0] = '\0';

  if(MENUE_STAGE == 1){
	printf("\n");
	if((strcomp(PDNG, NG) != 0) && (strcomp(CDROMNG, NG) != 0))
		fido_prompt( SUB23_MSG );
	else
		fido_prompt( SUB24_MSG );
	strcpy(t, (UNSIGNED char *) getline( 8, 100, ' ', ""));
	sprintf(s, "%s %d", (UNSIGNED char *) fido_befehl( 210 ), atoi(t));
	MENUE_STAGE = 0; fido_fast = 9876;
	return (UNSIGNED char *) s;
  }

  if((fido_fast < 9000) && (fido_fast != 99)){ 
	printf("\n\n");
	ansi2( "mr", 0, 0);
	printf("                                                                               ");
	printf("%c%s", CR, SUB25_MSG);
	do{
		c = getint();
	}while((c != LF) && (c != CR));
	ansi2( "me", 0, 0 );
  }	 

  do{
	if(fido_fast != 99){

		sprintf(s, "%s: [%s]    %s: [%s]", SUB26_MSG, NG, MI209_MSG, AREA);
		headblock( SUB27_MSG, s); 
		printf("\n");

		printf("%s\n", SUB28_MSG);
		printf("%s\n", SUB29_MSG);
		printf("\n");
		printf("%s\n\n", SUB30_MSG);
		printf("%s\n", SUB31_MSG);

		printf("<%c> ", SUB32aMSG);
		ansi2("us", 0, 0 );
		printf("%s", SUB32_MSG);
		ansi2("me", 0, 0 );
		printf("%s\n", SUB33_MSG);
		printf("\n");

		printf("%s\n\n", SUB34_MSG);     

		printf("%s\n\n", SUB35_MSG);
	
		printf("%s\n", SUB36_MSG);
		printf("%s", SUB37_MSG);
		ansi2("md", 0, 0 );
		printf("%s", SUB38_MSG);
		ansi2("me", 0, 0 );
	        printf("%s\n\n", SUB39_MSG);

	}
	else{
		printf("%c", CR);
	}


	printf("\n"); ansi2( "mr", 0, 0 );

	switch(fido_msg){
		case 1 :	printf("%s", SUB40_MSG);
				break;
		case 2 : 	printf("%s", SUB41_MSG);
				break;
		case 3 :	printf("%s", SUB42_MSG);
				break;
		case 4 :	printf("%s", SUB43_MSG);
				break;
		case 5 :	printf("%s", SUB44_MSG);
				break;
		default:	printf("%s", SUB45_MSG);
	}

	ansi2( "me", 0, 0 ); printf("\n\n");

 
 	sprintf(s, "[%s] %s?", NG, SUB46_MSG); 
	fido_prompt( s );

	fido_fast = 0;

	c = getint();
	
	if(c >= 97) c -= 32;
	printf("%c", c);

	s[0] = '\0';
 	
	switch(c){
		case SUB28aMSG :	strcpy(t, (UNSIGNED char *) fido_echos( 'A' ));	
					sprintf(s, "%s %s", (UNSIGNED char *) fido_befehl( 150 ), t);
					fido_fast = 9877; fido_msg = 1;
					break;
		case SUB31aMSG :	strcpy(t, (UNSIGNED char *) fido_areas());	
					sprintf(s, "%s %s", (UNSIGNED char *) fido_befehl( 750 ), t);
					fido_fast = 9877; fido_msg = 1;
					break;
		case SUB29aMSG :	strcpy(t, (UNSIGNED char *) fido_echos( 'F' ));	
					sprintf(s, "%s %s", (UNSIGNED char *) fido_befehl( 150 ), t);
					fido_fast = 9877; fido_msg = 1;
					break;
		case SUB33aMSG : 	fido_help();
					break;
		case '+' :
		case '>' : 		sprintf(s, "%s +", (UNSIGNED char *) fido_befehl( 150 ));
					fido_fast = 99; fido_msg = 2;
					break;
		case '-' :
		case '<' :		sprintf(s, "%s -", (UNSIGNED char *) fido_befehl( 150 ));
					fido_fast = 99; fido_msg = 2;
					break;
		case SUB30aMSG :	sprintf(s, "%s *", (UNSIGNED char *) fido_befehl( 200 ));
					MENUE_STAGE = 1; fido_msg = 3;
					break;
		case 'L' :		printf("%c", CR);	
					fido_prompt( SUB23_MSG );
					strcpy(t, (UNSIGNED char *) getline( 8, 100, ' ', ""));
					sprintf(s, "%s %d", (UNSIGNED char *) fido_befehl( 210 ), atoi(t));
					fido_fast = 9876;
					break; 
		case SUB32aMSG :	strcpy(s, (UNSIGNED char *) fido_befehl( 690 ));
					fido_fast = 9876; fido_msg = 5;
					break;
		case SUB35aMSG :	strcpy(s, (UNSIGNED char *) fido_befehl( 260 ));
					break;
		case SUB34aMSG : 	strcpy(s, (UNSIGNED char *) fido_befehl( 250 ));
					fido_fast = 9876;
					break;
		case SUB34bMSG :	fido_sysop();
					fido_fast = 9876;
					break;
		case '1' :	 	strcpy(s, (UNSIGNED char *) fido_befehl( 170 ));
					fido_msg = 4;
					break;
		case '4' :		strcpy(s, (UNSIGNED char *) fido_befehl( 280 ));
					fido_fast = 9876;
					fido_msg = 4;
					break;
		case '%' :		strcpy(s, (UNSIGNED char *) fido_befehl( 380 ));
					break;
		case '0' :
		case '=' : 		MENUE_USING = 0;
					strcpy(s, (UNSIGNED char *) "?");
					break;
		case '!' : 		strcpy(s, (UNSIGNED char *) fido_befehl( 180 ));
					break;
		case '*' :		fido_msg = 3;
					break;
		case '"' :		printf("%s\n", SUB47_MSG);
					break;
	}

  }while(s[0] == '\0');

  return (UNSIGNED char *) s;
}


void adm_updated( id )
int id;
{
  FILE *fp;

  UNSIGNED char s[STRING];

  sprintf(s, "%s/updated.%d", TMP, id);
  fp = fopen( s, "w" );
  fprintf(fp, ";-)");
  fclose(fp);
}

void recently_updated()
{
  FILE *fp;

  UNSIGNED char s[STRING];
  
  sprintf(s, "%s/updated.%d", TMP, USER.id);
  fp = fopen( s, "r" );
  if(fp != NULL){
 	fclose(fp);
	printf("\n");
	init_user( SUB17_MSG, 1 );
	printf("\n");
	unlink( s );
  }
}


void moan()
{
  UNSIGNED char s[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char t[STRING];

  FILE *fp;
  FILE *ff;

  int c;

  long timer;


  sprintf(f, "%s/fido.%d", TMP, getpid());
  sprintf(s, "%s/bled %s", HOME, f);
  system( s );


  ansi2( "mr", 0, 0 );
  printf("%s ", SUB12cMSG);
  ansi2( "me", 0, 0 );

  do{
	c = getint();
	if(c >= 97) c -= 32;
  }while((c != SUB12aMSG) && (c != SUB12bMSG));

  printf("%c\n", c);

  if(c == 'S'){

	sprintf(t, "%s/fidosysop.%d", TMP, getpid());

	ff = fopen( t, "w" );

	c = 0; strcpy(s, (UNSIGNED char *) USER.name);
	while(s[c] != '\0'){
		if(s[c] == ' ') s[c] = '.';
		c++;
	}

	time(&timer);

	fprintf(ff, "From: %s@%s (%s)\n", s, UUCPID2, USER.name); 
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
	fprintf(ff, "To: %s\n", POSTMASTER);
	fprintf(ff, "Subject: Just another letter ...\n");
	fprintf(ff, "X-Mailer: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	
	fprintf(ff, "Message-Id: <%x.%d@%s>\n", timer, USER.id, UUCPID2);
	fputs("\n", ff);

	fp = fopen( f, "r" );

	while(fgets(s, STRING, fp) != 0) fputs(s, ff);
	fclose(fp);
	fclose(ff);

	sprintf(s, "/bin/sh ./etc/rmail.sh %s %s", t, POSTMASTER);
	system( s );

	unlink( f );
	unlink( t );
  }

  unlink(f);
}
