[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module add_topic;

[global] 
procedure add_topic;

{Manager is queried for a topic name.  If the name is unique it is added
 to the current category of topics.  The Bulletin Board manager must then 
 run the PROTECTION_CHANGER program.  This module can also be invoked to
 change the description or internet address of an existing topic by enter-
 ing an existing topic name and following the program prompts.  If a new
 topic is added, or an existing topic is changed, the topic list will be
 updated on the user's terminal}

var i, j : integer;

begin
  with current_record do
    begin
      t_menu := false;   {Flag to govern whether topic menu box is present}
      adjust := false;   {Will be set to true if changes are made to data base.}

      repeat

        {Query for topic name and convert to upper case.  If a carriage return
         is entered, user is returned to the topic menu.}
        write_menu('','Topic name <CR> (1-16 characters): ');
        readstr(line);

        smg$unpaste_virtual_display(error_display,pasteboard);

        i := length(line);
        if ((i <> 0) and (line <> key_exit)) then
          begin
            if (i > topic_length) then
              topic := substr(line,1,topic_length)
            else
              topic := line;
            for j := 1 to i do  
              {Convert to upper case routine.}
              if (topic[j] in ['a'..'z']) then 
                topic[j] := chr(ord(topic[j]) - 32);

            {Make sure the new topic is unique to this category.  If so
             query for description and internet address and store in
             current_record.  It is possible for these fields to be blank.}
            findk(bbfile,0,null_date+topic,eql,error:=continue);

            if ufb(bbfile) then
              begin

                write_menu('','Description <CR> : ');
                readstr(line);
                if (length(line) > subject_length) then
                  subject := substr(line,1,subject_length)
                else
                  subject := line;

                write_menu('','Internet address <CR> : ');
                readstr(line);
                if (length(line) > username_length) then
                  poster := substr(line,1,username_length)
                else
                  poster := line;
                write_menu('','Adding topic to bulletin board...');

                date := null_date;
                data := topic;
                continuation := false;

                {Put topic record into database for this topic}
                open(bbwrtfile,file_location+chosen_file,history:=old,
                     access_method:=keyed,organization:=indexed,
                     sharing:=readwrite,error:=continue);

                if (status(bbwrtfile) > 0) then
                  write_error('Unable to write to database.');
                write(bbwrtfile,current_record,error:=continue);

                if (status(bbwrtfile) = 0) then
                  adjust := true;  {File has new record written.}

                close(bbwrtfile,error:=continue);
              end
            else
              begin
                {Topic was not unique.  It is possible at this point to
                 change the description and/or the internet address of
                 this topic}
                write_error('Topic already exists.');

                write_menu('','New Description | <CR> no change : ');
                readstr(line);
                if (length(line) > 0) then
                  if (length(line) > subject_length) then
                    subject := substr(line,1,subject_length)
                  else
                    subject := line
                else
                    subject := bbfile^.subject;

                write_menu('','New address | <CR> no change : ');
                readstr(line);
                if (length(line) > 0) then
                  if (length(line) > username_length) then
                    poster := substr(line,1,username_length)
                  else
                    poster := line
                else
                  poster := bbfile^.poster;

                open(bbwrtfile,file_location+chosen_file,history:=old,
                     access_method:=keyed,organization:=indexed,
                     sharing:=readwrite,error:=continue);

                if (status(bbwrtfile) > 0 ) then
                  write_error('Unable to write to database.')
                else
                  begin
                    findk(bbwrtfile,0,null_date+topic,eql,error:=continue);
                    if not ufb(bbwrtfile) then
                      begin
                        bbwrtfile^.subject := subject;
                        bbwrtfile^.poster := poster;
                        bbwrtfile^.date := null_date;
                        bbwrtfile^.data := topic;
                        bbwrtfile^.continuation := false;
                        write_menu('','Making changes to topic in bulletin board...');
                        update(bbwrtfile,error:=message);
                        if (status(bbwrtfile) = 0) then
                          adjust := true;  {Data base file was altered.}
                      end;
                  end;

                close(bbwrtfile,error:=continue);
              end;
          end;
      until (length(line) = 0) or (line = key_exit);
    end;
end;

end.
