$! This command file is run in the mail storage areas daily to
$! attempt to add the bulletin board messages that were not
$! able to be added by the 3a.m. ARPA3 run.  The procedure is run
$! in an interactive fashion and each message can be edited
$! to make it compatible with the bulletin board, sent to
$! someone else or discarded.  The bulletin board manager will
$! have to make decisions on each message to determine the 
$! disposition of the files.  Messages that were not added to
$! the bulletin board in the a.m. run are stored in the 
$! area under the filename BB$BAD_MAIL.TXT.  As the files are
$! added, sent on or deleted, they are also removed from the
$! mail storage area.
$!
$!
$ SAVE_MODE = F$VERIFY(0)
$!
$!
$!	Developed by Charles E. Brown, RCD, Code 2811.12
$!	dua104:[brown3.com]programmer.com
$!
$! Comments added 19 November, 1987 by Alta M. Paul
$!
$ SET NOCONTROL=Y        !sets up the initial table and conditions
$ OPTION_TABLE = "3BYE4READ6DELETE4EDIT4FAST4MAIL4HELP" 
$ MISTAKES = 0
$ INTRO:
$ RETURNER = "NEXTO"
$ HELPO:
$	MISTAKES = 0
$ CLS
$ TYPE SYS$INPUT
		Bulletin Board Mail Adder

	The commands that you can enter are :

        BYE             Quits the session
        DELETE          Deletes the highest version of BB$BAD_MAIL.TXT
        EDIT            Edit the highest version of BB$BAD_MAIL.TXT
        READ            Reads the highest version of BB$BAD_MAIL.TXT
        FAST            Deletes and reads then next BB$BAD_MAIL.TXT
        MAIL            Vax mail
        HELP            This screen is the help screen

        Type in first letter of command only.
$ GOTO 'RETURNER'
$ INTERUPT_TRY:    !this section traps keyboard interrupts
$ CLS
$ TYPE SYS$INPUT



			*** Must use QUIT to exit assistant ***
			*** or BYE to leave and logout      ***


$	WAIT 00:00:00.45
$ 	MISTAKES = MISTAKES + 1
$	IF MISTAKES .EQ. 3 THEN GOTO HELPO
$	GOTO NEXTO	
$ NEXTO:           !prints a prompt line for next action
$	ON CONTROL_Y THEN GOTO INTERUPT_TRY
$	SET CONTROL=Y
$ 	ON WARNING THEN GOTO NEXTO
$	INQUIRE/nopuncuation COMMAND "Action : Read,Delete,Edit,Bye,Fast,Mail,Help > "
$	IF COMMAND .EQS. "" THEN GOTO NEEDACTION
$	GOTO GETSIZE
$ NEEDACTION:              !prompt given on illegal option selection
$	TYPE SYS$INPUT


				Please enter an ACTION.  HELP gives help.


$	WAIT 00:00:00.30
$  	MISTAKES = MISTAKES + 1	
$	IF MISTAKES .EQ. 3 THEN GOTO HELPO
$	GOTO NEXTO
$ GETSIZE:         !trims the entered option before checking validity
$ 	COMMAND_SIZE = F$LENGTH(COMMAND)
$	INDEX = 0
$! START LOOKING FOR THE COMMAND
$!
$ CHECK_NEXTO:       !is the selected option in the table?
$	OPTION_LENGTH = F$EXTRACT(INDEX,1,OPTION_TABLE)
$	IF OPTION_LENGTH .EQ. 0 THEN GOTO INVALID_COMMAND
$	INDEX = INDEX + 1
$	NEXTO_COMMAND = F$EXTRACT(INDEX,OPTION_LENGTH,OPTION_TABLE)
$ 	FIRST_COMMAND = NEXTO_COMMAND
$! SHOW SYMBOL NEXTO_COMMAND
$	IF F$EXTRACT(0,COMMAND_SIZE,NEXTO_COMMAND) -
		.EQS. COMMAND THEN GOTO LOOK_AGAIN
$	INDEX = INDEX + OPTION_LENGTH
$	GOTO CHECK_NEXTO
$! LOOKING TO CHECK IF COMMAND IS NOT CONFUSED WITH ANY OTHER COMMAND
$!
$ LOOK_AGAIN:
$	INDEX = INDEX + OPTION_LENGTH
$	OPTION_LENGTH = F$EXTRACT(INDEX,1,OPTION_TABLE)
$	IF OPTION_LENGTH .EQ. 0 THEN GOTO 'FIRST_COMMAND'O
$	INDEX = INDEX + 1
$	NEXTO_COMMAND = F$EXTRACT(INDEX,OPTION_LENGTH,OPTION_TABLE)
$!	SHOW SYMBOL NEXTO_COMMAND
$	IF F$EXTRACT(0,COMMAND_SIZE,NEXTO_COMMAND) -
		.EQS. COMMAND THEN GOTO CANNOT_DECIDE
$	GOTO LOOK_AGAIN
$!
$ CANNOT_DECIDE:
$	WRITE SYS$OUTPUT "        CAN'T DECIDE WHAT TO DO MORE LETTERS PLEASE"
$ INVALID_COMMAND:
$ 	WRITE SYS$OUTPUT "                  INVALID COMMAND ", COMMAND 
$	WAIT 00:00:01.00
$  	MISTAKES = MISTAKES + 1	
$	IF MISTAKES .EQ. 2 THEN GOTO HELPO
$ GOTO NEXTO
$ FASTO:    !we do not want this file anymore
$ DEL BB$BAD_MAIL.TXT;
$ WRITE SYS$OUTPUT "FILE DELETE"
$ READO:
$ set on
$ on warning then goto BYEO
$ dir bb$bad_mail.txt;
$ set noon
$!
$!***********************************************************
$! RUN ARPA3    !attempt to add this message to bulletin board
BB$BAD_MAIL.TXT;
$!***********************************************************	
$!
$ goto nexto
$ EDITO:     !edit the file to see if we wish to add to board
$ define/user_mode sys$input sys$command:
$ EDIT/EDT BB$BAD_MAIL.TXT
$ goto NEXTO
$ DELETEO:     !delete option verifies before deleting
$ DIR BB$BAD_MAIL.TXT;
$ INQUIRE GO_DEL "DELETE the above file? (N)"
$ IF GO_DEL .NES. "Y" THEN GOTO NO_DEL
$ DEL BB$BAD_MAIL.TXT;
$ WRITE SYS$OUTPUT "FILE DELETE"
$ goto NEXTO
$ NO_DEL:     !file was not deleted
$ WRITE SYS$OUTPUT "NO FILE DELETE"
$ goto NEXTO
$ MAILO:   !invoke mail utility
$ define/user_mode sys$input sys$command:
$ MAIL
$ goto NEXTO
$ BYEO:     !exit processing
$ set on
$      IF SAVE_MODE THEN SET VERIFY
$ EXIT
