[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module broadcast_handler;


[global,asynchronous,unbound]procedure broadcast_handler;

{Module is used to trap incoming messages from the system.  The user
 may remain in the bulletin board utility or exit.  An informational
 message will be broadcast in the middle of the current screen.}

var 
  locstr : packed array [1..data_length] of char;
  str : string;
  len :  [word] 0..65535;

begin
  smg$get_broadcast_message(pasteboard,locstr,len);

  str := substr(locstr,1,len);

  smg$erase_display(broadcast_display);
  smg$put_chars(broadcast_display,str+chr(0),3,2);
  smg$put_chars(broadcast_display,'Incoming message received:',
                1,(screen_cols DIV 2)-12);
  smg$put_chars(broadcast_display,'Press Q to quit, '+
                'or any other key to continue...',5,(screen_cols DIV 2)-25);
  smg$paste_virtual_display(broadcast_display,pasteboard,screen_rows-8,2);
  smg$cancel_input(keyboard);

  {Procedure getchar will return next keyboard entry;}
  if (getchar in ['Q',key_exit]) then asynch_goto99;
  smg$unpaste_virtual_display(broadcast_display,pasteboard);

end;
end.

