[inherit('sys$Library:starlet','Lib$spawn','smgdefs','smg$repaint_Line',
'BB.PEN')]
module get_uic;

[global] 
procedure get_uic;

{Get uic information used to test who can add and delete to a topic.}

var valid_manager : boolean;	{Is user valid bb_manager?}

begin
  with item_list[1] do
    begin
      length := 4;
      code := jpi$_grp;
      adr::integer_ptr := address(user_group);
      retlen::integer := 0;
    end;
  with item_list[2] do
    begin
      length := 0;
      code := 0;
    end;

  {Get users user group uic number.}
  $getjpi(itmlst:=item_list);
  
  with item_list[1] do
    begin
      length := 4;
      code := jpi$_mem;
      adr::integer_ptr := address(member_group);
      retlen::integer := 0;
    end;
  with item_list[2] do
    begin
      length := 0;
      code := 0;
    end;
  {Get user's member uic number.}
  $getjpi(itmlst:=item_list);   

  {The following section must be modified at each site location to
   reflect UIC information for each of the Bulletin Board managers.
   These numbers can be obtained easily by running @F$GETJPI in the
   account that you want the numbers for.}
  valid_manager := false;

  case user_group of
     1 : case member_group of
           4 : valid_manager := true;   {system}
           otherwise valid_manager := false;
         end;
    11 : case member_group of
	   54 : valid_manager := true;   {userservices account}
	   otherwise valid_manager := false;
         end;
    87 : case member_group of
	   1529,2241,1266 : valid_manager := true;   {howell,paul,bazemore}
	   otherwise valid_manager := false;
         end;
    otherwise valid_manager := false;
  end;

  bb_manager := valid_manager and (file_location=data_logical);

end;
end.
