[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module open_files;

[global] 
procedure open_files;

{Open database file associated with the current category selected.  If
 the file cannot be open, then program will repeat the open attempt for
 all the nodes on the current network.}

begin
  i := 1;
  repeat
    if (user_node = data_nodes[i]) then
      file_location := data_logical
    else      
      file_location := substr(data_nodes[i],1,index(data_nodes[i],' ')-1)+
                            '::'+data_logical;
      write_menu('','Trying to open database on '+
                    substr(data_nodes[i],1,index(data_nodes[i],' ')-1)+'...');
     $setprv(1,prv$m_sysprv);
      open(bbfile,file_location+chosen_file,history:=readonly,
           access_method:=keyed,organization:=indexed,sharing:=readwrite,
           error:=continue);
      i := i+1
  until (status(bbfile) = 0) or (i > num_nodes + 1);
  if (status(bbfile) > 0) then
    begin
      write_menu('','Unable to open database. '+
                    'Press any key to continue...');
      getchar;
      goto99; { this is a procedure not a type "O"}
    end;
  $setprv(0,prv$m_sysprv);
end;
end.
