[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module write_message_data;

[global] procedure write_message_data;

{Message text ready to write to screen.}

var
  message_date : packed array [1..20] of char;
  mns : string;

begin
  if (data_curr^.next <> nil) then
    begin
      dir_display := false;
      data_curr := data_curr^.next;
      smg$begin_pasteboard_update(pasteboard);

      {Update the header information for the message.}
      with dir_curr^ do
        begin
          $asctim(timbuf:=message_date,timadr:=invert(date));
          writev(mns,-number:10);
          mns[index(mns,'-')] := '#';
          smg$erase_display(header_display);
          smg$put_chars(header_display,'Date:     ',1,1,,smg$m_reverse);
          smg$put_chars(header_display,'Topic:    ',1,41,,smg$m_reverse);
          smg$put_chars(header_display,'Posted by:',2,1,,smg$m_reverse);
          smg$put_chars(header_display,'Subject:  ',2,41,,smg$m_reverse);
          smg$put_chars(header_display,message_date,1,12);
          smg$put_chars(header_display,topic,1,52);
          smg$put_chars(header_display,mns+chr(0));
          smg$put_chars(header_display,substr(poster,1,26),2,12);
          smg$put_chars(header_display,substr(subject,1,26),2,52);
        end;

      smg$erase_display(main_display);
      smg$set_cursor_abs(main_display,2,1);
      smg$put_line(main_display,data_curr^.data+chr(0),,,,1);
      if (data_curr^.next <> nil) then 
        begin
          smg$put_chars(main_display,' More pages ',18,35,,smg$m_reverse);
          smg$set_physical_cursor(pasteboard,23,79);
        end
      else
        begin
          smg$put_chars(main_display,' Last page  ',18,35,,smg$m_reverse);
          smg$set_physical_cursor(pasteboard,23,79);
        end;
     smg$end_pasteboard_update(pasteboard);
    end;
end;

end.
